package com.elitesland.scp.application.facade.vo.save.order;

import com.elitesland.scp.utils.ValidatedList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(value = "订货订单明细保存参数(管理端)")
public class ScpDemandOrderDMgmtSaveVO implements Serializable {
    private static final long serialVersionUID = 2310302359745458378L;

    @ApiModelProperty(value = "订货订单ID", required = true)
    @NotNull(message = "订货订单ID不能为空")
    private Long masId;

    @ApiModelProperty("原始id")
    private Long sourceId;

    @ApiModelProperty("SPU商品编码")
    @NotNull(message = "SPU商品编码不能为空")
    private String spuItemCode;
    private String spuItemName;

    @ApiModelProperty(value = "商品id", required = true)
    @NotNull(message = "商品id不能为空")
    private Long itemId;

    @ApiModelProperty(value = "商品编码", required = true)
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty(value = "商品名称", required = true)
    @NotBlank(message = "商品名称不能为空")
    private String itemName;

    @ApiModelProperty("商品分类")
    private String itemType;

    @ApiModelProperty("配送类型")
    private String deliveryType;

    @ApiModelProperty(value = "需求数量", required = true)
    @NotNull(message = "需求数量不能为空")
    private BigDecimal demandQuantity;

    @ApiModelProperty("币种，默认CNY")
    private String currency;

    @ApiModelProperty("运费行标记")
    private Boolean freightLineFlag = false;

    @ApiModelProperty("最小强配数量")
    private BigDecimal minNum;

    private Long activityId;

    @ApiModelProperty("强配活动编码")
    private String activityCode;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("供应明细信息")
    @Valid
    private ValidatedList<SupplyItem> itemList;

    @Data
    public static class SupplyItem implements Serializable {

        private static final long serialVersionUID = 3802099545801358273L;

        @ApiModelProperty(value = "记录唯一ID")
        private Long id;

        @ApiModelProperty(value = "仓库/供应商分配比例", required = true)
        @NotNull(message = "仓库/供应商分配比例不能为空")
        private BigDecimal ratio;

        @ApiModelProperty("拆分需求数量")
        private BigDecimal allocationDeQuantity;

        @ApiModelProperty("分配数量")
        private BigDecimal allocationQuantity;

        @ApiModelProperty(value = "供应类型,WH:仓库，SUPP:供应商", required = true)
        @NotBlank(message = "供应类型不能为空")
        private String supplyType;

        @ApiModelProperty(value = "供应仓库id、供应商id", required = true)
        @NotNull(message = "供应仓库id不能为空")
        private Long suppWhId;

        @ApiModelProperty(value = "供应仓库编码、供应商编码", required = true)
        @NotBlank(message = "供应仓库编码不能为空")
        private String suppWhCode;

        @ApiModelProperty(value = "供应仓库名称、供应商名称", required = true)
        @NotBlank(message = "供应仓库名称不能为空")
        private String suppWhName;

        @ApiModelProperty(value = "供应商ID")
        private Long suppId;

        @ApiModelProperty(value = "供应商编码")
        private String suppCode;

        @ApiModelProperty("供应商名称")
        private String suppName;

        @ApiModelProperty("采购公司id")
        private Long ouId;

        @ApiModelProperty("采购公司编码")
        private String ouCode;

        @ApiModelProperty("采购公司名称")
        private String ouName;

        @ApiModelProperty("分配单据id")
        private Long srcDocId;

        @ApiModelProperty("分配单据编码")
        private String srcDocNo;

        @ApiModelProperty("分配单据类别")
        private String srcDocCls;

        @ApiModelProperty("分配单据明细行号")
        private String srcDocLineNo;

        @ApiModelProperty("发货数量")
        private BigDecimal quantity;

        @ApiModelProperty("是否已计算")
        private Boolean isCalculated;

        @ApiModelProperty("是否已推送")
        private Boolean isPushed;

        @ApiModelProperty("计划数量")
        private BigDecimal planQuantity;

        @ApiModelProperty("订货单位")
        private String unit;
        private String unitName;

        @ApiModelProperty("基本单位")
        private String uom2;
        private String uom2Name;

        @ApiModelProperty("单位转换率")
        private BigDecimal uomRatio;

        @ApiModelProperty("有效位数")
        private Integer decimalPlaces;

        @ApiModelProperty("基本单位数量")
        private BigDecimal qty2;

        @ApiModelProperty("含税单价")
        private BigDecimal price;

        @ApiModelProperty("运费是否计费")
        private Boolean freightFlag;

        @ApiModelProperty("运费比例")
        private BigDecimal freightRatio;

        @ApiModelProperty("销售公司编码")
        private String saleOuCode;

        @ApiModelProperty("销售公司名称")
        private String saleOuName;

        @ApiModelProperty("销售客户编码")
        private String saleCustCode;

        @ApiModelProperty(value = "含税金额")
        private BigDecimal planAmt;

        @ApiModelProperty(value = "商品图片")
        private String imgUrl;

        @ApiModelProperty(value = "配送方式")
        private String deliveryType;

        @ApiModelProperty("货款单价（不含服务费）")
        private BigDecimal salePrice;

        @ApiModelProperty("结算单价")
        private BigDecimal settlementPrice;

        @ApiModelProperty("结算金额")
        private BigDecimal settlementAmt;

        @ApiModelProperty("结算货款单价")
        private BigDecimal settlementSalePrice;

        @ApiModelProperty("结算货款金额")
        private BigDecimal settlementSaleAmt;

        @ApiModelProperty("科技费价格")
        private BigDecimal tefPrice;

        @ApiModelProperty("营销费价格")
        private BigDecimal mefPrice;

        @ApiModelProperty("运营费价格")
        private BigDecimal oefPrice;

        @ApiModelProperty("是否收取项目费用")
        private Boolean isProjFeeCharged;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuCode;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuCode;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuCode;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuName;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuName;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuName;

        @ApiModelProperty("折扣比例")
        private BigDecimal discount;

    }

}
