package com.elitesland.scp.application.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.UserConvert;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:21
 * @Description: 用户相关服务接口
 */
@Component
@Slf4j
public class UserService {
    @Autowired
    private UserRpcService sysUserService;

    public static Long currentUserId() {
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        log.info("当前登录人信息:{}", JSONUtil.toJsonStr(currentUserDTO));
        if (ObjectUtil.isEmpty(currentUserDTO) || currentUserDTO.getUserId() == null) {
            throw new BusinessException("当前登录人查询异常");
        }
        return currentUserDTO.getUserId();
    }

    /**
     * 获取当前用户信息
     *
     * @return 用户信息
     */
    public static CurrentUserDTO currentUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        CurrentUserDTO user = USER_CONVERT.convert(userDetails);
        user.setDetail(USER_CONVERT.convert(userDetails.getUser()));
        user.setUserId(userDetails.getUser().getId());

        return user;
    }

    private static final UserConvert USER_CONVERT = UserConvert.INSTANCE;
}
