package com.elitesland.scp.application.service.common;

import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public interface CommonPriceService {

    /**
     * 获取商品价格和库存信息
     *
     * @param paramVOList  商品信息
     * @param storeCode    门店信息
     * @param orderSetting 价格策略
     * @param type         价格类型
     * @param stockMap     库存信息
     * @return
     */
    @Deprecated
    Map<String, List<PriPriceRpcDTO>> getPriceAndStockDetails(List<AppItemActivityItemPriceParamVO> paramVOList, String storeCode,
                                                              ScpOrderSettingRespVO orderSetting, String type, AtomicReference<Map<String, BigDecimal>> stockMap);

    default Map<String, List<PriPriceRpcDTO>> getPriceAndStockDetails(List<AppItemActivityItemPriceParamVO> paramVOList,
                                                                      String storeCode, ScpOrderSettingRespVO orderSetting,
                                                                      String type) {
        return getPriceAndStockDetails(paramVOList, storeCode, orderSetting, type, null);
    }


    /**
     * 获取商品价格和库存信息
     *
     * @param paramVOList  商品信息
     * @param storeCode    门店信息
     * @param orderSetting 单据类型配置
     * @param type         订货集
     * @param stockMap     库存信息
     * @return
     */
    Map<String, AppItemPriceRespVO> getNewPriceAndStockDetails(List<AppItemActivityItemPriceParamVO> paramVOList, String storeCode,
                                                                     ScpOrderSettingRespVO orderSetting, String type, AtomicReference<Map<String, BigDecimal>> stockMap);

    default Map<String, AppItemPriceRespVO> getNewPriceAndStockDetails(List<AppItemActivityItemPriceParamVO> paramVOList,
                                                                      String storeCode, ScpOrderSettingRespVO orderSetting,
                                                                      String type) {
        return  getNewPriceAndStockDetails(paramVOList, storeCode, orderSetting, type, null);
    }







}
