package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderReplyPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderReplySaveVO;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderReplyConvert;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderReplyDomainService;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderReplyDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpDemandOrderReplyServiceImpl implements ScpDemandOrderReplyService {

    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderReplyDomainService scpDemandOrderReplyDomainService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long create(ScpDemandOrderReplySaveVO saveVO) {
        if (CollUtil.isNotEmpty(saveVO.getPicList())) {
            saveVO.setPics(String.join(";", saveVO.getPicList()));
        }
        Long id = scpDemandOrderReplyDomainService.save(saveVO);
        scpDemandOrderDomainService.updateReplyFlagById(saveVO.getOrderId());
        return id;
    }

    @Override
    public ScpDemandOrderReplyRespVO findReplyByOrderId(Long orderId) {
        Optional<ScpDemandOrderReplyDTO> replyOpt = scpDemandOrderReplyDomainService.findReplyByOrderId(orderId);
        if (replyOpt.isEmpty()) {
            return new ScpDemandOrderReplyRespVO();
        }
        ScpDemandOrderReplyRespVO replyRespVO = ScpDemandOrderReplyConvert.INSTANCE.dtoToRespVO(replyOpt.get());
        replyRespVO.setPicList(StrUtil.split(replyRespVO.getPics(), ";"));
        return replyRespVO;
    }

    @Override
    public PagingVO<ScpDemandOrderReplyPageRespVO> page(ScpDemandOrderReplyPageParamVO paramVO) {
        return scpDemandOrderReplyDomainService.page(paramVO);
    }
}
