package com.elitesland.scp.application.service.supalloc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.supalloc.*;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDtoParam;

import java.util.List;
import java.util.Map;

/**
 * @author jeesie
 */
public interface ScpSupplyAllocationService {


    /**
     * 分页
     * @param queryParam
     * @return
     */
    PagingVO<ScpSupplyAllocationPageVO> page(ScpSupplyAllocationPageParamVO queryParam);

    /**
     * 保存
     * @param createParam
     * @return
     */
    ApiResult saveSupplyAllocation(ScpSupplyAllocatioSaveVO createParam);


    /**
     * 查询配置详情
     * @param param
     * @return
     */
    List<ScpSupplyAllocationRespVO> findSupplyAllocationList(ScpSupplyAllocationParamVO param);


    void deleteWhNetRelation(List<Long> ids);

    /**
     * 查询导出
     * @param queryParam
     * @return
     */
    PagingVO<ScpSupplyAllocationExportRespVO> exportSearch(ScpSupplyAllocationPageParamVO queryParam);


    /**
     * 条件查询
     * @param supplyAllocationRpcDtoParam
     * @return
     */
    List<ScpSupplyAllocationRpcDTO> findSupplyAllocationRpcByParam(ScpSupplyAllocationRpcDtoParam supplyAllocationRpcDtoParam);


    /**
     * 导入
     * @param dataList
     * @param startRowIndex
     * @return
     */
    List<String> importSupplyAllocation(List<ScpSupplyAllocationImportVO> dataList,int startRowIndex);


    /**
     * 计划员数据权限分页
     * @param queryParam
     * @return
     */
    PagingVO<ScpSupplyAllocationPageVO> scpmanAuthorityPage(ScpSupplyAllocationPageParamVO queryParam);

    /**
     * 查询供应商份额分配
     * @param demandWhStCode
     * @param type
     * @param itemCodes
     * @return
     */
    Map<String,List<ScpSupplyAllocationRpcDTO>> findSupplyAllocationByParam(String demandWhStCode, String type, List<String> itemCodes);

    /**
     * 批量删除供应商份额分配
     * @param ids
     */
    void batchDelete(List<Long> ids);
}
