package com.elitesland.scp.domain.vo.article;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(description = "广告链接出参")
@Data
public class ArticleLinkRespVO implements Serializable {
    private static final long serialVersionUID = 4406789299601680378L;
    @ApiModelProperty("文章信息id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("文章名称")
    private String articleName;

    @ApiModelProperty("文章编码")
    private String articleCode;

    @ApiModelProperty("文章作者")
    private String articleAuthor;

    @ApiModelProperty("文章分类名称")
    private String categoryName;
}
