package com.elitesland.scp.infr.repo.article;

import com.elitesland.scp.domain.entity.article.ArticleCategoryDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Set;

/**
 * @auther JinXK
 * @date 2021/6/12 11:25
 */
public interface ArticleCategoryRepo extends JpaRepository<ArticleCategoryDO, Long>, QuerydslPredicateExecutor<ArticleCategoryDO> {

    boolean existsByCategoryName(String categoryName);

    @Transactional
    @Modifying
    @Query(value = "update scp_article_category set sort_no = ?2 where id = ?1", nativeQuery = true)
    Integer updateSortById(Long id, int sortNo);

    @Transactional
    @Modifying
    @Query(value = "update scp_article_category set show_flag = ?2 where id = ?1", nativeQuery = true)
    Integer updateShowById(Long id, String showFlag);

    @Transactional
    @Modifying
    @Query(value = "update scp_article_category set delete_flag = 1 where id = ?1", nativeQuery = true)
    Integer updateDeleteFlagById(Long id);

    @Transactional
    @Modifying
    @Query(value = "update scp_article_category set show_flag = ?2 where pid = ?1", nativeQuery = true)
    Integer updateShowByPid(Long pid, String showFlag);

    long countByPid(Long pid);

    List<ArticleCategoryDO> findByPid(Long id);

    List<ArticleCategoryDO> findByPidIn(Set<Long> collect);

    @Transactional
    @Modifying
    @Query(value = "update scp_article_category set delete_flag = 1 where id in ?1", nativeQuery = true)
    void updateDeleteFlagByIdIn(Set<Long> deleteId);

    @Transactional
    @Modifying
    @Query(value = "update scp_article_category set show_flag = ?2 where pid in ?1", nativeQuery = true)
    void updateShowByPidIn(Set<Long> set, String showFlag);

    @Transactional
    @Modifying
    @Query(value = "update scp_article_category set show_flag = ?2 where id in ?1", nativeQuery = true)
    void updateShowByIdIn(Set<Long> set, String showFlag);
}
