package com.elitesland.scp.infr.repo.calendar;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetRespVO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreCalendarSetDO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreCalendarSetLineDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpStoreCalendarSetRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpStoreCalendarSetDO scpStoreCalendarSetDO = QScpStoreCalendarSetDO.scpStoreCalendarSetDO;

    private static final QScpStoreCalendarSetLineDO scpStoreCalendarSetLineDO = QScpStoreCalendarSetLineDO.scpStoreCalendarSetLineDO;

    public long count(ScpStoreCalendarSetPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpStoreCalendarSetDO.id).distinct()
                .from(scpStoreCalendarSetDO)
                .leftJoin(scpStoreCalendarSetLineDO).on(scpStoreCalendarSetDO.id.eq(scpStoreCalendarSetLineDO.masId));
        jpaQuery.where(this.whereCalendarSet(paramVO));
        return jpaQuery.fetchCount();
    }

    private final QBean<ScpStoreCalendarSetPageRespVO> pageList = Projections.bean(
            ScpStoreCalendarSetPageRespVO.class,
            scpStoreCalendarSetDO.id,
            scpStoreCalendarSetDO.setCode,
            scpStoreCalendarSetDO.setName,
            scpStoreCalendarSetDO.setDescription,
            scpStoreCalendarSetDO.docStatus,
            scpStoreCalendarSetDO.startYear,
            scpStoreCalendarSetDO.endYear,
            scpStoreCalendarSetDO.creator,
            scpStoreCalendarSetDO.createUserId,
            scpStoreCalendarSetDO.createTime,
            scpStoreCalendarSetDO.updater,
            scpStoreCalendarSetDO.modifyUserId,
            scpStoreCalendarSetDO.modifyTime,
            scpStoreCalendarSetDO.type,
            scpStoreCalendarSetDO.deliveryType
    );

    public List<ScpStoreCalendarSetPageRespVO> queryCalendarSet(ScpStoreCalendarSetPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList).distinct()
                .from(scpStoreCalendarSetDO)
                .leftJoin(scpStoreCalendarSetLineDO).on(scpStoreCalendarSetDO.id.eq(scpStoreCalendarSetLineDO.masId));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpStoreCalendarSetDO);
        jpaQuery.where(this.whereCalendarSet(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereCalendarSet(ScpStoreCalendarSetPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getSetName())) {
            predicates.add(scpStoreCalendarSetDO.setName.like("%" + paramVO.getSetName() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpStoreCalendarSetDO.type.eq(paramVO.getType()));
        }
        if (!CollectionUtils.isEmpty(paramVO.getDeliveryTypes())) {
            Predicate deliveryTypePredicate = Expressions.ONE.ne(Expressions.ONE);
            for (String deliveryType : paramVO.getDeliveryTypes()) {
                deliveryTypePredicate = ExpressionUtils.or(deliveryTypePredicate, scpStoreCalendarSetDO.deliveryType.like("%" + deliveryType + "%"));
            }
            predicates.add(deliveryTypePredicate);
        }
        if (StrUtil.isNotBlank(paramVO.getStoreCode())) {
            predicates.add(scpStoreCalendarSetLineDO.storeCode.eq(paramVO.getStoreCode()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            predicates.add(scpStoreCalendarSetLineDO.storeCode.in(paramVO.getStoreCodes()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long deleteByIds(List<Long> ids) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpStoreCalendarSetDO.id.in(ids));
        var delete = jpaQueryFactory.delete(scpStoreCalendarSetDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

    public List<ScpStoreCalendarSetRespVO> findCalendarSet(ScpStoreCalendarSetParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreCalendarSetRespVO.class,
                        scpStoreCalendarSetDO.id,
                        scpStoreCalendarSetDO.setCode
                ))
                .from(scpStoreCalendarSetDO);
        if (StrUtil.isNotBlank(paramVO.getSetCode())) {
            jpaQuery.where(scpStoreCalendarSetDO.setCode.eq(paramVO.getSetCode()));
        }
        return jpaQuery.fetch();
    }

    public void approveUpdateApplyAlter(List<Long> ids, String docStatus, ProcInstStatus procInstStatus,
                                        String approveComment, LocalDateTime apprTime) {
        jpaQueryFactory
                .update(scpStoreCalendarSetDO)
                .set(scpStoreCalendarSetDO.docStatus, docStatus)
                .set(scpStoreCalendarSetDO.procInstStatus, procInstStatus)
                .set(scpStoreCalendarSetDO.approveComment, approveComment)
                .set(scpStoreCalendarSetDO.apprTime, apprTime)
                .set(scpStoreCalendarSetDO.approvedTime, apprTime)
                .where(scpStoreCalendarSetDO.id.in(ids))
                .execute();
    }

    public void applyChangeUpdate(Long id, String docStatus, ProcInstStatus procInstStatus) {
        jpaQueryFactory
                .update(scpStoreCalendarSetDO)
                .set(scpStoreCalendarSetDO.docStatus, docStatus)
                .set(scpStoreCalendarSetDO.submitTime, LocalDateTime.now())
                .set(scpStoreCalendarSetDO.procInstStatus, procInstStatus)
                .where(scpStoreCalendarSetDO.id.eq(id))
                .execute();
    }
}
