package com.elitesland.scp.infr.repo.wqf;

import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountApplyDDO;
import com.elitesland.scp.infr.dto.wqf.ScpWqfEntAccountApplyDDTO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-02-27
* @Version 1.0
**/
@Repository
public interface ScpWqfEntAccountApplyDRepo extends JpaRepository<ScpWqfEntAccountApplyDDO, Long>, QuerydslPredicateExecutor<ScpWqfEntAccountApplyDDO> {

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_wqf_ent_account_apply_d where mas_id = ?1 ", nativeQuery = true)
    void deleteByMasId(Long masId);

    List<ScpWqfEntAccountApplyDDO> findByMasId(Long masId);

    List<ScpWqfEntAccountApplyDDO> findAllByMasIdIn(List<Long> masIds);


    @Transactional(rollbackFor = Exception.class)
    void deleteAllByMasIdIn(List<Long> masIds);


}
