package com.elitesland.scp.infr.repo.wqf;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyPageParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyPageVO;
import com.elitesland.scp.domain.entity.wqf.QScpWqfEntAccountApplyDDO;
import com.elitesland.scp.domain.entity.wqf.QScpWqfEntAccountApplyDO;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountApplyDO;
import com.elitesland.scp.enums.UdcEnum;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-02-27
* @Version 1.0
**/
@Component
public class ScpWqfEntAccountApplyRepoProc extends BaseRepoProc<ScpWqfEntAccountApplyDO> {

    private static final QScpWqfEntAccountApplyDO qScpWqfEntAccountApplyDO = QScpWqfEntAccountApplyDO.scpWqfEntAccountApplyDO;
    public ScpWqfEntAccountApplyRepoProc(){
        super(qScpWqfEntAccountApplyDO);
    }

    private static final QScpWqfEntAccountApplyDDO qScpWqfEntAccountApplyDDO = QScpWqfEntAccountApplyDDO.scpWqfEntAccountApplyDDO;



    public PagingVO<ScpWqfEntAccountApplyPageVO> page(ScpWqfEntAccountApplyPageParam param){
        JPAQuery<ScpWqfEntAccountApplyPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpWqfEntAccountApplyPageVO.class,
                qScpWqfEntAccountApplyDO.id,
                qScpWqfEntAccountApplyDO.tenantId,
                qScpWqfEntAccountApplyDO.remark,
                qScpWqfEntAccountApplyDO.createUserId,
                qScpWqfEntAccountApplyDO.creator,
                qScpWqfEntAccountApplyDO.createTime,
                qScpWqfEntAccountApplyDO.modifyUserId,
                qScpWqfEntAccountApplyDO.updater,
                qScpWqfEntAccountApplyDO.modifyTime,
                qScpWqfEntAccountApplyDO.deleteFlag,
                qScpWqfEntAccountApplyDO.auditDataVersion,
                qScpWqfEntAccountApplyDO.ouId,
                qScpWqfEntAccountApplyDO.ouCode,
                qScpWqfEntAccountApplyDO.entId,
                qScpWqfEntAccountApplyDO.applyStatus,
                qScpWqfEntAccountApplyDO.docNo,
                qScpWqfEntAccountApplyDO.errorMsg
        )).from(qScpWqfEntAccountApplyDO);
        jpaQuery.where(where(param));
        return queryByPage(jpaQuery,param.getPageRequest());
    }

    private Predicate where(ScpWqfEntAccountApplyPageParam param){
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if(CollectionUtils.isNotEmpty(param.getOuIds())){
            predicate = ExpressionUtils.and(predicate, qScpWqfEntAccountApplyDO.ouId.in(param.getOuIds()));
        }
        if(StringUtils.isNotEmpty(param.getDocNo())){
            predicate = ExpressionUtils.and(predicate, qScpWqfEntAccountApplyDO.docNo.like("%"+param.getDocNo()+"%"));
        }
        if(StringUtils.isNotEmpty(param.getEntId())){
            predicate = ExpressionUtils.and(predicate, qScpWqfEntAccountApplyDO.entId.like("%"+param.getEntId()+"%"));
        }
        if(StringUtils.isNotEmpty(param.getApplyStatus())){
            predicate = ExpressionUtils.and(predicate, qScpWqfEntAccountApplyDO.applyStatus.eq(param.getApplyStatus()));
        }
        if(CollectionUtils.isNotEmpty(param.getStoreIds())){
            predicate = ExpressionUtils.and(predicate, qScpWqfEntAccountApplyDO.id.in(
                    jpaQueryFactory.select(qScpWqfEntAccountApplyDDO.masId).from(qScpWqfEntAccountApplyDDO)
                            .where(qScpWqfEntAccountApplyDDO.storeId.in(param.getStoreIds()))
            ));
        }
        return predicate;
    }

    public List<ScpWqfEntAccountApplyDO> findAllByDocNo(String docNo){
         return jpaQueryFactory.select(qScpWqfEntAccountApplyDO).from(qScpWqfEntAccountApplyDO)
                 .where(qScpWqfEntAccountApplyDO.docNo.eq(docNo)
                         .and(qScpWqfEntAccountApplyDO.applyStatus.ne(UdcEnum.WQF_APPLY_STATUS_SUCESS.getValueCode()))).fetch();
    }






}