package com.elitesland.scp.rmi;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/6/24 11:16
 * @Description:
 */
@Service
@AllArgsConstructor
@Slf4j
public class RmiTransactionPathService {

    private final SupportTransactionPathRpcService supportTransactionPathRpcService;

    public List<SupportTransactionPathRpcDTO> queryListByParam(List<SupportTransactionPathRpcParam> rpcParams) {

        log.info("查询启用状态的结算路径,参数:{}", JSONObject.toJSONString(rpcParams));
        ApiResult<List<SupportTransactionPathRpcDTO>> apiResult =
                supportTransactionPathRpcService.queryListByParam(rpcParams);
        log.info("查询启用状态的结算路径结束,返回:{}", JSONObject.toJSONString(apiResult));

        Assert.isTrue(apiResult.isSuccess(), apiResult.getMsg());

        List<SupportTransactionPathRpcDTO> resultList = apiResult.getData();

        Assert.notNull(resultList, "没查询启用状态的结算路径");

        rpcParams.stream().forEach(item ->
                Assert.isTrue(resultList.stream().filter(result -> result.getCompanyIdStart().equals(item.getCompanyIdStart()) &&
                                result.getCompanyIdEnd().equals(item.getCompanyIdEnd())).findFirst().isPresent(),
                        "没查询启用状态的结算路径"));

        return resultList;
    }
}
