/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CustBaseInfoDTO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScmsmanLoginStoreRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityBusinessTypeVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityComponentVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityComponentService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityConvert;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityManager;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepoProc;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.support.provider.item.service.ItemRecvAddressRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpsmanAuthprityComponentImportImpl
implements ScpsmanAuthorityComponentService {
    private static final Logger log = LoggerFactory.getLogger(ScpsmanAuthprityComponentImportImpl.class);
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiSalRpcService rmiSalRpcService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final RmiSysUDCService rmiSysUDCService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ItemRecvAddressRpcService itemRecvAddressRpcService;
    private final ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc;
    private final ScpDemandAuthorityManager scpDemandAuthorityManager;

    @Override
    @SysCodeProc
    public PagingVO<ScpsmanAuthorityComponentVO> salemansAuthorityComponentPage(ScpManAuthorityParam paramVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.queryAuthorit(paramVO);
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return PagingVO.builder().total(0L).records(null).build();
        }
        List<ScpsmanAuthorityComponentVO> collect = this.getScpsmanAuthorityComponentVOS(paramVO, scpManAuthorityPageRespVOPagingVO.getRecords());
        return PagingVO.builder().total(scpManAuthorityPageRespVOPagingVO.getTotal()).records(collect).build();
    }

    @NotNull
    private List<ScpsmanAuthorityComponentVO> getScpsmanAuthorityComponentVOS(ScpManAuthorityParam paramVO, List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO) {
        ScpManAuthorityPageRespVO scpManAuthorityPageRespVO1 = scpManAuthorityPageRespVOPagingVO.get(0);
        String businessTypes = scpManAuthorityPageRespVO1.getBusinessType();
        ArrayList<ScpManAuthorityBusinessTypeVO> scpManAuthorityBusinessTypeVOS = new ArrayList<ScpManAuthorityBusinessTypeVO>();
        if (!StringUtils.isBlank((CharSequence)businessTypes)) {
            Map<String, String> businessTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "BUSINESS_TYPE");
            List<String> businessTypeList = Arrays.stream(businessTypes.split(",")).toList();
            for (String businessType : businessTypeList) {
                ScpOrderSettingRespVO cacheByBusinessType = this.scpOrderSettingDomainService.findCacheByBusinessType(businessType, String.valueOf(paramVO.getType()));
                ScpManAuthorityBusinessTypeVO scpManAuthorityBusinessTypeVO = new ScpManAuthorityBusinessTypeVO();
                scpManAuthorityBusinessTypeVO.setBusinessType(businessType);
                scpManAuthorityBusinessTypeVO.setBusinessTypeName(businessTypeUDCMap.get(businessType));
                scpManAuthorityBusinessTypeVO.setAllowDiscount(cacheByBusinessType.getAllowDiscount());
                scpManAuthorityBusinessTypeVOS.add(scpManAuthorityBusinessTypeVO);
            }
        }
        List<ScpsmanAuthorityComponentVO> collect = scpManAuthorityPageRespVOPagingVO.stream().map(ScpDemandAuthorityConvert.INSTANCE::pageVoToComponentVo).collect(Collectors.toList());
        List<String> storeCodeList = collect.stream().map(ScpsmanAuthorityComponentVO::getStWhCode).filter(ObjectUtil::isNotNull).distinct().collect(Collectors.toList());
        GeneralUserDetails userDetails = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        List<String> userNames = this.getCandidateStoreCodeByUser(userDetails);
        if (!userNames.isEmpty()) {
            log.info("\u67e5\u8be2\u95e8\u5e97\uff1a{}", (Object)JSONUtil.toJsonString(userNames));
            OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
            storeParam.setStoreCodeList(userNames);
            List storeList = (List)this.orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
            if (CollUtil.isNotEmpty((Collection)storeList)) {
                String defStoreCode = ((OrgStoreBaseRpcDTO)storeList.get(0)).getStoreCode();
                storeCodeList = List.of(defStoreCode);
                collect = collect.stream().filter(t -> defStoreCode.equals(t.getStWhCode())).collect(Collectors.toList());
            }
        }
        Map<String, OrgStoreBaseRpcDTO> storeMap = this.rmiOrgStoreRpcService.getOrgStoreBaseMap(storeCodeList);
        collect.stream().filter(t -> storeMap.containsKey(t.getStWhCode())).forEach(t -> {
            OrgStoreBaseRpcDTO orgStoreRpcDTO = (OrgStoreBaseRpcDTO)storeMap.get(t.getStWhCode());
            t.setStoreType2(orgStoreRpcDTO.getStoreType2());
            t.setStCustCode(orgStoreRpcDTO.getCustCode());
            t.setStCustName(orgStoreRpcDTO.getCustName());
            t.setStWhName(orgStoreRpcDTO.getStoreName());
            t.setBrandCode(orgStoreRpcDTO.getBrandCode());
            t.setStoreOuCode(orgStoreRpcDTO.getOuCode());
            t.setDailyFlag(orgStoreRpcDTO.getDailyFlag());
            t.setPreDailyFlag(orgStoreRpcDTO.getPreDailyFlag());
            t.setHasAddress(this.itemRecvAddressRpcService.hasAddress(orgStoreRpcDTO.getStoreCode()));
            if (CollectionUtil.isNotEmpty((Collection)scpManAuthorityBusinessTypeVOS)) {
                t.setBusinessTypeAuths(scpManAuthorityBusinessTypeVOS);
            }
            if (UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(t.getScpsmanType())) {
                if (((Boolean)this.orgStoreRpcService.existStorePayPassword(t.getStWhCode()).computeData()).booleanValue()) {
                    t.setPasswordSetFlag(Boolean.FALSE);
                } else {
                    t.setPasswordSetFlag(Boolean.TRUE);
                }
            } else {
                t.setPasswordSetFlag(Boolean.FALSE);
            }
        });
        return collect;
    }

    @Override
    public List<ScpsmanAuthorityComponentVO> storeList(ScpManAuthorityParam paramVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOS = this.scpDemandAuthorityRepoProc.queryPageDemandAuthorityDistinct(paramVO);
        this.scpDemandAuthorityManager.convertRegionName(scpManAuthorityPageRespVOS, t -> ScpUdcEnum.SCPSMAN_AUTHORITY_TYPE_1.getValueCode().equals("" + t.getType()), ScpManAuthorityPageRespVO::getRegion, ScpManAuthorityPageRespVO::setRegionName);
        return this.getScpsmanAuthorityComponentVOS(paramVO, scpManAuthorityPageRespVOS);
    }

    @Override
    public List<ScpManAuthorityBusinessTypeVO> businessTypeQuery(ScpManAuthorityParam paramVO) {
        return List.of();
    }

    @Override
    public ScpsmanAuthorityComponentVO appQuery(ScpManAuthorityParam paramVO) {
        paramVO.setType(0L);
        PagingVO<ScpsmanAuthorityComponentVO> scpManAuthorityPageRespVOPagingVO = this.salemansAuthorityComponentPage(paramVO);
        if (scpManAuthorityPageRespVOPagingVO.isNotEmpty()) {
            ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO = (ScpsmanAuthorityComponentVO)scpManAuthorityPageRespVOPagingVO.getRecords().get(0);
            log.info("\u3010appQuery\u3011\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8d26\u53f7\u5bf9\u5e94\u7684\u8ba1\u5212\u5458\u6743\u9650\u6240\u5c5e\u95e8\u5e97\u7ed3\u679c\uff1a{}", (Object)cn.hutool.json.JSONUtil.toJsonStr((Object)scpsmanAuthorityComponentVO));
            if (UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(scpsmanAuthorityComponentVO.getScpsmanType())) {
                if (((Boolean)this.orgStoreRpcService.existStorePayPassword(scpsmanAuthorityComponentVO.getStWhCode()).computeData()).booleanValue()) {
                    scpsmanAuthorityComponentVO.setPasswordSetFlag(Boolean.FALSE);
                } else {
                    scpsmanAuthorityComponentVO.setPasswordSetFlag(Boolean.TRUE);
                }
            } else {
                scpsmanAuthorityComponentVO.setPasswordSetFlag(Boolean.FALSE);
            }
            this.storeTypeQuery(scpsmanAuthorityComponentVO);
            return scpsmanAuthorityComponentVO;
        }
        return null;
    }

    private void storeTypeQuery(ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO) {
        List<CustBaseDTO> custBaseInfoDTOList;
        if (Objects.isNull(scpsmanAuthorityComponentVO)) {
            return;
        }
        OrgStoreDetailRpcDTO byCode = this.rmiOrgStoreRpcService.getByCode(scpsmanAuthorityComponentVO.getStWhCode());
        if (Objects.nonNull(byCode)) {
            scpsmanAuthorityComponentVO.setStoreType2(byCode.getStoreType2());
            scpsmanAuthorityComponentVO.setStoreType2Name(byCode.getStoreType2Name());
            scpsmanAuthorityComponentVO.setStoreOuCode(byCode.getOuCode());
            if (StringUtils.isBlank((CharSequence)scpsmanAuthorityComponentVO.getStCustCode())) {
                scpsmanAuthorityComponentVO.setStCustCode(byCode.getCustCode());
                scpsmanAuthorityComponentVO.setStCustName(byCode.getCustName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)scpsmanAuthorityComponentVO.getStCustCode()) && CollectionUtil.isNotEmpty(custBaseInfoDTOList = this.rmiSalRpcService.findBaseByParam(Collections.singletonList(scpsmanAuthorityComponentVO.getStCustCode())))) {
            List<CustBaseInfoDTO> custBaseInfoDTOS;
            CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
            scpsmanAuthorityComponentVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());
            if (StringUtils.isNotBlank((CharSequence)scpsmanAuthorityComponentVO.getStoreCustCode()) && CollectionUtil.isNotEmpty(custBaseInfoDTOS = this.rmiSalRpcService.getCustBaseInfoByCode(Collections.singletonList(scpsmanAuthorityComponentVO.getStoreCustCode())))) {
                CustBaseInfoDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
                scpsmanAuthorityComponentVO.setStoreCustName(custBaseInfoDTO1.getCustName());
                if (Objects.equals(custBaseInfoDTO1.getCustType2(), "A")) {
                    scpsmanAuthorityComponentVO.setStoreCustType2Flag(true);
                }
            }
        }
    }

    @Override
    public List<String> loginAndTypeQuery(ScpManAuthorityParam paramVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        paramVO.setEnableStatus(true);
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.listQuery(paramVO);
        if (CollUtil.isEmpty(scpManAuthorityPageRespVOPagingVO)) {
            return new ArrayList<String>();
        }
        return scpManAuthorityPageRespVOPagingVO.stream().map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
    }

    @Override
    public ApiResult<ScmsmanLoginStoreRespVO> getLoginStoreByCurrentUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUser)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        ScmsmanLoginStoreRespVO respVO = new ScmsmanLoginStoreRespVO();
        respVO.setOnlyOne(false);
        GeneralUserDetails userDetails = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        List<String> userNames = this.getCandidateStoreCodeByUser(userDetails);
        if (userNames.isEmpty()) {
            return ApiResult.ok((Object)respVO);
        }
        log.info("\u67e5\u8be2\u95e8\u5e97\uff1a{}", (Object)JSONUtil.toJsonString(userNames));
        OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
        storeParam.setStoreCodeList(userNames);
        List storeList = (List)this.orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
        if (CollUtil.isEmpty((Collection)storeList)) {
            return ApiResult.ok((Object)respVO);
        }
        respVO.setStoreCodeDef(((OrgStoreBaseRpcDTO)storeList.get(0)).getStoreCode());
        respVO.setOnlyOne(true);
        return ApiResult.ok((Object)respVO);
    }

    private List<String> getCandidateStoreCodeByUser(GeneralUserDetails userDetails) {
        ArrayList<String> userNames = new ArrayList<String>(4);
        String loginAccount = userDetails.getLoginAccount();
        if (StrUtil.isNotBlank((CharSequence)loginAccount)) {
            if (loginAccount.equals(userDetails.getUser().getMobile())) {
                return Collections.emptyList();
            }
            userNames.add(loginAccount);
        }
        if (StrUtil.isNotBlank((CharSequence)userDetails.getUser().getEmployeeCode())) {
            userNames.add(userDetails.getUser().getEmployeeCode());
        }
        return userNames;
    }

    public ScpsmanAuthprityComponentImportImpl(ScpDemandAuthorityService scpDemandAuthorityService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiSalRpcService rmiSalRpcService, ScpOrderSettingDomainService scpOrderSettingDomainService, RmiSysUDCService rmiSysUDCService, OrgStoreRpcService orgStoreRpcService, ItemRecvAddressRpcService itemRecvAddressRpcService, ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc, ScpDemandAuthorityManager scpDemandAuthorityManager) {
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiSalRpcService = rmiSalRpcService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.itemRecvAddressRpcService = itemRecvAddressRpcService;
        this.scpDemandAuthorityRepoProc = scpDemandAuthorityRepoProc;
        this.scpDemandAuthorityManager = scpDemandAuthorityManager;
    }
}

