/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.calendar;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetComputeParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLineParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetApproveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetImportDTO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSaveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSubmitVO;
import com.elitesland.scp.application.service.calendar.ScpStoreCalendarSetService;
import com.elitesland.scp.domain.convert.calendar.ScpStoreCalendarSetConvert;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.service.calendar.ScpStoreCalendarSetDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreCalendarSetLineDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.calendar.ScpStoreCalendarSetDTO;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.utils.CalendarBuilder;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ScpStoreCalendarSetServiceImpl
implements ScpStoreCalendarSetService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreCalendarSetServiceImpl.class);
    private final ScpStoreCalendarSetDomainService scpStoreCalendarSetDomainService;
    private final ScpStoreCalendarSetLineDomainService scpStoreCalendarSetLineDomainService;
    private final TransactionTemplate transactionTemplate;
    private final ScpStoreDemandCalendarDomainService scpStoreDemandCalendarDomainService;
    private final TaskExecutor taskExecutor;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ScpStoreCalendarSetPageRespVO> page(ScpStoreCalendarSetPageParamVO paramVO) {
        return this.scpStoreCalendarSetDomainService.queryCalendarSetList(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveCalendarSet(ScpStoreCalendarSetSaveVO saveVO) {
        this.checkSetting(saveVO);
        return this.scpStoreCalendarSetDomainService.saveCalendarSet(saveVO);
    }

    @Override
    @SysCodeProc
    public Optional<ScpStoreCalendarSetRespVO> findCalendarSetById(Long id) {
        return this.scpStoreCalendarSetDomainService.findCalendarSetById(id).map(ScpStoreCalendarSetConvert.INSTANCE::dtoToRespVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpStoreCalendarSetDomainService.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submit(ScpStoreCalendarSetSubmitVO submitVO) {
        ScpStoreCalendarSetLineParamVO scpStoreCalendarSetLineParamVO = new ScpStoreCalendarSetLineParamVO();
        scpStoreCalendarSetLineParamVO.setMasId(submitVO.getId());
        Long count = this.scpStoreCalendarSetLineDomainService.countCalendarSetLine(scpStoreCalendarSetLineParamVO);
        if (count == 0L) {
            throw new BusinessException("\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.scpStoreCalendarSetDomainService.applyChangeUpdate(submitVO.getId(), ScpUdcEnum.CALENDAR_SET_STATUS_APPRING.getValueCode(), ProcInstStatus.APPROVING);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchApprove(ScpStoreCalendarSetApproveVO approveSaveParam) {
        this.scpStoreCalendarSetDomainService.approveUpdateApplyAlter(approveSaveParam.getIds(), ScpUdcEnum.CALENDAR_SET_STATUS_COMPLETE.getValueCode(), ProcInstStatus.APPROVED, approveSaveParam.getApproveComment(), LocalDateTime.now());
        for (Long id : approveSaveParam.getIds()) {
            this.batchSaveCalendar(id);
        }
    }

    private void batchSaveCalendar(Long id) {
        Optional<ScpStoreCalendarSetDTO> calendarSetDTO = this.scpStoreCalendarSetDomainService.findCalendarSetById(id);
        if (calendarSetDTO.isEmpty()) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e\u4fe1\u606f");
        }
        log.info("\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u4fdd\u5b58\u5f00\u59cb\uff1a{}", (Object)JSONObject.toJSONString(calendarSetDTO));
        ScpStoreCalendarSetDTO scpStoreCalendarSetDTO = calendarSetDTO.get();
        Integer startYear = scpStoreCalendarSetDTO.getStartYear();
        LocalDate startOfYear = LocalDate.of((int)startYear, 1, 1);
        List<ScpStoreCalendarSetLineRespVO> storeRegionList = this.scpStoreCalendarSetLineDomainService.findStoreCodeByMasId(id, startYear);
        List<String> storeRegionCodes = storeRegionList.stream().map(ScpStoreCalendarSetLineRespVO::getStoreCode).collect(Collectors.toList());
        this.scpStoreDemandCalendarDomainService.deleteByStoreAndYearAndDeliveryType(scpStoreCalendarSetDTO.getType(), storeRegionCodes, startYear.toString(), scpStoreCalendarSetDTO.getDeliveryType());
        if (ScpUdcEnum.CALENDAR_TYPE_STORE.getValueCode().equals(scpStoreCalendarSetDTO.getType())) {
            this.buildAndSaveCalendar(id, storeRegionList, startOfYear, scpStoreCalendarSetDTO.getDeliveryType(), scpStoreCalendarSetDTO.getType());
        } else {
            List<OrgStoreBaseRpcDTO> storeList = this.rmiOrgStoreRpcService.findSimpleByRegion(storeRegionCodes);
            if (CollectionUtil.isNotEmpty(storeList)) {
                List<String> storeCodes = storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).distinct().collect(Collectors.toList());
                this.scpStoreDemandCalendarDomainService.deleteByStoreAndYearAndDeliveryType(ScpUdcEnum.CALENDAR_TYPE_STORE.getValueCode(), storeCodes, startYear.toString(), scpStoreCalendarSetDTO.getDeliveryType());
            }
            log.info("\u6279\u91cf\u4fdd\u5b58\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u5f00\u59cb\uff1a{}", storeRegionList);
            this.buildAndSaveCalendar(id, storeRegionList, startOfYear, scpStoreCalendarSetDTO.getDeliveryType(), scpStoreCalendarSetDTO.getType());
        }
    }

    private void buildAndSaveCalendar(Long id, List<ScpStoreCalendarSetLineRespVO> storeRegionList, LocalDate startOfYear, String deliveryType, String type) {
        ScpStoreCalendarSetComputeParamVO computeParamVO = this.getScpStoreCalendarSetComputeParamVO(id, storeRegionList);
        for (int i = 0; i < 12; ++i) {
            log.info("\u5f00\u59cb\u5199\u5165:{}\u6708\u4efd\u533a\u57df/\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\uff0ccomputeParamVO\u4e3a\uff1a{}", (Object)(i + 1), (Object)JSONObject.toJSONString((Object)computeParamVO));
            this.transactionTemplate.setPropagationBehavior(3);
            int finalI = i;
            this.transactionTemplate.execute(trans -> {
                try {
                    LocalDate startDate = startOfYear.plusMonths(finalI);
                    LocalDate endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
                    List<ScpStoreDemandCalendarDO> scpStoreDemandCalendarDOS = CalendarBuilder.buildCalendarSetList(startDate, endDate, computeParamVO, deliveryType, type);
                    this.scpStoreDemandCalendarDomainService.batchInsert(scpStoreDemandCalendarDOS, 10000);
                    return "OK";
                }
                catch (Exception e) {
                    trans.setRollbackOnly();
                    throw new BusinessException(ApiCode.FAIL, e.getMessage());
                }
            });
            log.info("\u7ed3\u675f\u5199\u5165:{}\u6708\u4efd\u533a\u57df/\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386", (Object)(i + 1));
        }
    }

    private ScpStoreCalendarSetComputeParamVO getScpStoreCalendarSetComputeParamVO(Long masId, List<ScpStoreCalendarSetLineRespVO> storeInfos) {
        List<ScpStoreCalendarSetLineRespVO> monList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 1);
        List<ScpStoreCalendarSetLineRespVO> tuesList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 2);
        List<ScpStoreCalendarSetLineRespVO> wendsList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 3);
        List<ScpStoreCalendarSetLineRespVO> thursList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 4);
        List<ScpStoreCalendarSetLineRespVO> friList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 5);
        List<ScpStoreCalendarSetLineRespVO> saturList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 6);
        List<ScpStoreCalendarSetLineRespVO> sunList = this.scpStoreCalendarSetLineDomainService.findCalendarSetByParam(masId, 7);
        ScpStoreCalendarSetComputeParamVO computeParamVO = new ScpStoreCalendarSetComputeParamVO();
        computeParamVO.setMonList(monList);
        computeParamVO.setTuesList(tuesList);
        computeParamVO.setWendsList(wendsList);
        computeParamVO.setThursList(thursList);
        computeParamVO.setFriList(friList);
        computeParamVO.setSaturList(saturList);
        computeParamVO.setSunList(sunList);
        computeParamVO.setStoreInfos(storeInfos);
        computeParamVO.setNonMonList(this.findMissingList(monList, storeInfos));
        computeParamVO.setNonTuesList(this.findMissingList(tuesList, storeInfos));
        computeParamVO.setNonWendsList(this.findMissingList(wendsList, storeInfos));
        computeParamVO.setNonThursList(this.findMissingList(thursList, storeInfos));
        computeParamVO.setNonFriList(this.findMissingList(friList, storeInfos));
        computeParamVO.setNonSaturList(this.findMissingList(saturList, storeInfos));
        computeParamVO.setNonSunList(this.findMissingList(sunList, storeInfos));
        return computeParamVO;
    }

    public List<ScpStoreCalendarSetLineRespVO> findMissingList(List<ScpStoreCalendarSetLineRespVO> filterList, List<ScpStoreCalendarSetLineRespVO> storeInfos) {
        Set storeCodesInList = filterList.stream().map(ScpStoreCalendarSetLineRespVO::getStoreCode).collect(Collectors.toCollection(HashSet::new));
        return storeInfos.stream().filter(storeInfo -> !storeCodesInList.contains(storeInfo.getStoreCode())).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchReject(ScpStoreCalendarSetApproveVO approveSaveParam) {
        this.scpStoreCalendarSetDomainService.approveUpdateApplyAlter(approveSaveParam.getIds(), ScpUdcEnum.CALENDAR_SET_STATUS_REJECTED.getValueCode(), ProcInstStatus.REJECTED, approveSaveParam.getApproveComment(), LocalDateTime.now());
    }

    private void checkSetting(ScpStoreCalendarSetSaveVO saveVO) {
        if (saveVO.getEndYear() == null) {
            saveVO.setEndYear(saveVO.getStartYear());
        }
        ScpStoreCalendarSetParamVO scpStoreCalendarSetParamVO = new ScpStoreCalendarSetParamVO();
        scpStoreCalendarSetParamVO.setSetCode(saveVO.getSetCode());
        scpStoreCalendarSetParamVO.setEndYear(saveVO.getEndYear());
        scpStoreCalendarSetParamVO.setStartYear(saveVO.getStartYear());
        List<ScpStoreCalendarSetRespVO> calendarSets = this.scpStoreCalendarSetDomainService.findCalendarSet(scpStoreCalendarSetParamVO);
        if (CollUtil.isNotEmpty(calendarSets)) {
            ScpStoreCalendarSetRespVO scpStoreCalendarSetRespVO = calendarSets.get(0);
            if (!(saveVO.getId() != null && saveVO.getId().equals(scpStoreCalendarSetRespVO.getId()) || saveVO.getSetCode() == null || saveVO.getSetCode().equals(scpStoreCalendarSetRespVO.getSetCode()))) {
                throw new BusinessException("\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        if (saveVO.getId() == null) {
            saveVO.setDocStatus(ScpUdcEnum.CALENDAR_SET_STATUS_DR.getValueCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeImport(List<ScpStoreCalendarSetImportDTO> scpStoreCalendarSetImportDTO) {
        for (ScpStoreCalendarSetImportDTO scpStoreCalendarSetDTO : scpStoreCalendarSetImportDTO) {
            Integer startYear = scpStoreCalendarSetDTO.getStartYear();
            LocalDate startOfYear = LocalDate.of((int)startYear, 1, 1);
            List<String> storeRegionCodes = scpStoreCalendarSetDTO.getStoreRegionCodeList();
            this.scpStoreDemandCalendarDomainService.deleteByStoreAndYearAndDeliveryType(scpStoreCalendarSetDTO.getType(), storeRegionCodes, startYear.toString(), scpStoreCalendarSetDTO.getDeliveryType());
            if (ScpUdcEnum.CALENDAR_TYPE_STORE.getValueCode().equals(scpStoreCalendarSetDTO.getType())) {
                this.buildAndSaveCalendar2(scpStoreCalendarSetDTO, startOfYear, scpStoreCalendarSetDTO.getDeliveryType(), scpStoreCalendarSetDTO.getType());
                continue;
            }
            List<OrgStoreBaseRpcDTO> storeList = this.rmiOrgStoreRpcService.findSimpleByRegion(storeRegionCodes);
            if (CollectionUtil.isNotEmpty(storeList)) {
                List<String> storeCodes = storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).distinct().collect(Collectors.toList());
                this.scpStoreDemandCalendarDomainService.deleteByStoreAndYearAndDeliveryType(ScpUdcEnum.CALENDAR_TYPE_STORE.getValueCode(), storeCodes, startYear.toString(), scpStoreCalendarSetDTO.getDeliveryType());
            }
            log.info("\u6279\u91cf\u4fdd\u5b58\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u5f00\u59cb\uff1a{}", (Object)JSONObject.toJSONString((Object)scpStoreCalendarSetDTO));
            this.buildAndSaveCalendar2(scpStoreCalendarSetDTO, startOfYear, scpStoreCalendarSetDTO.getDeliveryType(), scpStoreCalendarSetDTO.getType());
        }
    }

    private void buildAndSaveCalendar2(ScpStoreCalendarSetImportDTO importDTO, LocalDate startOfYear, String deliveryType, String type) {
        ScpStoreCalendarSetComputeParamVO computeParamVO = new ScpStoreCalendarSetComputeParamVO();
        computeParamVO.setMonList(importDTO.getMonday());
        computeParamVO.setTuesList(importDTO.getTuesday());
        computeParamVO.setWendsList(importDTO.getWednesday());
        computeParamVO.setThursList(importDTO.getThursday());
        computeParamVO.setFriList(importDTO.getFriday());
        computeParamVO.setSaturList(importDTO.getSaturday());
        computeParamVO.setSunList(importDTO.getSunday());
        computeParamVO.setNonMonList(importDTO.getMonday2());
        computeParamVO.setNonTuesList(importDTO.getTuesday2());
        computeParamVO.setNonWendsList(importDTO.getWednesday2());
        computeParamVO.setNonThursList(importDTO.getThursday2());
        computeParamVO.setNonFriList(importDTO.getFriday2());
        computeParamVO.setNonSaturList(importDTO.getSaturday2());
        computeParamVO.setNonSunList(importDTO.getSunday2());
        for (int i = 0; i < 12; ++i) {
            log.info("\u5f00\u59cb\u5199\u5165:{}\u6708\u4efd\u533a\u57df/\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\uff0ccomputeParamVO\u4e3a\uff1a{}", (Object)(i + 1), (Object)JSONObject.toJSONString((Object)computeParamVO));
            this.transactionTemplate.setPropagationBehavior(3);
            int finalI = i;
            this.transactionTemplate.execute(trans -> {
                try {
                    LocalDate startDate = startOfYear.plusMonths(finalI);
                    LocalDate endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
                    List<ScpStoreDemandCalendarDO> scpStoreDemandCalendarDOS = CalendarBuilder.buildCalendarSetList(startDate, endDate, computeParamVO, deliveryType, type);
                    this.scpStoreDemandCalendarDomainService.batchInsert(scpStoreDemandCalendarDOS, 10000);
                    return "OK";
                }
                catch (Exception e) {
                    trans.setRollbackOnly();
                    throw new BusinessException(ApiCode.FAIL, e.getMessage());
                }
            });
            log.info("\u7ed3\u675f\u5199\u5165:{}\u6708\u4efd\u533a\u57df/\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386", (Object)(i + 1));
        }
    }

    public ScpStoreCalendarSetServiceImpl(ScpStoreCalendarSetDomainService scpStoreCalendarSetDomainService, ScpStoreCalendarSetLineDomainService scpStoreCalendarSetLineDomainService, TransactionTemplate transactionTemplate, ScpStoreDemandCalendarDomainService scpStoreDemandCalendarDomainService, TaskExecutor taskExecutor, RmiOrgStoreRpcService rmiOrgStoreRpcService) {
        this.scpStoreCalendarSetDomainService = scpStoreCalendarSetDomainService;
        this.scpStoreCalendarSetLineDomainService = scpStoreCalendarSetLineDomainService;
        this.transactionTemplate = transactionTemplate;
        this.scpStoreDemandCalendarDomainService = scpStoreDemandCalendarDomainService;
        this.taskExecutor = taskExecutor;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
    }
}

