/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.calendar;

import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreQueryParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreRespVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarSaveVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarExportRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreDemandCalendarRespVO;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.elitesland.scp.domain.convert.calendar.ScpStoreDemandCalendarConvert;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpStoreDemandCalendarServiceImpl
implements ScpStoreDemandCalendarService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreDemandCalendarServiceImpl.class);
    private final ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final UdcProvider udcProvider;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO param) {
        PagingVO<ScpStoreDemandCalendarPageVO> page;
        if (Boolean.TRUE.equals(param.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> userAuthority = this.scpDemandAuthorityService.getCurrentUserAuthority();
            if (userAuthority.isEmpty()) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            this.extractedAuthorityParam(param, userAuthority);
        }
        if (CollectionUtils.isNotEmpty((Collection)(page = this.storeDemandCalendarDomainService.searchPage(param)).getRecords())) {
            HashSet<String> typeSet = new HashSet<String>();
            HashSet<String> storeCodeSet = new HashSet<String>();
            HashSet<String> yearSet = new HashSet<String>();
            HashSet<String> monthSet = new HashSet<String>();
            HashSet<String> deliverySet = new HashSet<String>();
            for (ScpStoreDemandCalendarPageVO record : page.getRecords()) {
                Optional.ofNullable(record.getStoreCode()).ifPresent(storeCodeSet::add);
                Optional.ofNullable(record.getDeliveryType()).ifPresent(deliverySet::add);
                Optional.ofNullable(record.getYear()).ifPresent(yearSet::add);
                Optional.ofNullable(record.getMonth()).ifPresent(monthSet::add);
                Optional.ofNullable(record.getType()).ifPresent(typeSet::add);
            }
            List<String> strings = page.getRecords().stream().map(d -> d.getType() + d.getStoreCode() + d.getYear() + d.getMonth() + d.getDeliveryType()).toList();
            List<ScpStoreDemandCalendarDO> calendarDos = this.storeDemandCalendarDomainService.findByConcatYearAndMonthAndDeliveryTypeKey(typeSet, storeCodeSet, yearSet, monthSet, deliverySet);
            Map<String, List<ScpStoreDemandCalendarDO>> listMap = calendarDos.stream().filter(v -> strings.contains(v.getType() + v.getStoreCode() + v.getYear() + v.getMonth() + v.getDeliveryType())).collect(Collectors.groupingBy(v -> v.getType() + v.getStoreCode() + v.getYear() + v.getMonth() + v.getDeliveryType()));
            Map deliveryTypeMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2");
            Map calendarConfigMethod = this.udcProvider.getValueMapByUdcCode("yst-supp", "CALENDAR_CONFIG_METHOD");
            page.getRecords().forEach(d -> {
                List calendarDOList;
                if (StringUtils.isNotBlank((CharSequence)d.getDeliveryType())) {
                    d.setDeliveryTypeName(Stream.of(d.getDeliveryType().split(",")).filter(deliveryTypeMap::containsKey).map(deliveryTypeMap::get).collect(Collectors.joining(",")));
                }
                if (StringUtils.isNotBlank((CharSequence)d.getType())) {
                    d.setTypeName((String)calendarConfigMethod.get(d.getType()));
                }
                if (CollectionUtils.isNotEmpty((Collection)(calendarDOList = (List)listMap.get(d.getType() + d.getStoreCode() + d.getYear() + d.getMonth() + d.getDeliveryType())))) {
                    d.setId(((ScpStoreDemandCalendarDO)calendarDOList.get(0)).getId());
                    List<ScpStoreDemandCalendarPageVO.CalendarDayDetail> details = calendarDOList.stream().map(m -> {
                        ScpStoreDemandCalendarPageVO.CalendarDayDetail detail = ScpStoreDemandCalendarConvert.INSTANCE.doToPageVo((ScpStoreDemandCalendarDO)m);
                        detail.setDay(m.getDay());
                        detail.setWorkStatus(m.getWorkStatus());
                        return detail;
                    }).toList();
                    List<ScpStoreDemandCalendarPageVO.CalendarDayDetail> sortList = details.stream().filter(v -> v.getDay() != null).sorted(this.getComparing()).collect(Collectors.toList());
                    d.setDayDetails(sortList);
                }
            });
        }
        return page;
    }

    private void extractedAuthorityParam(BaseScpmanAuthorityParam queryParam, PagingVO<ScpManAuthorityPageRespVO> userAuthority) {
        List<String> whCodes = userAuthority.stream().filter(v -> 1 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhCode).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> stores = userAuthority.stream().filter(v -> 0 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhCode).filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhCodes(whCodes);
        queryParam.setStores(stores);
        queryParam.setScpmanAuthority(Boolean.TRUE);
    }

    private Comparator<ScpStoreDemandCalendarPageVO.CalendarDayDetail> getComparing() {
        return Comparator.comparing(v -> Integer.parseInt(v.getDay()), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveStoreCalendar(ScpStoreDemandCalendarSaveVO createParam) {
        List<OrgStoreBaseRpcDTO> storeList;
        List<ScpStoreDemandCalendarDO> calendarDOList = this.buildDate(createParam);
        if (ScpUdcEnum.CALENDAR_TYPE_REGION.getValueCode().equals(createParam.getType()) && CollectionUtils.isNotEmpty(storeList = this.rmiOrgStoreRpcService.findSimpleByRegion(List.of(createParam.getStoreCode())))) {
            List<String> storeCodes = storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).distinct().collect(Collectors.toList());
            this.storeDemandCalendarDomainService.deleteByStoreAndYearAndMonthAndDeliveryType(ScpUdcEnum.CALENDAR_TYPE_STORE.getValueCode(), storeCodes, createParam.getYear(), createParam.getMonth(), createParam.getDeliveryType());
        }
        this.storeDemandCalendarDomainService.deleteByStoreAndYearAndMonthAndDeliveryType(createParam.getType(), List.of(createParam.getStoreCode()), createParam.getYear(), createParam.getMonth(), createParam.getDeliveryType());
        ArrayList<ScpStoreDemandCalendarDO> cdo = new ArrayList<ScpStoreDemandCalendarDO>();
        for (ScpStoreDemandCalendarDO demandCalendarDO : calendarDOList) {
            String[] typeList;
            for (String type : typeList = demandCalendarDO.getDeliveryType().split(",")) {
                ScpStoreDemandCalendarDO demandCalendarDO1 = new ScpStoreDemandCalendarDO();
                BeanUtils.copyProperties((Object)demandCalendarDO, (Object)demandCalendarDO1, (String[])new String[0]);
                demandCalendarDO1.setDeliveryType(type);
                cdo.add(demandCalendarDO1);
            }
        }
        this.storeDemandCalendarDomainService.createBatch(cdo);
    }

    private List<ScpStoreDemandCalendarDO> buildDate(ScpStoreDemandCalendarSaveVO createParam) {
        return createParam.getDayDetails().stream().map(d -> {
            ScpStoreDemandCalendarDO demandCalendarDO = ScpStoreDemandCalendarConvert.INSTANCE.saveVoToDo((ScpStoreDemandCalendarSaveVO.CalendarDayDetail)d);
            demandCalendarDO.setDay(d.getDay());
            demandCalendarDO.setWorkStatus(d.getWorkStatus());
            demandCalendarDO.setStoreCode(createParam.getStoreCode());
            demandCalendarDO.setStoreId(createParam.getStoreId());
            demandCalendarDO.setStoreName(createParam.getStoreName());
            demandCalendarDO.setYear(createParam.getYear());
            demandCalendarDO.setMonth(createParam.getMonth());
            demandCalendarDO.setType(createParam.getType());
            demandCalendarDO.setDeliveryType(createParam.getDeliveryType());
            return demandCalendarDO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ScpStoreDemandCalendarRespVO> listCalendarVOs(ScpStoreDemandCalendarParam scpStoreDemandCalendarParam) {
        return ScpStoreDemandCalendarConvert.INSTANCE.dtoToRespVO(this.storeDemandCalendarDomainService.listCalendarDTOs(scpStoreDemandCalendarParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteStoreCalendar(List<ScpStoreDemandCalendarParamVO> deleteParams) {
        List<Long> ids;
        long nullcount = deleteParams.stream().filter(d -> d.getYear() == null).count();
        if (nullcount > 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u5e74\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long nullcount2 = deleteParams.stream().filter(d -> d.getMonth() == null).count();
        if (nullcount2 > 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet<String> typeSet = new HashSet<String>();
        HashSet<String> storeCodeSet = new HashSet<String>();
        HashSet<String> yearSet = new HashSet<String>();
        HashSet<String> monthSet = new HashSet<String>();
        HashSet<String> deliverySet = new HashSet<String>();
        for (ScpStoreDemandCalendarParamVO record : deleteParams) {
            Optional.ofNullable(record.getStoreCode()).ifPresent(storeCodeSet::add);
            Optional.ofNullable(record.getDeliveryType()).ifPresent(deliverySet::add);
            Optional.ofNullable(record.getYear()).ifPresent(yearSet::add);
            Optional.ofNullable(record.getMonth()).ifPresent(monthSet::add);
            Optional.ofNullable(record.getType()).ifPresent(typeSet::add);
        }
        List concatKey = deleteParams.stream().map(d -> d.getType() + d.getStoreCode() + d.getYear() + d.getMonth() + d.getDeliveryType()).collect(Collectors.toList());
        List<ScpStoreDemandCalendarDO> demandCalendarDOS = this.storeDemandCalendarDomainService.findByConcatYearAndMonthAndDeliveryTypeKey(typeSet, storeCodeSet, yearSet, monthSet, deliverySet);
        if (CollectionUtils.isNotEmpty(demandCalendarDOS) && CollectionUtils.isNotEmpty(ids = demandCalendarDOS.stream().filter(v -> concatKey.contains(v.getType() + v.getStoreCode() + v.getYear() + v.getMonth() + v.getDeliveryType())).map(BaseModel::getId).distinct().toList())) {
            this.storeDemandCalendarDomainService.deleteBatch(ids);
        }
    }

    @Override
    public ScpStoreDemandCalendarRespVO findStoreCalendarDetail(ScpStoreDemandCalendarParamVO param) {
        ScpStoreDemandCalendarRespVO vo = new ScpStoreDemandCalendarRespVO();
        List<ScpStoreDemandCalendarDTO> calendarDOS = this.storeDemandCalendarDomainService.findStoreCalendarByParam(param);
        if (CollectionUtils.isEmpty(calendarDOS)) {
            return vo;
        }
        if (param.getMonth() != null && param.getYear() != null) {
            List calendarRespVOS = calendarDOS.stream().map(ScpStoreDemandCalendarConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
            ScpStoreDemandCalendarRespVO calendarRespVO = (ScpStoreDemandCalendarRespVO)calendarRespVOS.get(0);
            BeanCopyUtil.beanCopyWithIngore((Object)calendarRespVO, (Object)vo, (String[])BeanCopyUtil.getNullAndIgnorePropertyNames((Object)calendarRespVO, (String[])new String[0]));
            List<ScpStoreDemandCalendarRespVO> vos = calendarRespVOS.stream().filter(d -> d.getDay() != null).sorted(this.getComparing2()).collect(Collectors.toList());
            vo.setDayDetails(vos);
            List<String> years = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getYear).distinct().collect(Collectors.toList());
            List<String> months = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getMonth).distinct().collect(Collectors.toList());
            List<String> days = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getDay).distinct().collect(Collectors.toList());
            vo.setExistYears(years);
            vo.setExistMonthsOfYear(months);
            vo.setExistDaysOfMonth(days);
        } else if (param.getYear() != null && param.getMonth() == null) {
            years = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getYear).distinct().collect(Collectors.toList());
            List<String> months = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getMonth).distinct().collect(Collectors.toList());
            vo.setExistYears(years);
            vo.setExistMonthsOfYear(months);
        } else if (param.getYear() == null && param.getMonth() == null) {
            years = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getYear).distinct().collect(Collectors.toList());
            vo.setExistYears(years);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getDeliveryType())) {
            Map deliveryTypeMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2");
            vo.setDeliveryTypeName(Stream.of(vo.getDeliveryType().split(",")).filter(deliveryTypeMap::containsKey).map(deliveryTypeMap::get).collect(Collectors.joining(",")));
        }
        return vo;
    }

    @Override
    public Boolean isExistStoreByDateAndWorkStatus(ScpCalendarStoreQueryParamVO paramVO) {
        return CollectionUtils.isNotEmpty(this.storeDemandCalendarDomainService.listStoreByQueryParam(paramVO));
    }

    @Override
    public List<ScpCalendarStoreRespVO> listCalendarStoreByParam(ScpCalendarStoreQueryParamVO paramVO) {
        return this.storeDemandCalendarDomainService.listStoreByQueryParam(paramVO);
    }

    private Comparator<ScpStoreDemandCalendarRespVO> getComparing2() {
        return Comparator.comparing(v -> Integer.parseInt(v.getDay()), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    @Override
    public PagingVO<ScpStoreCalendarExportRespVO> export(ScpStoreDemandCalendarPageParamVO paramVO) {
        PagingVO<ScpStoreDemandCalendarPageVO> scpStoreDemandCalendarPageVOPagingVO = this.searchPage(paramVO);
        if (scpStoreDemandCalendarPageVOPagingVO.isEmpty()) {
            return PagingVO.empty();
        }
        List records = scpStoreDemandCalendarPageVOPagingVO.getRecords();
        List<ScpStoreCalendarExportRespVO> scpStoreCalendarExportRespVOS = records.stream().map(p -> {
            ScpStoreCalendarExportRespVO exportVO = ScpStoreDemandCalendarConvert.INSTANCE.pageVOtoExportVO((ScpStoreDemandCalendarPageVO)p);
            List<ScpStoreDemandCalendarPageVO.CalendarDayDetail> dayDetails = p.getDayDetails();
            if (CollectionUtils.isNotEmpty(dayDetails)) {
                Map<String, String> dayMap = dayDetails.stream().filter(detail -> detail.getDay() != null && detail.getWorkStatus() != null).collect(Collectors.toMap(ScpStoreDemandCalendarPageVO.CalendarDayDetail::getDay, ScpStoreDemandCalendarPageVO.CalendarDayDetail::getWorkStatus, (existing, replacement) -> existing));
                exportVO.setOne(dayMap.get("1"));
                exportVO.setTwo(dayMap.get("2"));
                exportVO.setThree(dayMap.get("3"));
                exportVO.setFour(dayMap.get("4"));
                exportVO.setFive(dayMap.get("5"));
                exportVO.setSix(dayMap.get("6"));
                exportVO.setSeven(dayMap.get("7"));
                exportVO.setEight(dayMap.get("8"));
                exportVO.setNine(dayMap.get("9"));
                exportVO.setTen(dayMap.get("10"));
                exportVO.setEleven(dayMap.get("11"));
                exportVO.setTwelve(dayMap.get("12"));
                exportVO.setThirteen(dayMap.get("13"));
                exportVO.setFourteen(dayMap.get("14"));
                exportVO.setFifteen(dayMap.get("15"));
                exportVO.setSixteen(dayMap.get("16"));
                exportVO.setSeventeen(dayMap.get("17"));
                exportVO.setEighteen(dayMap.get("18"));
                exportVO.setNineteen(dayMap.get("19"));
                exportVO.setTwenty(dayMap.get("20"));
                exportVO.setTwentyOne(dayMap.get("21"));
                exportVO.setTwentyTwo(dayMap.get("22"));
                exportVO.setTwentyThree(dayMap.get("23"));
                exportVO.setTwentyFour(dayMap.get("24"));
                exportVO.setTwentyFive(dayMap.get("25"));
                exportVO.setTwentySix(dayMap.get("26"));
                exportVO.setTwentySeven(dayMap.get("27"));
                exportVO.setTwentyEight(dayMap.get("28"));
                exportVO.setTwentyNine(dayMap.get("29"));
                exportVO.setThirty(dayMap.get("30"));
                exportVO.setThirtyOne(dayMap.get("31"));
            }
            return exportVO;
        }).toList();
        return PagingVO.builder().total(scpStoreDemandCalendarPageVOPagingVO.getTotal()).records(scpStoreCalendarExportRespVOS).build();
    }

    public ScpStoreDemandCalendarServiceImpl(ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService, ScpDemandAuthorityService scpDemandAuthorityService, UdcProvider udcProvider, RmiOrgStoreRpcService rmiOrgStoreRpcService) {
        this.storeDemandCalendarDomainService = storeDemandCalendarDomainService;
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.udcProvider = udcProvider;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
    }
}

