/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetPageRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.domain.convert.order.ScpDemandSetConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandSetDO;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandSetRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandSetRepoProc;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpDemandSetDomainServiceImpl
implements ScpDemandSetDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandSetDomainServiceImpl.class);
    private final ScpDemandSetRepo scpDemandSetRepo;
    private final ScpDemandSetRepoProc scpDemandSetRepoProc;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandSetPageRespVO> queryDemandSetList(ScpDemandSetPageParamVO paramVO) {
        long count = this.scpDemandSetRepoProc.countDemandSet(paramVO);
        if (count > 0L) {
            List<ScpDemandSetPageRespVO> demandSet = this.scpDemandSetRepoProc.queryDemandSet(paramVO);
            List<Long> demandIds = demandSet.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            Map<Long, Long> itemQtyMap = this.scpDemandOrderDRepoProc.getDemandSumItem(demandIds);
            demandSet.forEach(row -> {
                int qty = itemQtyMap.get(row.getId()) == null ? 0 : ((Long)itemQtyMap.get(row.getId())).intValue();
                row.setDemandItemQty(qty);
                if (row.getExpireTime() != null) {
                    row.setExpireTimeStr(row.getExpireTime().toLocalTime().format(formatter));
                }
            });
            return new PagingVO(count, demandSet);
        }
        return new PagingVO();
    }

    @Override
    @SysCodeProc
    public Optional<ScpDemandSetDTO> findDemandSetById(Long id) {
        return this.scpDemandSetRepo.findById(id).map(ScpDemandSetConvert.INSTANCE::doToDto);
    }

    @Override
    public Long saveDemandSet(ScpDemandSetSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpDemandSetDO intentDO = ScpDemandSetConvert.INSTANCE.saveVoToDO(saveVO);
            return ((ScpDemandSetDO)this.scpDemandSetRepo.save(intentDO)).getId();
        }
        Optional option = this.scpDemandSetRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u96c6ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpDemandSetConvert.INSTANCE.copySaveParamToDo(saveVO, (ScpDemandSetDO)option.get());
        Long masId = ((ScpDemandSetDO)this.scpDemandSetRepo.save((ScpDemandSetDO)option.get())).getId();
        return masId;
    }

    @Override
    public void enableDemandSet(List<Long> ids, Boolean enable) {
        this.scpDemandSetRepoProc.enableDemandSet(ids, enable);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        this.scpDemandSetRepoProc.deleteByIds(ids);
    }

    @Override
    public List<ScpDemandSetDTO> findDemandSetByIds(List<Long> ids) {
        return this.scpDemandSetRepo.findByIdIn(ids).stream().map(ScpDemandSetConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public List<ScpDemandSetDTO> findDemandSetByParam(ScpDemandSetParamVO paramVO) {
        return this.scpDemandSetRepoProc.findDemandSetByParam(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDemandSetMsgByIds(List<Long> ids, String msg) {
        this.scpDemandSetRepoProc.updateDemandSetMsgByIds(ids, msg);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDemandSetPushMsgById(List<Long> ids, String msg) {
        this.scpDemandSetRepoProc.updateDemandSetPushMsgById(ids, msg);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void completePushById(Long id) {
        this.scpDemandSetRepoProc.completePushById(id);
    }

    @Override
    public Boolean getDemandSetStatusById(Long id) {
        return this.scpDemandSetRepoProc.getDemandSetStatusById(id);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandSetPageRespVO> commonPage(ScpDemandSetPageParamVO paramVO) {
        long count = this.scpDemandSetRepoProc.countDemandSet(paramVO);
        if (count > 0L) {
            List<ScpDemandSetPageRespVO> demandSet = this.scpDemandSetRepoProc.queryDemandSet(paramVO);
            return new PagingVO(count, demandSet);
        }
        return new PagingVO();
    }

    public ScpDemandSetDomainServiceImpl(ScpDemandSetRepo scpDemandSetRepo, ScpDemandSetRepoProc scpDemandSetRepoProc, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc) {
        this.scpDemandSetRepo = scpDemandSetRepo;
        this.scpDemandSetRepoProc = scpDemandSetRepoProc;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
    }
}

