/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayRpcDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayRpcDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderUpdatePayStatusMqParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountRespVO;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepoProc;
import com.elitesland.scp.pay.config.EntpayProperties;
import com.elitesland.scp.pay.service.AccountLinkService;
import com.elitesland.scp.pay.service.NotifyVerifyService;
import com.elitesland.scp.pay.service.PaymentService;
import com.elitesland.scp.pay.vo.OnlinePayOrderParamVO;
import com.elitesland.scp.pay.vo.PayOrderReqDTO;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.api.Redirect;
import com.tenpay.business.entpay.mse.sdk.common.NotifyHandler;
import com.tenpay.business.entpay.mse.sdk.config.EntpayConfig;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.FrontCallbackUrl;
import com.tenpay.business.entpay.mse.sdk.model.Goods;
import com.tenpay.business.entpay.mse.sdk.model.PayerInfo;
import com.tenpay.business.entpay.mse.sdk.model.PaymentMpParam;
import com.tenpay.business.entpay.mse.sdk.model.PaymentNotifyModel;
import com.tenpay.business.entpay.mse.sdk.model.PaymentNotifyUrl;
import com.tenpay.business.entpay.mse.sdk.model.PaymentParam;
import com.tenpay.business.entpay.mse.sdk.model.PaymentPayee;
import com.tenpay.business.entpay.mse.sdk.model.PaymentQRParam;
import com.tenpay.business.entpay.mse.sdk.model.PaymentRiskControl;
import com.tenpay.business.entpay.mse.sdk.model.SceneInfo;
import com.tenpay.business.entpay.mse.sdk.model.StoreInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaymentServiceImpl
implements PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceImpl.class);
    private final NotifyVerifyService notifyVerifyService;
    private final RedisWrapper redisWrapper;
    private final RedisUtils redisUtils;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final AccountLinkService accountLinkService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc;

    @Override
    public Payment createMpPay(PayOrderReqDTO param) throws EntpayException {
        PaymentMpParam paymentMpParam = this.constructMPPaymentParam(param);
        log.info("\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u8c03\u7528\u5fae\u4f01\u4ed8\u4e0b\u5355\u63a5\u53e3\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)paymentMpParam));
        Payment mpPay = Payment.createMpPay((PaymentMpParam)paymentMpParam);
        log.info("\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u4e0b\u5355\u6210\u529f\uff0cpaymentId:{}", (Object)mpPay.getPaymentId());
        return mpPay;
    }

    @Override
    public Redirect createMpPayOnline(OnlinePayOrderParamVO param) {
        try {
            String docCls = param.getDocNo().substring(0, 2);
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            Redirect redirect = this.buildPayItems(param, "MP", docCls, goodsList);
            if (redirect != null) {
                return redirect;
            }
            PayOrderReqDTO paymentMpParam = this.buildPaymentMapParam(param, goodsList);
            Payment payment = this.createMpPay(paymentMpParam);
            ScpOrderUpdatePayStatusMqParam updateParamVO = new ScpOrderUpdatePayStatusMqParam();
            updateParamVO.setBusinessKey("scp_order_update_pay_status");
            updateParamVO.setDocNo(param.getDocNo());
            updateParamVO.setPaymentId(payment.getPaymentId());
            updateParamVO.setAmt(param.getAmt());
            updateParamVO.setPayerName(param.getPayerName());
            updateParamVO.setDocCls(docCls);
            this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_order_update_pay_status", (Serializable)updateParamVO);
            return this.accountLinkService.createPaymentLink(payment.getPaymentId(), param.getDocNo(), paymentMpParam.getExpireTime());
        }
        catch (EntpayException e) {
            throw new BusinessException("\u5fae\u4f01\u4ed8\u652f\u4ed8\u5931\u8d25" + e.getMessage());
        }
    }

    private Redirect buildPayItems(OnlinePayOrderParamVO param, String source, String docCls, List<Goods> goodsList) {
        Object obj = this.redisUtils.get("SCP_ONLINE_PAY:" + param.getDocNo());
        if (obj != null) {
            Redirect redirect = (Redirect)JSON.parseObject((String)((String)obj), Redirect.class);
            if ("MP".equals(source) && redirect.getMiniProgram() == null) {
                throw new BusinessException("\u8bf7\u4f7f\u7528PC\u7aef\u626b\u7801\u652f\u4ed8");
            }
            if ("QR".equals(source) && redirect.getStaticQrcode() == null) {
                throw new BusinessException("\u8bf7\u4f7f\u7528\u5c0f\u7a0b\u5e8f\u652f\u4ed8");
            }
        }
        if ("PO".equals(docCls)) {
            onlinePayInfo = this.rmiPurRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                return (Redirect)JSON.parseObject((String)((String)obj), Redirect.class);
            }
            List podList = onlinePayInfo.getPoItems();
            BigDecimal totalQty = podList.stream().map(PurPoOnlinePayRpcDTO.PoItem::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            Goods goods = Goods.builder().goodName("\u5fae\u4f01\u4ed8\u652f\u4ed8\u5546\u54c1").goodNumber(Integer.valueOf(totalQty.intValue())).goodAmount(Long.valueOf(param.getAmt().multiply(new BigDecimal("100")).longValue())).build();
            goodsList.add(goods);
        } else {
            onlinePayInfo = this.rmiInvStkRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                return (Redirect)JSON.parseObject((String)((String)obj), Redirect.class);
            }
            List troDList = onlinePayInfo.getItems();
            BigDecimal totalQty = troDList.stream().map(InvTroOnlinePayRpcDTO.TroItem::getTroQty2).reduce(BigDecimal.ZERO, BigDecimal::add);
            Goods goods = Goods.builder().goodName("\u5fae\u4f01\u4ed8\u652f\u4ed8\u5546\u54c1").goodNumber(Integer.valueOf(totalQty.intValue())).goodAmount(Long.valueOf(param.getAmt().multiply(new BigDecimal("100")).longValue())).build();
            goodsList.add(goods);
        }
        return null;
    }

    private PayOrderReqDTO buildPaymentMapParam(OnlinePayOrderParamVO param, List<Goods> goodsList) {
        PayOrderReqDTO paymentMpParam = new PayOrderReqDTO();
        paymentMpParam.setOutPaymentId(param.getDocNo());
        paymentMpParam.setAmount(param.getAmt().multiply(new BigDecimal("100")).longValue());
        paymentMpParam.setCurrency("CNY");
        Date now = new Date();
        paymentMpParam.setExpireTime(new Date(now.getTime() + 86400000L));
        paymentMpParam.setEntId(param.getEntId());
        paymentMpParam.setEntName(param.getEntName());
        paymentMpParam.setMemo(param.getRemark());
        paymentMpParam.setAttachment(param.getRemark());
        paymentMpParam.setDeviceId(param.getStoreCode());
        paymentMpParam.setPayerClientIp(param.getClientIp());
        paymentMpParam.setPayerUa(param.getPayerUa());
        paymentMpParam.setCreateTime(new Date());
        paymentMpParam.setStoreId(param.getStoreCode());
        paymentMpParam.setStoreName(param.getStoreName());
        paymentMpParam.setMpPath(param.getMpPath());
        paymentMpParam.setGoods(goodsList);
        paymentMpParam.setPayerType(param.getPayerType());
        paymentMpParam.setPayerName(param.getPayerName());
        ScpWqfEntAccountRespVO scpWqfEntAccountRespVO = this.scpWqfEntAccountRepoProc.getEntAcctIdByStoreIdAndEntId(param.getStoreCode(), param.getEntId());
        if (scpWqfEntAccountRespVO != null) {
            paymentMpParam.setEntAccId(scpWqfEntAccountRespVO.getEntAcctId());
            if (StrUtil.isBlank((CharSequence)scpWqfEntAccountRespVO.getBankAccount())) {
                throw new BusinessException("\u6536\u6b3e\u94f6\u884c\u8d26\u53f7\u4e3a\u7a7a");
            }
            paymentMpParam.setBankAccountLast4(scpWqfEntAccountRespVO.getBankAccount().substring(scpWqfEntAccountRespVO.getBankAccount().length() - 4));
        }
        return paymentMpParam;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Redirect createQrCodePayOnline(OnlinePayOrderParamVO param) {
        try {
            String docCls = param.getDocNo().substring(0, 2);
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            Redirect redirect = this.buildPayItems(param, "QR", docCls, goodsList);
            if (redirect != null) {
                return redirect;
            }
            PayOrderReqDTO paymentMpParam = this.buildPaymentMapParam(param, goodsList);
            Payment qrCodePay = this.createQrCodePay(paymentMpParam);
            ScpOrderUpdatePayStatusMqParam updateParamVO = new ScpOrderUpdatePayStatusMqParam();
            updateParamVO.setBusinessKey("scp_order_update_pay_status");
            updateParamVO.setDocNo(param.getDocNo());
            updateParamVO.setPaymentId(qrCodePay.getPaymentId());
            updateParamVO.setAmt(param.getAmt());
            updateParamVO.setPayerName(param.getPayerName());
            updateParamVO.setDocCls(docCls);
            this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_order_update_pay_status", (Serializable)updateParamVO);
            return this.accountLinkService.createPaymentLink(qrCodePay.getPaymentId(), param.getDocNo(), paymentMpParam.getExpireTime());
        }
        catch (EntpayException e) {
            throw new BusinessException("\u5fae\u4f01\u4ed8\u652f\u4ed8\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public Payment createQrCodePay(PayOrderReqDTO param) throws EntpayException {
        PaymentQRParam paymentQRParam = this.constructQRPaymentParam(param);
        log.info("\u4e8c\u7ef4\u7801\u652f\u4ed8\u8c03\u7528\u5fae\u4f01\u4ed8\u4e0b\u5355\u63a5\u53e3\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)paymentQRParam));
        Payment qrCodePay = Payment.createQrCodePay((PaymentQRParam)paymentQRParam);
        log.info("\u4e8c\u7ef4\u7801\u652f\u4ed8\u4e0b\u5355\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)qrCodePay));
        return qrCodePay;
    }

    @Override
    public String paymentNotify(String body, String authorization) throws EntpayException, JSONException {
        PaymentNotifyModel model = (PaymentNotifyModel)NotifyHandler.handlerWebhook((String)body, (String)authorization, PaymentNotifyModel.class, (PublicKey)EntpayConfig.getRealTbepPublicKey(null));
        log.info("\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr((Object)model));
        this.notifyVerifyService.processNotify(model);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("retcode", 0);
        jsonObject.put("retmsg", (Object)"SUCCESS");
        return jsonObject.toString();
    }

    private PaymentQRParam constructQRPaymentParam(PayOrderReqDTO param) {
        PaymentQRParam paymentQRParam = new PaymentQRParam();
        BeanUtils.copyProperties((Object)this.constructCommonParam(param), (Object)paymentQRParam);
        Object o = this.redisWrapper.apply(() -> this.redisUtils.get("ENT_PAY_PROPERTIES"), null);
        if (o == null) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5fae\u4f01\u4ed8\u4fe1\u606f");
        }
        EntpayProperties entpayProperties = (EntpayProperties)JSONUtil.toBean((String)o.toString(), EntpayProperties.class);
        PaymentNotifyUrl paymentNotifyUrl = PaymentNotifyUrl.builder().serverNotifyUrl(entpayProperties.getServerNotifyUrl()).build();
        paymentQRParam.setNotifyUrl(paymentNotifyUrl);
        return paymentQRParam;
    }

    private PaymentMpParam constructMPPaymentParam(PayOrderReqDTO param) {
        PaymentMpParam paymentMpParam = new PaymentMpParam();
        BeanUtils.copyProperties((Object)this.constructCommonParam(param), (Object)paymentMpParam);
        Object o = this.redisWrapper.apply(() -> this.redisUtils.get("ENT_PAY_PROPERTIES"), null);
        if (o == null) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5fae\u4f01\u4ed8\u4fe1\u606f");
        }
        EntpayProperties entpayProperties = (EntpayProperties)JSONUtil.toBean((String)o.toString(), EntpayProperties.class);
        FrontCallbackUrl frontCallbackUrl = FrontCallbackUrl.builder().mpAppid(entpayProperties.getMpAppid()).mpUsername(entpayProperties.getMpUsername()).mpPath(param.getMpPath()).build();
        PaymentNotifyUrl paymentNotifyUrl = PaymentNotifyUrl.builder().serverNotifyUrl(entpayProperties.getServerNotifyUrl()).frontCallbackUrl(frontCallbackUrl).build();
        paymentMpParam.setNotifyUrl(paymentNotifyUrl);
        return paymentMpParam;
    }

    private PaymentParam constructCommonParam(PayOrderReqDTO param) {
        PaymentPayee payee = PaymentPayee.builder().entId(param.getEntId()).entName(param.getEntName()).entAcctId(param.getEntAccId()).bankAccountNumberLast4(param.getBankAccountLast4()).build();
        List<Goods> goodsList = param.getGoods();
        PaymentRiskControl paymentRiskControl = PaymentRiskControl.builder().deviceId(param.getDeviceId()).payerClientIp(param.getPayerClientIp()).payerUa(param.getPayerUa()).createTime(param.getCreateTime()).pickType(param.getPickType()).pickDescription(param.getPickDescription()).build();
        StoreInfo storeInfo = StoreInfo.builder().id(param.getStoreId()).name(param.getStoreName()).areaCode(param.getStoreAreaCode()).build();
        SceneInfo sceneInfo = SceneInfo.builder().storeInfo(storeInfo).build();
        ArrayList<PayerInfo> payerOptions = new ArrayList<PayerInfo>();
        PayerInfo payerInfo = PayerInfo.builder().payerName(param.getPayerName()).assignPayType(param.getPayerType()).build();
        payerOptions.add(payerInfo);
        return PaymentParam.builder().outPaymentId(param.getOutPaymentId()).amount(param.getAmount()).currency(param.getCurrency()).expireTime(param.getExpireTime()).payee(payee).goods(goodsList).memo(param.getMemo()).attachment(param.getAttachment()).riskControl(paymentRiskControl).sceneInfo(sceneInfo).profitAllocationFlag(param.getProfitAllocationFlag()).payerOptions(payerOptions).build();
    }

    public PaymentServiceImpl(NotifyVerifyService notifyVerifyService, RedisWrapper redisWrapper, RedisUtils redisUtils, RmiPurRpcService rmiPurRpcService, RmiInvStkRpcService rmiInvStkRpcService, AccountLinkService accountLinkService, MessageQueueTemplate messageQueueTemplate, ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc) {
        this.notifyVerifyService = notifyVerifyService;
        this.redisWrapper = redisWrapper;
        this.redisUtils = redisUtils;
        this.rmiPurRpcService = rmiPurRpcService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.accountLinkService = accountLinkService;
        this.messageQueueTemplate = messageQueueTemplate;
        this.scpWqfEntAccountRepoProc = scpWqfEntAccountRepoProc;
    }
}

