/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RmiOrgOuService {
    private static final Logger log = LoggerFactory.getLogger(RmiOrgOuService.class);
    @Autowired
    private OrgOuRpcService orgOuRpcService;
    @Autowired
    private OrgRegionRpcService orgRegionRpcService;

    public List<OrgOuRpcDTO> findOuDtoListByParam(OrgOuRpcDtoParam param) {
        try {
            List ouDtoResult = this.orgOuRpcService.findOuDtoByParam(param);
            return CollUtil.isNotEmpty((Collection)ouDtoResult) ? ouDtoResult : new ArrayList(0);
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u516c\u53f8\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u516c\u53f8\u76f8\u5173\u670d\u52a1\u5f02\u5e38" + e, (Throwable)e);
        }
    }

    public List<OrgOuRpcDTO> findOuDtoList(List<Long> ouIds, List<String> ouCodes) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouIds);
        orgOuRpcDtoParam.setOuCodes(ouCodes);
        return this.findOuDtoListByParam(orgOuRpcDtoParam);
    }

    public List<OrgOuRpcDTO> findOuDtoListByName(List<String> ouNames) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuNames(ouNames);
        return this.findOuDtoListByParam(orgOuRpcDtoParam);
    }

    public List<OrgOuRpcDTO> findOuDtoListByOuCodes(List<String> ouCodes) {
        log.info("\u8c03\u7528support\u57df:\u6839\u636e\u7f16\u7801\u67e5\u8be2\u516c\u53f8,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), ouCodes);
        try {
            if (CollectionUtils.isEmpty(ouCodes)) {
                return Collections.emptyList();
            }
            OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
            orgOuRpcDtoParam.setOuCodes(ouCodes);
            List<OrgOuRpcDTO> orgOuRpcDTOList = this.findOuDtoListByParam(orgOuRpcDtoParam);
            log.info("\u8c03\u7528support\u57df:\u6839\u636e\u7f16\u7801\u67e5\u8be2\u516c\u53f8,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), orgOuRpcDTOList);
            return orgOuRpcDTOList;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528support\u57df:\u6839\u636e\u7f16\u7801\u67e5\u8be2\u516c\u53f8,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528support\u57df:" + e.getMessage());
        }
    }

    public Map<Long, OrgOuRpcSimpleDTO> findOuDtoMap(List<Long> ouIds) {
        if (CollUtil.isEmpty(ouIds)) {
            return new HashMap<Long, OrgOuRpcSimpleDTO>();
        }
        List simpleOuDto = this.orgOuRpcService.findSimpleOuDto(ouIds);
        if (CollUtil.isEmpty((Collection)simpleOuDto)) {
            return new HashMap<Long, OrgOuRpcSimpleDTO>();
        }
        return simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, Function.identity()));
    }

    public Map<String, OrgOuRpcSimpleDTO> findOuDtoMapByOuCodes(List<String> ouCodes) {
        if (CollUtil.isEmpty(ouCodes)) {
            return new HashMap<String, OrgOuRpcSimpleDTO>();
        }
        List simpleOuDto = this.orgOuRpcService.findSimpleByOuCodes(ouCodes);
        if (CollUtil.isEmpty((Collection)simpleOuDto)) {
            return new HashMap<String, OrgOuRpcSimpleDTO>();
        }
        return simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, Function.identity()));
    }

    public Map<String, String> findRegionMapByCodes(Set<String> codes) {
        if (CollUtil.isEmpty(codes)) {
            return new HashMap<String, String>();
        }
        ApiResult nameByCode = this.orgRegionRpcService.getNameByCode(codes);
        if (!nameByCode.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u533a\u57df\u540d\u79f0\u63a5\u53e3\u5f02\u5e38:" + nameByCode.getMsg());
        }
        return (Map)nameByCode.getData();
    }
}

