package com.elitesland.scp.application.facade.vo.resp.app;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@Data
@ApiModel("门店订货小程序商品详情列表")
public class AppItmItemDetailVO extends BaseViewModel implements Serializable {

    @ApiModelProperty(value = "spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty(value = "spu编码")
    private String spuCode;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;


    @ApiModelProperty(value = "单位")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "价格")
    private BigDecimal price;

    /**
     * 商品SKU条码
     */
    @ApiModelProperty("商品SKU条码")
    private String barCode;
    /**
     * 规格型号
     */
    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty(value = "类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty(value = "品牌")
    private String brand;
    private String brandName;

    /**
     * 商品规格2(1单规格 0多规格)
     */
    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;


    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    /**
     * 详细描述
     */
    @ApiModelProperty(name = "详细描述")
    private String itemDescribe;

    private String spuName;


    @ApiModelProperty(value = "商品图片")
    private List<ItmItemAttachmentRpcDTO> attchments;

}
