package com.elitesland.scp.application.facade.vo.resp.app;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("热销商品")
public class ScpCateItemRespVO implements Serializable {
    private static final long serialVersionUID = 4100592869100163644L;

    @ApiModelProperty("主键ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品别名")
    private String anotherName;

    @ApiModelProperty("商品规格")
    private String spec;

    @ApiModelProperty("价格(总)")
    private BigDecimal price;

    @ApiModelProperty("图片地址")
    private String url;

    @ApiModelProperty("SPU-ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("SPU编码")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty("商品分类")
    private String itemType;

    @ApiModelProperty("配送类型")
    private String itemTyp2;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("业务类型")
    private String businessType;

    private String itemCateCode;

    private String uom;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;
}
