package com.elitesland.scp.application.web.app;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.app.AppStoreProtocolAgreeParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppStoreServiceEntityRespVO;
import com.elitesland.scp.application.service.app.AppStoreServiceEntityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 09月 17日 19:28
 * @version: 1.0
 */
@RestController
@RequestMapping("/app/store/serviceEntity")
@RequiredArgsConstructor
@Api(value = "app-门店服务主体", tags = {"app-门店服务主体"})
@Slf4j
public class AppStoreServiceEntityController {

    private final AppStoreServiceEntityService appStoreServiceEntityService;

    @GetMapping("/query/{storeCode}")
    @ApiOperation("门店协议同意状态更新")
    public ApiResult<AppStoreServiceEntityRespVO> query(@PathVariable("storeCode") String storeCode) {
        return ApiResult.ok(appStoreServiceEntityService.query(storeCode));
    }
}
