package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.*;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepo;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @Author: ryan.xu
 * @since 2024/03/18
 */
@RequiredArgsConstructor
@Service
@Slf4j
public class ScpStoreDemandCalendarDomainServiceImpl implements ScpStoreDemandCalendarDomainService {

    private final ScpStoreDemandCalendarRepoProc storeDemandCalendarRepoProc;
    private final ScpStoreDemandCalendarRepo scpStoreDemandCalendarRepo;
    private final EntityManager entityManager;


    @Override
    public PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO queryParam) {
        return storeDemandCalendarRepoProc.searchPage(queryParam);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(List<ScpStoreDemandCalendarDO> createList) {
        scpStoreDemandCalendarRepo.saveAll(createList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> ids) {
        scpStoreDemandCalendarRepo.deleteAllById(ids);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthKey(List<String> concatKey) {
        return scpStoreDemandCalendarRepo.findByConcatYearAndMonthKey(concatKey);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthAndDeliveryTypeKey(Collection<String> typeSet,
                                                                                     Collection<String> storeCodeSet,
                                                                                     Collection<String> yearSet,
                                                                                     Collection<String> monthSet,
                                                                                     Collection<String> deliverySet) {
        return storeDemandCalendarRepoProc.findByConcatYearAndMonthAndDeliveryTypeKey(typeSet,
                storeCodeSet,
                yearSet,
                monthSet,
                deliverySet);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByStoreDayCalendar(List<String> concatKey) {
        return scpStoreDemandCalendarRepo.findByStoreDayCalendar(concatKey);
    }

    @Override
    public List<ScpStoreDemandCalendarDTO> listCalendarDTOs(ScpStoreDemandCalendarParam scpStoreDemandCalendarParam) {
        return storeDemandCalendarRepoProc.findDemandCalendarByParam(scpStoreDemandCalendarParam);
    }

    @Override
    public List<ScpStoreDemandCalendarDTO> findStoreCalendarByParam(ScpStoreDemandCalendarParamVO param) {
        return storeDemandCalendarRepoProc.findStoreCalendarByParam(param);
    }

    @Override
    public List<ScpCalendarStoreRespVO> listStoreByQueryParam(ScpCalendarStoreQueryParamVO param) {
        return storeDemandCalendarRepoProc.listStoreByQueryParam(param);
    }

    @Override
    public void batchInsert(List<ScpStoreDemandCalendarDO> createList, int batchSize) {
        // 定义一个变量index，用于记录当前插入的数据量
        int index = 0;
        // 遍历createList中的数据
        for (ScpStoreDemandCalendarDO data : createList) {
            // 将数据插入到数据库中
            entityManager.persist(data);
            // 如果batchSize大于1，则开启批量
            if (batchSize > 1) {
                // 开启批量
                index++;
                if (index % batchSize == 0) {
                    entityManager.flush();
                    entityManager.clear();
                }
            }
        }
        if (!createList.isEmpty()) {
            entityManager.flush();
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByStoreAndYear(String type, List<String> storeCodes, String year) {
        storeDemandCalendarRepoProc.deleteByStoreAndYear(type, storeCodes, year);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByStoreAndYearAndDeliveryType(String type, List<String> storeCodes, String year, String deliveryType) {
        storeDemandCalendarRepoProc.deleteByStoreAndYearAndDeliveryType(type, storeCodes, year, deliveryType);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByStoreAndYearAndMonth(String type, List<String> storeCodes, String year, String month) {
        storeDemandCalendarRepoProc.deleteByStoreAndYearAndMonth(type, storeCodes, year, month);
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByStoreAndYearAndMonthAndDeliveryType (String type, List<String> storeCodes, String year, String month, String deliveryType) {
        storeDemandCalendarRepoProc.deleteByStoreAndYearAndMonthAndDeliveryType(type, storeCodes, year, month, deliveryType);
    }
//    @Override
//    public boolean isCanDelivery(String storeCode, String region, String deliveryType){
//        //获取当前年月日
//        LocalDate now = LocalDate.now();
//        String year = String.valueOf(now.getYear());
//        String month = String.format("%02d", now.getMonthValue());
//        String day = String.valueOf(now.getDayOfMonth());
//        return storeDemandCalendarRepoProc.isCanDelivery(storeCode,region,deliveryType,year,month,day);
//    }

    @Override
    public Map<String, Boolean> isCanDelivery(String storeCode, String region, List<String> deliveryType) {
        //获取当前年月日
        LocalDate now = LocalDate.now();
        String year = String.valueOf(now.getYear());
        String month = String.format("%02d", now.getMonthValue());
        String day = String.valueOf(now.getDayOfMonth());
        return storeDemandCalendarRepoProc.isCanDelivery(storeCode, region, deliveryType, year, month, day);
    }
}