package com.elitesland.scp.domain.service.mrp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpDPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDExportRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDPlanRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDetailRespVO;
import com.elitesland.scp.application.facade.vo.save.mrp.ScpMrpDPlanSaveVO;
import com.elitesland.scp.domain.convert.mrp.ScpMrpDConvert;
import com.elitesland.scp.domain.convert.mrp.ScpMrpDPlanConvert;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDDO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDPlanDO;
import com.elitesland.scp.infr.repo.mrp.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author chaofeng.xia
 * @since 2025/1/15
 */
@RequiredArgsConstructor
@Service
@Slf4j
public class ScpMrpDDomainServiceImpl implements ScpMrpDDomainService {

    private final ScpMrpDRepo scpMrpDRepo;

    private final ScpMrpDPlanRepo scpMrpDPlanRepo;

    private final ScpMrpDRepoProc scpMrpDRepoProc;

    private final UdcProvider udcProvider;

    @Override
    @SysCodeProc
    public PagingVO<ScpMrpDRespVO> searchPage(ScpMrpDPageParam param) {
        PagingVO<ScpMrpDRespVO> pagingVO = scpMrpDRepoProc.pageQuery(param);
        if (pagingVO.isNotEmpty()) {
            List<Long> ids = pagingVO.getRecords().stream().map(ScpMrpDRespVO::getId).collect(Collectors.toList());
            List<ScpMrpDPlanDO> scpMrpDPlanDOList = scpMrpDPlanRepo.findByMasIdIn(ids);
            if (CollectionUtil.isNotEmpty(scpMrpDPlanDOList)) {
                Map<String, String> pushStatusMap = udcProvider.getValueMapByUdcCode("yst-suplan", "MRP_D_PUSH_STATUS");
                List<ScpMrpDPlanRespVO> scpMrpDPlanRespVOS = ScpMrpDPlanConvert.INSTANCE.doToRespVO(scpMrpDPlanDOList);
                Map<Long, List<ScpMrpDPlanRespVO>> planMap = scpMrpDPlanRespVOS.stream().peek(plan -> plan.setPushStatusName(pushStatusMap.get(plan.getPushStatus()))).collect(Collectors.groupingBy(ScpMrpDPlanRespVO::getMasId));
                pagingVO.getRecords().forEach(record -> {record.setScpMrpDPlanRespVOList(planMap.get(record.getId()));});
            }
        }
        return pagingVO;
    }

    @Override
    public List<ScpMrpDRespVO> findByMasId(Long masId) {
        List<ScpMrpDDO> scpMrpDDOList = scpMrpDRepo.findByMasId(masId);
        if (CollectionUtil.isNotEmpty(scpMrpDDOList)) {
            return ScpMrpDConvert.INSTANCE.doToRespVO(scpMrpDDOList);
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasIds(List<Long> masIds) {
        scpMrpDRepo.deleteByMasIds(masIds);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        scpMrpDRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findIdsByMasIds(List<Long> masIds) {
        return scpMrpDRepoProc.findIdsByMasIds(masIds);
    }

    @Override
    public List<ScpMrpDRespVO> findByMasIds(List<Long> masIds) {
        List<ScpMrpDDO> scpMrpDDOList = scpMrpDRepo.findByMasIdIn(masIds);
        if (CollectionUtil.isNotEmpty(scpMrpDDOList)) {
            return ScpMrpDConvert.INSTANCE.doToRespVO(scpMrpDDOList);
        }
        return Collections.emptyList();
    }

    @Override
    public ScpMrpDRespVO findById(Long id) {
        return scpMrpDRepo.findById(id).map(ScpMrpDConvert.INSTANCE::doToRespVO).orElse(null);
    }

    @Override
    @Transactional
    public List<ScpMrpDDO> save(List<ScpMrpDDO> scpMrpDDOList) {
        return scpMrpDRepo.saveAll(scpMrpDDOList);
    }

    @Override
    @Transactional
    public void savePlan(List<ScpMrpDPlanSaveVO> scpMrpDPlanSaveVOList) {
        scpMrpDPlanRepo.saveAll(ScpMrpDPlanConvert.INSTANCE.saveVoToDo(scpMrpDPlanSaveVOList));
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpMrpDExportRespVO> queryExport(ScpMrpDPageParam param) {
        return scpMrpDRepoProc.queryExport(param);
    }

    @Override
    public List<ScpMrpDRespVO> findByIds(List<Long> ids) {
        List<ScpMrpDDO> scpMrpDDOList = scpMrpDRepo.findAllById(ids);
        if (CollectionUtil.isEmpty(scpMrpDDOList)) {
            return Collections.emptyList();
        }
        return ScpMrpDConvert.INSTANCE.doToRespVO(scpMrpDDOList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateNetDemand(Long id, BigDecimal netDemand) {
        scpMrpDRepoProc.updateNetDemand(id, netDemand);
    }

    @Override
    public List<ScpMrpDetailRespVO> findDetailByMasId(Long masId) {
        return scpMrpDRepoProc.findDetailByMasId(masId);
    }

}