package com.elitesland.scp.domain.vo.survey;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(description = "填写问卷入参")
@Data
public class SurveyAnswerSaveParam implements Serializable {

    private static final long serialVersionUID = 44067892996016803L;

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("问卷ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suvId;

    @ApiModelProperty("问题ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long qusId;

    @ApiModelProperty("选项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long optId;

    @ApiModelProperty("填空题")
    private String optContent;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("账号")
    private String username;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

}
