package com.elitesland.scp.application.facade.vo.resp.wqf;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 02月 28日 09:35
 * @version: 1.0
 */
@Data
@ApiModel("门店微企付账号分页查询条件")
public class ScpWqfEntAccountPageParam extends AbstractOrderQueryParam {

    @ApiModelProperty(value = "公司ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;

    @ApiModelProperty(value = "公司商户号")
    private String entId;

    @ApiModelProperty(value = "门店ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> storeIds;

    @ApiModelProperty(value = "门店商户号")
    private String entAcctId;

    @ApiModelProperty(value = "账户类型集合")
    private List<String> accountTypes;

    @ApiModelProperty(value = "状态")
    private Boolean status;
}
