package com.elitesland.scp.application.service.minOrder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingImportStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingSaveVO;

import java.util.List;

public interface ScpMinOrderSettingService {

    /**
     * 起订活动查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpMinOrderSettingPageRespVO> page(ScpMinOrderSettingPageParamVO paramVO);

    /**
     * 起订活动详情查询
     *
     * @param id
     * @return
     */
    ScpMinOrderSettingRespVO findMinOrderSettingById(Long id);

    /**
     * 起订活动保存
     *
     * @param saveVO
     * @return
     */
    Long saveMinOrderSetting(ScpMinOrderSettingSaveVO saveVO);

    /**
     * 删除
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 变更状态
     *
     * @param paramVO
     * @return
     */
    void changeMinOrderSettingStatus(ScpMinOrderSettingStatusParamVO paramVO);


    List<ScpMinOrderSettingStoreRespVO> importStoreData(List<ScpMinOrderSettingImportStoreParamVO> list);


}
