package com.elitesland.scp.infr.repo.minOrder;

import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingStoreDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

public interface ScpMinOrderSettingStoreRepo extends JpaRepository<ScpMinOrderSettingStoreDO, Long>, QuerydslPredicateExecutor<ScpMinOrderSettingStoreDO> {

    Optional<ScpMinOrderSettingStoreDO> findById(Long id);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_min_order_setting_store where mas_id = ?1 ", nativeQuery = true)
    void deleteByMasId(Long masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_min_order_setting_store where id in ?1 ", nativeQuery = true)
    void deleteByIds(List<Long> ids);

    @Modifying()
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_min_order_setting_store set active_num = active_num + 1 where mas_id in ?1 and store_code = ?2", nativeQuery = true)
    void updateActiveNumByParam(List<Long> masIds, String storeCode);

    List<ScpMinOrderSettingStoreDO> findByMasId(Long masId);
}
