package com.elitesland.scp.mq;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.application.facade.vo.stock.mq.ScpPredictStStockCalcSendParam;
import com.elitesland.scp.application.service.stock.ScpPredictStStockCalcService;
import com.elitesland.scp.application.service.stock.ScpPredictStockSendUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 02月 05日 17:39
 * @version: 1.0
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ScpPredictStockListener implements MessageQueueListener<ScpPredictStStockCalcSendParam> {

    private final ScpPredictStStockCalcService scpPredictStStockCalcService;

    @Override
    public @NotEmpty String[] channels() {
        return new String[] {ScpPredictStockSendUtil.PREDICT_STOCK_CHANNEL};
    }


    @Override
    public void onConsume(@NotBlank String channel, @NotNull ScpPredictStStockCalcSendParam scpPredictStStockCalcSendParam) {
        log.info("预测安全库存&目标库存 mq 消息监听: {}", JSON.toJSONString(scpPredictStStockCalcSendParam));
        scpPredictStStockCalcService.calcuStStock(scpPredictStStockCalcSendParam.getScpStStockSyncParamVOS());
        log.info("预测安全库存&目标库存 mq 消息处理完成: {}", JSON.toJSONString(scpPredictStStockCalcSendParam));
    }

}
