/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.minOrder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingImportStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingItemSaveVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingRegionSaveVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingSaveVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingStoreSaveVO;
import com.elitesland.scp.application.service.minOrder.ScpMinOrderSettingService;
import com.elitesland.scp.domain.convert.minOrder.ScpMinOrderSettingConvert;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingDO;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingRedisDO;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingDomainService;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingItemDomainService;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingRegionDomainService;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingStoreDomainService;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingRepo;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.dto.SpuImageDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBasePageRpcParam;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpMinOrderSettingServiceImpl
implements ScpMinOrderSettingService {
    private static final Logger log = LoggerFactory.getLogger(ScpMinOrderSettingServiceImpl.class);
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpMinOrderSettingDomainService scpMinOrderSettingDomainService;
    private final ScpMinOrderSettingItemDomainService scpMinOrderSettingItemDomainService;
    private final ScpMinOrderSettingRegionDomainService scpMinOrderSettingRegionDomainService;
    private final ScpMinOrderSettingStoreDomainService scpMinOrderSettingStoreDomainService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RedisTemplate<String, Object> redisClient;
    private final ScpMinOrderSettingRepo scpMinOrderSettingRepo;
    private final RmiItemService rmiItemService;
    private final RmiSysUDCService rmiSysUDCService;

    private static void checkParam(ScpMinOrderSettingSaveVO saveVO) {
        if (CollUtil.isEmpty(saveVO.getRegionList())) {
            throw new BusinessException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty(saveVO.getItemList())) {
            throw new BusinessException("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public PagingVO<ScpMinOrderSettingPageRespVO> page(ScpMinOrderSettingPageParamVO paramVO) {
        HashSet<Long> masIds = new HashSet<Long>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getRegion())) {
            List<Long> regionMasIds = this.scpMinOrderSettingRegionDomainService.findMasIdByRegionCode(paramVO.getRegion());
            if (CollUtil.isEmpty(regionMasIds)) {
                return new PagingVO();
            }
            masIds.addAll(regionMasIds);
        }
        if (paramVO.getStoreCode() != null) {
            List<Long> storeMasIds = this.scpMinOrderSettingStoreDomainService.findMasIdByStoreCode(paramVO.getStoreCode());
            if (CollUtil.isEmpty(storeMasIds)) {
                return new PagingVO();
            }
            this.intersectSets(masIds, storeMasIds);
        }
        if (paramVO.getItemId() != null) {
            List<Long> itemMasIds = this.scpMinOrderSettingItemDomainService.findMasIdByItemId(paramVO.getItemId());
            if (CollUtil.isEmpty(itemMasIds)) {
                return new PagingVO();
            }
            this.intersectSets(masIds, itemMasIds);
        }
        paramVO.setIds(new ArrayList<Long>(masIds));
        return this.scpMinOrderSettingDomainService.queryMinOrderSettingList(paramVO);
    }

    @Override
    @SysCodeProc
    public ScpMinOrderSettingRespVO findMinOrderSettingById(Long id) {
        Optional<ScpMinOrderSettingRespVO> scpMinOrderSettingRespVO = this.scpMinOrderSettingDomainService.findMinOrderSettingById(id).map(ScpMinOrderSettingConvert.INSTANCE::dtoToRespVO);
        if (scpMinOrderSettingRespVO.isPresent()) {
            ScpMinOrderSettingRespVO MinOrderSettingRespVO = scpMinOrderSettingRespVO.get();
            MinOrderSettingRespVO.setAllStoreFlag(Boolean.FALSE);
            MinOrderSettingRespVO.setItemRespVOList(this.scpMinOrderSettingItemDomainService.findByMasId(id));
            MinOrderSettingRespVO.setRegionRespVOList(this.scpMinOrderSettingRegionDomainService.findByMasId(id));
            MinOrderSettingRespVO.setStoreRespVOList(this.scpMinOrderSettingStoreDomainService.findByMasId(id));
            if (StrUtil.isNotBlank((CharSequence)MinOrderSettingRespVO.getDocType())) {
                MinOrderSettingRespVO.setDocTypes(StrUtil.split((CharSequence)MinOrderSettingRespVO.getDocType(), (char)','));
            }
            return MinOrderSettingRespVO;
        }
        return new ScpMinOrderSettingRespVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveMinOrderSetting(ScpMinOrderSettingSaveVO saveVO) {
        ScpMinOrderSettingServiceImpl.checkParam(saveVO);
        if (saveVO.getId() == null) {
            if (CollUtil.isEmpty(saveVO.getStoreList()) && !saveVO.getAllStoreFlag().booleanValue()) {
                throw new BusinessException("\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String orderNo = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("FA", new ArrayList<String>());
            saveVO.setActivityCode(orderNo);
        } else {
            ScpMinOrderSettingStoreParamVO scpMinOrderSettingStoreParamVO = new ScpMinOrderSettingStoreParamVO();
            scpMinOrderSettingStoreParamVO.setMasIds(List.of(saveVO.getId()));
            scpMinOrderSettingStoreParamVO.setUsed(Boolean.TRUE);
            List<ScpMinOrderSettingStoreRespVO> byParam = this.scpMinOrderSettingStoreDomainService.findByParam(scpMinOrderSettingStoreParamVO);
            if (CollUtil.isNotEmpty(byParam)) {
                throw new BusinessException("\u6d3b\u52a8\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
        }
        Long masId = this.scpMinOrderSettingDomainService.saveMinOrderSetting(saveVO);
        this.scpMinOrderSettingItemDomainService.deleteByMasId(masId);
        this.scpMinOrderSettingRegionDomainService.deleteByMasId(masId);
        saveVO.getRegionList().forEach(row -> row.setMasId(masId));
        this.scpMinOrderSettingRegionDomainService.batchSaveSettingRegion(saveVO.getRegionList());
        List itemCodes = saveVO.getItemList().stream().map(ScpMinOrderSettingItemSaveVO::getItemCode).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(itemCodes);
        List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        Map<String, ItmItemRpcDTO> itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
        saveVO.getItemList().forEach(row -> {
            row.setMasId(masId);
            if (itemRpcDTOMap.containsKey(row.getItemCode())) {
                row.setItemId(((ItmItemRpcDTO)itemRpcDTOMap.get(row.getItemCode())).getId());
            }
        });
        this.scpMinOrderSettingItemDomainService.batchSaveMinOrderSettingItem(saveVO.getItemList());
        this.scpMinOrderSettingStoreDomainService.deleteByMasId(masId);
        if (CollUtil.isNotEmpty(saveVO.getStoreList()) && !saveVO.getAllStoreFlag().booleanValue()) {
            saveVO.getStoreList().forEach(row -> {
                row.setMasId(masId);
                row.setId(null);
            });
            this.scpMinOrderSettingStoreDomainService.batchSaveMinOrderSettingStore(saveVO.getStoreList());
            this.refreshRedisValue(saveVO, masId, saveVO.getStoreList(), itemRpcDTOMap);
        }
        if (CollUtil.isEmpty(saveVO.getStoreList()) && saveVO.getAllStoreFlag().booleanValue()) {
            this.saveDefaultStore(saveVO, masId, itemRpcDTOMap);
        }
        String key = "SCP:MINORDER:SETTING:" + masId;
        if (!LocalDateTime.now().isAfter(saveVO.getValidTo())) {
            long between = ChronoUnit.MINUTES.between(LocalDateTime.now(), saveVO.getValidTo());
            LocalDateTime validFrom = saveVO.getValidFrom();
            String jsonString = JSON.toJSONString((Object)validFrom);
            this.redisClient.opsForValue().set((Object)key, (Object)jsonString, between, TimeUnit.MINUTES);
        }
        this.scpMinOrderSettingDomainService.enableMinOrderSetting(List.of(masId), Boolean.TRUE);
        return masId;
    }

    private void refreshRedisValue(ScpMinOrderSettingSaveVO saveVO, Long masId, List<ScpMinOrderSettingStoreSaveVO> storeList, Map<String, ItmItemRpcDTO> itemRpcDTOMap) {
        HashMap<CallSite, String> redisMap = new HashMap<CallSite, String>();
        ArrayList<ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = new ArrayList<ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO>();
        for (ScpMinOrderSettingItemSaveVO item : saveVO.getItemList()) {
            ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO innerItemDO = new ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO();
            innerItemDO.setItemCode(item.getItemCode());
            innerItemDO.setMasId(masId);
            innerItemDO.setMinNum(item.getMinNum());
            innerItemDO.setItemType2(item.getItemType2());
            if (itemRpcDTOMap.containsKey(item.getItemCode())) {
                ItmItemRpcDTO itmItemRpcDTO = itemRpcDTOMap.get(item.getItemCode());
                List spuAttchmentList = itmItemRpcDTO.getSpuImageList();
                if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                    Optional<SpuImageDTO> first = spuAttchmentList.stream().filter(SpuImageDTO::getMajor).findFirst();
                    innerItemDO.setImgUrl(first.isEmpty() ? ((SpuImageDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                }
                innerItemDO.setItemId(itmItemRpcDTO.getId());
                innerItemDO.setItemName(itmItemRpcDTO.getItemName());
            }
            innerItemDOS.add(innerItemDO);
        }
        for (ScpMinOrderSettingStoreSaveVO store : storeList) {
            ScpMinOrderSettingRedisDO scpMinOrderSettingRedisDO = new ScpMinOrderSettingRedisDO();
            Object obj = this.redisClient.opsForValue().get((Object)("SCP:MINORDER:SETTING:" + store.getStoreCode()));
            if (obj == null) {
                ScpMinOrderSettingRedisDO.ActivityDO activityDO1 = this.createActivityDO(masId, saveVO, store, innerItemDOS);
                scpMinOrderSettingRedisDO.setActivityList(List.of(activityDO1));
            } else {
                String str = (String)obj;
                ScpMinOrderSettingRedisDO setting = (ScpMinOrderSettingRedisDO)JSON.parseObject((String)str, ScpMinOrderSettingRedisDO.class);
                List<ScpMinOrderSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
                Boolean flag = Boolean.FALSE;
                for (ScpMinOrderSettingRedisDO.ActivityDO inActivityDO : activityList) {
                    if (!inActivityDO.getActivityId().equals(masId)) continue;
                    inActivityDO.setActivityId(masId);
                    inActivityDO.setActivityCode(saveVO.getActivityCode());
                    inActivityDO.setDocTypes(saveVO.getDocTypes());
                    inActivityDO.setMaxNum(store.getMaxNum());
                    inActivityDO.setActiveNum(0);
                    inActivityDO.setValidTo(saveVO.getValidTo());
                    inActivityDO.setValidFrom(saveVO.getValidFrom());
                    inActivityDO.setInnerItemDOS(innerItemDOS);
                    flag = Boolean.TRUE;
                }
                if (!flag.booleanValue()) {
                    ScpMinOrderSettingRedisDO.ActivityDO activityDO1 = this.createActivityDO(masId, saveVO, store, innerItemDOS);
                    activityList.add(activityDO1);
                }
                scpMinOrderSettingRedisDO.setActivityList(activityList);
            }
            String key = "SCP:MINORDER:SETTING:" + store.getStoreCode();
            redisMap.put((CallSite)((Object)key), JSONUtil.toJsonStr((Object)scpMinOrderSettingRedisDO));
        }
        this.redisClient.opsForValue().multiSet(redisMap);
    }

    private ScpMinOrderSettingRedisDO.ActivityDO createActivityDO(Long masId, ScpMinOrderSettingSaveVO saveVO, ScpMinOrderSettingStoreSaveVO store, List<ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS) {
        ScpMinOrderSettingRedisDO.ActivityDO activityDO = new ScpMinOrderSettingRedisDO.ActivityDO();
        activityDO.setInnerItemDOS(innerItemDOS);
        activityDO.setActivityId(masId);
        activityDO.setActivityCode(saveVO.getActivityCode());
        activityDO.setDocTypes(saveVO.getDocTypes());
        activityDO.setMaxNum(store.getMaxNum());
        activityDO.setActiveNum(0);
        activityDO.setValidFrom(saveVO.getValidFrom());
        activityDO.setValidTo(saveVO.getValidTo());
        return activityDO;
    }

    private void saveDefaultStore(ScpMinOrderSettingSaveVO saveVO, Long masId, Map<String, ItmItemRpcDTO> itemRpcDTOMap) {
        if (saveVO.getMaxNum() == null) {
            throw new BusinessException("\u6700\u5927\u8d77\u8ba2\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List regionList = saveVO.getRegionList().stream().map(ScpMinOrderSettingRegionSaveVO::getRegion).distinct().collect(Collectors.toList());
        OrgStoreBasePageRpcParam orgStoreBasePageRpcParam = new OrgStoreBasePageRpcParam();
        orgStoreBasePageRpcParam.setRegionList(regionList);
        Long count = this.rmiOrgStoreRpcService.countBaseStoreByParam(orgStoreBasePageRpcParam);
        if (count == null || count == 0L) {
            log.info("saveDefaultStore\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u95e8\u5e97\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        int totalPage = PageUtil.totalPage((long)count, (int)1000);
        for (int i = 1; i <= totalPage; ++i) {
            orgStoreBasePageRpcParam.setSize(Integer.valueOf(1000));
            orgStoreBasePageRpcParam.setCurrent(Integer.valueOf(i));
            PagingVO<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOPagingVO = this.rmiOrgStoreRpcService.queryBaseStore(orgStoreBasePageRpcParam);
            List<ScpMinOrderSettingStoreSaveVO> storeSaveVOS = orgStoreBaseRpcDTOPagingVO.getRecords().stream().map(row -> {
                ScpMinOrderSettingStoreSaveVO scpMinOrderSettingStoreSaveVO = new ScpMinOrderSettingStoreSaveVO();
                scpMinOrderSettingStoreSaveVO.setStoreId(row.getId());
                scpMinOrderSettingStoreSaveVO.setStoreCode(row.getStoreCode());
                scpMinOrderSettingStoreSaveVO.setStoreName(row.getStoreName());
                scpMinOrderSettingStoreSaveVO.setStoreType2(row.getStoreType2());
                scpMinOrderSettingStoreSaveVO.setMasId(masId);
                scpMinOrderSettingStoreSaveVO.setMaxNum(saveVO.getMaxNum());
                return scpMinOrderSettingStoreSaveVO;
            }).collect(Collectors.toList());
            this.scpMinOrderSettingStoreDomainService.batchSaveMinOrderSettingStore(storeSaveVOS, 1000);
            this.refreshRedisValue(saveVO, masId, storeSaveVOS, itemRpcDTOMap);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpMinOrderSettingDomainService.deleteByIds(ids);
        List keys = ids.stream().map(row -> "SCP:MINORDER:SETTING:" + row).collect(Collectors.toList());
        this.redisClient.delete(keys);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeMinOrderSettingStatus(ScpMinOrderSettingStatusParamVO paramVO) {
        if (Boolean.TRUE.equals(paramVO.getStatus())) {
            ScpMinOrderSettingStoreParamVO scpMinOrderSettingStoreParamVO = new ScpMinOrderSettingStoreParamVO();
            scpMinOrderSettingStoreParamVO.setMasIds(paramVO.getIds());
            List<ScpMinOrderSettingStoreRespVO> storeRespVOList = this.scpMinOrderSettingStoreDomainService.findByParam(scpMinOrderSettingStoreParamVO);
            if (CollUtil.isEmpty(storeRespVOList)) {
                throw new BusinessException("\u95e8\u5e97\u4fe1\u606f\u672a\u7ef4\u62a4");
            }
            List<ScpMinOrderSettingDO> settingDOS = this.scpMinOrderSettingRepo.findByIdIn(paramVO.getIds());
            for (ScpMinOrderSettingDO settingDO : settingDOS) {
                String key = "SCP:MINORDER:SETTING:" + settingDO.getId();
                if (LocalDateTime.now().isAfter(settingDO.getValidTo())) continue;
                long between = ChronoUnit.MINUTES.between(LocalDateTime.now(), settingDO.getValidTo());
                LocalDateTime validFrom = settingDO.getValidFrom();
                String jsonString = JSON.toJSONString((Object)validFrom);
                this.redisClient.opsForValue().set((Object)key, (Object)jsonString, between, TimeUnit.MINUTES);
                List<ScpMinOrderSettingItemRespVO> itemList = this.scpMinOrderSettingItemDomainService.findByMasId(settingDO.getId());
                List itemCodes = itemList.stream().map(ScpMinOrderSettingItemRespVO::getItemCode).distinct().collect(Collectors.toList());
                ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
                itmItemRpcDtoParam.setItemCodes(itemCodes);
                List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
                Map itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
                ArrayList<ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = new ArrayList<ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO>();
                for (ScpMinOrderSettingItemRespVO item : itemList) {
                    ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO innerItemDO = new ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO();
                    innerItemDO.setItemCode(item.getItemCode());
                    innerItemDO.setMasId(settingDO.getId());
                    innerItemDO.setMinNum(item.getMinNum());
                    innerItemDO.setItemType2(item.getItemType2());
                    if (itemRpcDTOMap.containsKey(item.getItemCode())) {
                        ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itemRpcDTOMap.get(item.getItemCode());
                        List spuAttchmentList = itmItemRpcDTO.getSpuImageList();
                        if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                            Optional<SpuImageDTO> first = spuAttchmentList.stream().filter(SpuImageDTO::getMajor).findFirst();
                            innerItemDO.setImgUrl(first.isEmpty() ? ((SpuImageDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                        }
                        innerItemDO.setItemId(itmItemRpcDTO.getId());
                        innerItemDO.setItemName(itmItemRpcDTO.getItemName());
                    }
                    innerItemDOS.add(innerItemDO);
                }
                HashMap<CallSite, String> redisMap = new HashMap<CallSite, String>();
                for (ScpMinOrderSettingStoreRespVO store : storeRespVOList) {
                    ScpMinOrderSettingRedisDO scpMinOrderSettingRedisDO = new ScpMinOrderSettingRedisDO();
                    Object obj = this.redisClient.opsForValue().get((Object)("SCP:MINORDER:SETTING:" + store.getStoreCode()));
                    if (obj != null) continue;
                    ScpMinOrderSettingRedisDO.ActivityDO activityDO1 = new ScpMinOrderSettingRedisDO.ActivityDO();
                    activityDO1.setActivityId(settingDO.getId());
                    activityDO1.setActivityCode(settingDO.getActivityCode());
                    activityDO1.setDocTypes(StrUtil.split((CharSequence)settingDO.getDocType(), (CharSequence)","));
                    activityDO1.setMaxNum(store.getMaxNum());
                    activityDO1.setActiveNum(0);
                    activityDO1.setInnerItemDOS(innerItemDOS);
                    activityDO1.setValidFrom(settingDO.getValidFrom());
                    activityDO1.setValidTo(settingDO.getValidTo());
                    scpMinOrderSettingRedisDO.setActivityList(List.of(activityDO1));
                    String storeKey = "SCP:MINORDER:SETTING:" + store.getStoreCode();
                    String jsonString2 = JSON.toJSONString((Object)scpMinOrderSettingRedisDO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
                    redisMap.put((CallSite)((Object)storeKey), jsonString2);
                }
                if (!CollUtil.isNotEmpty(redisMap)) continue;
                this.redisClient.opsForValue().multiSet(redisMap);
            }
        } else {
            List keys = paramVO.getIds().stream().map(row -> "SCP:MINORDER:SETTING:" + row).collect(Collectors.toList());
            this.redisClient.delete(keys);
        }
        this.scpMinOrderSettingDomainService.enableMinOrderSetting(paramVO.getIds(), paramVO.getStatus());
    }

    @Override
    public List<ScpMinOrderSettingStoreRespVO> importStoreData(List<ScpMinOrderSettingImportStoreParamVO> list) {
        if (CollectionUtil.isEmpty(list)) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        for (int i = 0; i < list.size(); ++i) {
            int row = i + 3;
            ScpMinOrderSettingImportStoreParamVO importData = list.get(i);
            if (!StrUtil.isBlank((CharSequence)importData.getStoreCode())) continue;
            throw new BusinessException("\u7b2c" + row + "\u884c\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
        }
        List<String> storeCodes = list.stream().map(ScpMinOrderSettingImportStoreParamVO::getStoreCode).distinct().toList();
        List<OrgStoreBaseRpcDTO> orgStoreBaseByParam = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(storeCodes);
        Map<Object, Object> storeBaseMap = CollUtil.isNotEmpty(orgStoreBaseByParam) ? orgStoreBaseByParam.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity(), (key, value) -> value)) : new HashMap();
        Map<String, String> storeType2 = this.rmiSysUDCService.getCodeMap("yst-supp", "STORE_TYPE2");
        ArrayList<ScpMinOrderSettingStoreRespVO> res = new ArrayList<ScpMinOrderSettingStoreRespVO>();
        for (int i = 0; i < list.size(); ++i) {
            int row = i + 3;
            ScpMinOrderSettingImportStoreParamVO l = list.get(i);
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)storeBaseMap.get(l.getStoreCode());
            if (orgStoreBaseRpcDTO == null) {
                throw new BusinessException("\u7b2c" + row + "\u884c\u95e8\u5e97\u4e0d\u5b58\u5728");
            }
            ScpMinOrderSettingStoreRespVO applyDResp = new ScpMinOrderSettingStoreRespVO();
            applyDResp.setStoreId(orgStoreBaseRpcDTO.getId());
            applyDResp.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            applyDResp.setStoreName(orgStoreBaseRpcDTO.getStoreName());
            applyDResp.setRegion(orgStoreBaseRpcDTO.getRegion());
            applyDResp.setRegionName(orgStoreBaseRpcDTO.getRegionName());
            applyDResp.setStoreType2(orgStoreBaseRpcDTO.getStoreType2());
            String storeTypeName = storeType2.get(orgStoreBaseRpcDTO.getStoreType2());
            if (storeTypeName != null) {
                applyDResp.setStoreType2Name(storeTypeName);
            }
            res.add(applyDResp);
        }
        return res;
    }

    private void intersectSets(Set<Long> set1, List<Long> list2) {
        if (set1.isEmpty()) {
            set1.addAll(list2);
        }
        set1.retainAll(list2);
    }

    public ScpMinOrderSettingServiceImpl(RmiSysUserRpcService rmiSysUserRpcService, ScpMinOrderSettingDomainService scpMinOrderSettingDomainService, ScpMinOrderSettingItemDomainService scpMinOrderSettingItemDomainService, ScpMinOrderSettingRegionDomainService scpMinOrderSettingRegionDomainService, ScpMinOrderSettingStoreDomainService scpMinOrderSettingStoreDomainService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RedisTemplate<String, Object> redisClient, ScpMinOrderSettingRepo scpMinOrderSettingRepo, RmiItemService rmiItemService, RmiSysUDCService rmiSysUDCService) {
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.scpMinOrderSettingDomainService = scpMinOrderSettingDomainService;
        this.scpMinOrderSettingItemDomainService = scpMinOrderSettingItemDomainService;
        this.scpMinOrderSettingRegionDomainService = scpMinOrderSettingRegionDomainService;
        this.scpMinOrderSettingStoreDomainService = scpMinOrderSettingStoreDomainService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.redisClient = redisClient;
        this.scpMinOrderSettingRepo = scpMinOrderSettingRepo;
        this.rmiItemService = rmiItemService;
        this.rmiSysUDCService = rmiSysUDCService;
    }
}

