/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.minOrder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingItemSaveVO;
import com.elitesland.scp.domain.convert.minOrder.ScpMinOrderSettingItemConvert;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingItemDO;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingRedisDO;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingItemDomainService;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingItemRepo;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingItemRepoProc;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpMinOrderSettingItemDomainServiceImpl
implements ScpMinOrderSettingItemDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpMinOrderSettingItemDomainServiceImpl.class);
    private final RedisTemplate redisTemplate;
    private final ScpMinOrderSettingItemRepo scpMinOrderSettingItemRepo;
    private final ScpMinOrderSettingItemRepoProc scpMinOrderSettingItemRepoProc;

    @Override
    @SysCodeProc
    public List<ScpMinOrderSettingItemRespVO> findByMasId(Long masId) {
        List<ScpMinOrderSettingItemDO> settingItemDOS = this.scpMinOrderSettingItemRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpMinOrderSettingItemConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<ScpMinOrderSettingItemRespVO>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveMinOrderSettingItem(List<ScpMinOrderSettingItemSaveVO> saveVOS) {
        this.scpMinOrderSettingItemRepo.saveAll(ScpMinOrderSettingItemConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpMinOrderSettingItemRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpMinOrderSettingItemRepo.deleteByIds(ids);
    }

    @Override
    public List<ScpMinOrderSettingItemRespVO> getEnableMinOrderSettingItemByStoreCode(String storeCode, List<String> itemTypes) {
        ArrayList<ScpMinOrderSettingItemRespVO> respVOS = new ArrayList<ScpMinOrderSettingItemRespVO>();
        Object obj = this.redisTemplate.opsForValue().get((Object)("SCP:MINORDER:SETTING:" + storeCode));
        if (obj == null) {
            return new ArrayList<ScpMinOrderSettingItemRespVO>();
        }
        String str = (String)obj;
        ScpMinOrderSettingRedisDO setting = (ScpMinOrderSettingRedisDO)JSON.parseObject((String)str, ScpMinOrderSettingRedisDO.class);
        List<ScpMinOrderSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
        for (ScpMinOrderSettingRedisDO.ActivityDO activityDO : activityList) {
            log.info("getEnableMinOrderSettingItemByStoreCode:{}", (Object)JSONUtil.toJsonStr((Object)activityDO));
            Object key = this.redisTemplate.opsForValue().get((Object)("SCP:MINORDER:SETTING:" + activityDO.getActivityId()));
            if (key == null) {
                log.info("\u8d77\u8ba2\u6d3b\u52a8ID:{}\uff0c\u7f13\u5b58\u4e0d\u5b58\u5728", (Object)activityDO.getActivityId());
                continue;
            }
            if (LocalDateTime.now().isBefore(activityDO.getValidFrom()) || LocalDateTime.now().isAfter(activityDO.getValidTo())) {
                log.info("\u8d77\u8ba2\u6d3b\u52a8ID:{}\uff0c\u5df2\u8fc7\u671f", (Object)activityDO.getActivityId());
                continue;
            }
            List<ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = activityDO.getInnerItemDOS();
            for (ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO innerItemDO : innerItemDOS) {
                ScpMinOrderSettingItemRespVO scpMinOrderSettingItemRespVO = new ScpMinOrderSettingItemRespVO();
                scpMinOrderSettingItemRespVO.setItemId(innerItemDO.getItemId());
                scpMinOrderSettingItemRespVO.setItemCode(innerItemDO.getItemCode());
                scpMinOrderSettingItemRespVO.setItemName(innerItemDO.getItemName());
                scpMinOrderSettingItemRespVO.setMasId(innerItemDO.getMasId());
                scpMinOrderSettingItemRespVO.setMinNum(innerItemDO.getMinNum());
                scpMinOrderSettingItemRespVO.setActivityCode(activityDO.getActivityCode());
                scpMinOrderSettingItemRespVO.setImgUrl(innerItemDO.getImgUrl());
                respVOS.add(scpMinOrderSettingItemRespVO);
            }
        }
        return respVOS;
    }

    @Override
    public List<Long> findMasIdByItemId(Long itemId) {
        return this.scpMinOrderSettingItemRepoProc.findMasIdByItemId(itemId);
    }

    public ScpMinOrderSettingItemDomainServiceImpl(RedisTemplate redisTemplate, ScpMinOrderSettingItemRepo scpMinOrderSettingItemRepo, ScpMinOrderSettingItemRepoProc scpMinOrderSettingItemRepoProc) {
        this.redisTemplate = redisTemplate;
        this.scpMinOrderSettingItemRepo = scpMinOrderSettingItemRepo;
        this.scpMinOrderSettingItemRepoProc = scpMinOrderSettingItemRepoProc;
    }
}

