/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.survey;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.scp.application.facade.vo.save.msg.ScpMessageSaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoQueryVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoRespVO;
import com.elitesland.scp.application.facade.vo.survey.ScpSurveyAnalysisExportRespVO;
import com.elitesland.scp.domain.convert.survey.SurveyAnswerConvert;
import com.elitesland.scp.domain.convert.survey.SurveyConvert;
import com.elitesland.scp.domain.convert.survey.SurveyOptionConvert;
import com.elitesland.scp.domain.convert.survey.SurveyPublishConvert;
import com.elitesland.scp.domain.convert.survey.SurveyQuestionConvert;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanRegionDO;
import com.elitesland.scp.domain.entity.survey.SurveyAnswerDO;
import com.elitesland.scp.domain.entity.survey.SurveyDO;
import com.elitesland.scp.domain.entity.survey.SurveyOptionDO;
import com.elitesland.scp.domain.entity.survey.SurveyPublishDO;
import com.elitesland.scp.domain.entity.survey.SurveyQuestionDO;
import com.elitesland.scp.domain.service.msg.ScpMessageMngService;
import com.elitesland.scp.domain.service.survey.SurveyService;
import com.elitesland.scp.domain.vo.survey.SurveyAnalysisDetailRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyAnalysisRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyAnswerParam;
import com.elitesland.scp.domain.vo.survey.SurveyAnswerRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyAnswerSaveParam;
import com.elitesland.scp.domain.vo.survey.SurveyCheckRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyOptionRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyOptionSaveParam;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.elitesland.scp.domain.vo.survey.SurveyPublishParam;
import com.elitesland.scp.domain.vo.survey.SurveyPublishRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyPublishSaveParam;
import com.elitesland.scp.domain.vo.survey.SurveyQuestionRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyQuestionSaveParam;
import com.elitesland.scp.domain.vo.survey.SurveyRespVO;
import com.elitesland.scp.domain.vo.survey.SurveySaveParam;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.scpsman.SalesmanRegionRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.infr.repo.survey.SurveyAnswerRepo;
import com.elitesland.scp.infr.repo.survey.SurveyAnswerRepoProc;
import com.elitesland.scp.infr.repo.survey.SurveyOptionRepo;
import com.elitesland.scp.infr.repo.survey.SurveyPublishRepo;
import com.elitesland.scp.infr.repo.survey.SurveyPublishRepoProc;
import com.elitesland.scp.infr.repo.survey.SurveyQuestionRepo;
import com.elitesland.scp.infr.repo.survey.SurveyRepo;
import com.elitesland.scp.infr.repo.survey.SurveyRepoProc;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SurveyServiceImpl
implements SurveyService {
    private static final Logger log = LoggerFactory.getLogger(SurveyServiceImpl.class);
    private final SurveyRepo surveyRepo;
    private final SurveyRepoProc surveyRepoProc;
    private final SurveyQuestionRepo surveyQuestionRepo;
    private final SurveyOptionRepo surveyOptionRepo;
    private final SurveyPublishRepo surveyPublishRepo;
    private final SurveyPublishRepoProc surveyPublishRepoProc;
    private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    private final SalesmanRegionRepo salesmanRegionRepo;
    private final SurveyAnswerRepo surveyAnswerRepo;
    private final SurveyAnswerRepoProc surveyAnswerRepoProc;
    private final ScpMessageMngService scpMessageMngService;
    private final UserRpcService userRpcService;

    @Override
    @SysCodeProc
    public PagingVO<SurveyRespVO> search(SurveyPagingParam searchParam) {
        PagingVO<SurveyRespVO> search = this.surveyRepoProc.search(searchParam);
        if (search.getTotal() > 0L) {
            List records = search.getRecords();
            List<Long> suvIdList = records.stream().map(SurveyRespVO::getId).toList();
            Map<Long, List<SurveyPublishDO>> publishMap = this.surveyPublishRepo.findBySuvIdIn(suvIdList).stream().collect(Collectors.groupingBy(SurveyPublishDO::getSuvId));
            for (SurveyRespVO surveyRespVO : records) {
                if (!publishMap.containsKey(surveyRespVO.getId())) continue;
                String collect = publishMap.get(surveyRespVO.getId()).stream().map(SurveyPublishDO::getOuName).collect(Collectors.joining(","));
                surveyRespVO.setPublishOuName(collect);
            }
        }
        return search;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(SurveySaveParam saveVO) {
        List<SurveyQuestionSaveParam> questionList = saveVO.getQuestionList();
        if (CollectionUtils.isEmpty(questionList)) {
            throw new BusinessException("\u8bf7\u586b\u5199\u95ee\u5377\u7684\u95ee\u9898");
        }
        if (questionList.size() > 10) {
            throw new BusinessException("\u95ee\u5377\u6700\u591a\u53ef\u7ef4\u62a410\u4e2a\u95ee\u9898");
        }
        SurveyDO surveyDO = SurveyConvert.INSTANCE.saveVOToDo(saveVO);
        surveyDO.setSurveyStatus(ScpUdcEnum.SURVEY_STATUS_10.getValueCode());
        surveyDO.setFillCount(0);
        SurveyDO save = (SurveyDO)this.surveyRepo.save(surveyDO);
        List<SurveyQuestionDO> questionDOList = this.surveyQuestionRepo.findBySuvId(save.getId());
        if (CollectionUtils.isNotEmpty(questionDOList)) {
            List<Long> qusIdList = questionDOList.stream().map(BaseModel::getId).toList();
            this.surveyQuestionRepo.deleteByIdIn(qusIdList);
            this.surveyOptionRepo.deleteByQusIdIn(qusIdList);
        }
        if (CollectionUtils.isNotEmpty(saveVO.getQuestionList())) {
            for (SurveyQuestionSaveParam questionVO : saveVO.getQuestionList()) {
                SurveyQuestionDO questionDO = SurveyQuestionConvert.INSTANCE.saveParamToDo(questionVO);
                questionDO.setSuvId(save.getId());
                SurveyQuestionDO question = (SurveyQuestionDO)this.surveyQuestionRepo.save(questionDO);
                if (!CollectionUtils.isNotEmpty(questionVO.getOptionList())) continue;
                for (SurveyOptionSaveParam optionVO : questionVO.getOptionList()) {
                    SurveyOptionDO optionDO = SurveyOptionConvert.INSTANCE.saveParamToDo(optionVO);
                    optionDO.setQusId(question.getId());
                    this.surveyOptionRepo.save(optionDO);
                }
            }
        }
        return save.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(List<Long> idList) {
        this.surveyRepoProc.updateSurveyStatus(idList, ScpUdcEnum.SURVEY_STATUS_30.getValueCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer publish(SurveyPublishParam param) {
        if (param.getId() == null || CollectionUtils.isEmpty(param.getPublishList())) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        SurveyDO surveyDO = this.surveyRepo.findById(param.getId()).orElse(null);
        if (surveyDO == null || surveyDO.getSurveyStatus().equals(ScpUdcEnum.SURVEY_STATUS_30.getValueCode()) || surveyDO.getSurveyStatus().equals(ScpUdcEnum.SURVEY_STATUS_40.getValueCode())) {
            throw new RuntimeException("\u95ee\u5377\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548\u6216\u5df2\u4f5c\u5e9f");
        }
        List<SurveyPublishDO> publishDOS = this.surveyPublishRepo.findBySuvId(param.getId());
        List<String> ouCodes = publishDOS.stream().map(SurveyPublishDO::getOuCode).toList();
        ArrayList<SurveyPublishDO> publishList = new ArrayList<SurveyPublishDO>();
        for (SurveyPublishSaveParam publishParam : param.getPublishList()) {
            if (ouCodes.contains(publishParam.getOuCode())) continue;
            SurveyPublishDO publishDO = SurveyPublishConvert.INSTANCE.saveParamToDo(publishParam);
            publishDO.setSuvId(param.getId());
            publishDO.setFillStatus(ScpUdcEnum.SURVEY_FILL_STATUS_00.getValueCode());
            publishList.add(publishDO);
        }
        if (CollectionUtils.isNotEmpty(publishList) && surveyDO.getRequired() != null && surveyDO.getRequired().booleanValue()) {
            SurveyPagingParam queryVO = new SurveyPagingParam();
            queryVO.setOuCodeList(ouCodes);
            queryVO.setSurveyStatus(ScpUdcEnum.SURVEY_STATUS_20.getValueCode());
            queryVO.setNeedFilterValidTime("Y");
            queryVO.setNotSuvId(param.getId());
            queryVO.setSize(10000);
            List<SurveyPublishRespVO> records = this.surveyPublishRepoProc.findPublish(queryVO);
            if (CollectionUtils.isNotEmpty(records)) {
                String collect = records.stream().map(SurveyPublishRespVO::getOuName).collect(Collectors.joining(","));
                throw new BusinessException(collect + "\u5df2\u7ecf\u5b58\u5728\u53d1\u5e03\u8fc7\u7684\u95ee\u5377\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        }
        if (CollectionUtils.isNotEmpty(publishList)) {
            this.surveyPublishRepo.saveAll(publishList);
        }
        SysUserDTO userDTO = SecurityContextUtil.currentUser().getUser();
        this.surveyRepoProc.publish(param.getId(), userDTO);
        if ((surveyDO.getRequired() == null || !surveyDO.getRequired().booleanValue()) && CollectionUtils.isNotEmpty(publishList)) {
            ScpMessageSaveVO saveVO = new ScpMessageSaveVO();
            saveVO.setTitle("\u60a8\u6709\u4e00\u4efd\u5f85\u586b\u5199\u95ee\u5377");
            saveVO.setSummaries("\u60a8\u6709\u4e00\u4efd\u5f85\u586b\u5199\u95ee\u5377");
            saveVO.setTxt("\u60a8\u6709\u4e00\u4efd\u5f85\u586b\u5199\u95ee\u5377");
            saveVO.setAuthorId(userDTO.getId());
            saveVO.setInvalidTime(surveyDO.getEndTime());
            saveVO.setPushApplet(true);
            saveVO.setPublishTime(LocalDateTime.now());
            saveVO.setSuvId(surveyDO.getId());
            List<String> ouCodeList = publishList.stream().map(SurveyPublishDO::getOuCode).distinct().toList();
            saveVO.setOrgStoreCodes(ouCodeList);
            this.scpMessageMngService.save(saveVO);
        }
        return publishList.size();
    }

    @Override
    @SysCodeProc
    public SurveyRespVO get(Long id) {
        Optional byId = this.surveyRepo.findById(id);
        if (byId.isEmpty()) {
            throw new RuntimeException("\u95ee\u5377\u4e0d\u5b58\u5728");
        }
        SurveyRespVO surveyRespVO = SurveyConvert.INSTANCE.doToRespVO((SurveyDO)byId.get());
        List<SurveyQuestionDO> questionDOList = this.surveyQuestionRepo.findBySuvId(id);
        if (CollectionUtils.isNotEmpty(questionDOList)) {
            List<SurveyQuestionRespVO> questionRespVOList = SurveyQuestionConvert.INSTANCE.doListToRespVOList(questionDOList);
            List<Long> qusIdList = questionRespVOList.stream().map(SurveyQuestionRespVO::getId).distinct().toList();
            Map<Long, List<SurveyOptionDO>> collect = this.surveyOptionRepo.findByQusIdIn(qusIdList).stream().collect(Collectors.groupingBy(SurveyOptionDO::getQusId));
            for (SurveyQuestionRespVO questionRespVO : questionRespVOList) {
                if (!collect.containsKey(questionRespVO.getId())) continue;
                List<SurveyOptionDO> surveyOptionDOList = collect.get(questionRespVO.getId());
                List<SurveyOptionRespVO> optionRespVOList = SurveyOptionConvert.INSTANCE.doListToRespVOList(surveyOptionDOList);
                questionRespVO.setOptionList(optionRespVOList);
            }
            surveyRespVO.setQuestionList(questionRespVOList);
        }
        return surveyRespVO;
    }

    @Override
    public List<SurveyCheckRespVO> findSurvey() {
        GeneralUserDetails generalUserDetails = SecurityContextUtil.currentUser();
        if (generalUserDetails == null || generalUserDetails.getUser() == null) {
            log.info("\u83b7\u53d6\u95ee\u5377\uff1a\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        String username = generalUserDetails.getUser().getUsername();
        return this.findSurvey(username, null);
    }

    @Override
    public List<SurveyCheckRespVO> findSurvey(String username, List<String> storeCodeList) {
        List<ScpsmanRegionDO> regionDO;
        SalesmanInfoQueryVO queryVO = new SalesmanInfoQueryVO();
        queryVO.setLoginAccount(username);
        JPAQuery<SalesmanInfoRespVO> jpaQuery = this.scpsmanInfoRepoProc.findSalesmanInfo(queryVO);
        List salesmanInfoList = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)salesmanInfoList)) {
            log.info("\u83b7\u53d6\u95ee\u5377\uff1a\u8ba2\u8d27\u8d26\u53f7\u4e3a\u7a7a");
            return new ArrayList<SurveyCheckRespVO>();
        }
        SalesmanInfoRespVO salesmanInfoRespVO = (SalesmanInfoRespVO)salesmanInfoList.get(0);
        if (UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(salesmanInfoRespVO.getScpsmanType()) && CollectionUtils.isNotEmpty(regionDO = this.salesmanRegionRepo.findByMasIdIn(List.of(salesmanInfoRespVO.getId())))) {
            List<String> finalStoreCodeList = storeCodeList;
            if (CollectionUtils.isEmpty(storeCodeList)) {
                finalStoreCodeList = regionDO.stream().map(ScpsmanRegionDO::getRegionCode).toList();
            }
            SurveyPagingParam param = new SurveyPagingParam();
            param.setNeedFilterValidTime("Y");
            param.setOuCodeList(finalStoreCodeList);
            param.setSurveyStatus(ScpUdcEnum.SURVEY_STATUS_20.getValueCode());
            param.setRequired(true);
            List<SurveyRespVO> survey = this.surveyRepoProc.findSurvey(param);
            ArrayList<SurveyCheckRespVO> resultList = new ArrayList<SurveyCheckRespVO>();
            if (CollectionUtils.isNotEmpty(survey)) {
                List<Long> suvIdList = survey.stream().map(SurveyRespVO::getId).toList();
                Map<String, List<SurveyAnswerDO>> collect = this.surveyAnswerRepo.findBySuvIdInAndOuCodeIn(suvIdList, finalStoreCodeList).stream().collect(Collectors.groupingBy(t -> t.getSuvId() + "-" + t.getOuCode()));
                Iterator<String> iterator = finalStoreCodeList.iterator();
                if (iterator.hasNext()) {
                    String storeCode = iterator.next();
                    SurveyCheckRespVO respVO = new SurveyCheckRespVO();
                    respVO.setUsername(username);
                    respVO.setStoreCode(storeCode);
                    respVO.setHaveSurvey(true);
                    respVO.setSuvId(survey.get(0).getId());
                    respVO.setFillStatus(collect.containsKey(respVO.getSuvId() + "-" + storeCode));
                    resultList.add(respVO);
                    return resultList;
                }
            }
        }
        return new ArrayList<SurveyCheckRespVO>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void fillSurvey(String storeCode, List<SurveyAnswerSaveParam> saveParamList) {
        if (CollectionUtils.isEmpty(saveParamList)) {
            throw new BusinessException("\u8bf7\u586b\u5199\u95ee\u5377");
        }
        SurveyRespVO surveyRespVO = this.get(saveParamList.get(0).getSuvId());
        if (!ScpUdcEnum.SURVEY_STATUS_20.getValueCode().equals(surveyRespVO.getSurveyStatus())) {
            throw new RuntimeException("\u8be5\u95ee\u5377\u72b6\u6001\u4e0d\u662f\u5df2\u53d1\u5e03\uff0c\u65e0\u6cd5\u586b\u5199");
        }
        if (surveyRespVO.getBeginTime().isAfter(LocalDateTime.now()) || surveyRespVO.getEndTime().isBefore(LocalDateTime.now())) {
            throw new RuntimeException("\u95ee\u5377\u4e0d\u5728\u7b54\u9898\u65f6\u95f4\u6bb5\u5185");
        }
        GeneralUserDetails generalUserDetails = SecurityContextUtil.currentUser();
        if (generalUserDetails == null || generalUserDetails.getUser() == null) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SalesmanInfoQueryVO queryVO = new SalesmanInfoQueryVO();
        queryVO.setLoginAccount(generalUserDetails.getUser().getUsername());
        JPAQuery<SalesmanInfoRespVO> jpaQuery = this.scpsmanInfoRepoProc.findSalesmanInfo(queryVO);
        List salesmanInfoList = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)salesmanInfoList)) {
            throw new RuntimeException("\u8ba2\u8d27\u8d26\u53f7\u4e3a\u7a7a");
        }
        SalesmanInfoRespVO salesmanInfoRespVO = (SalesmanInfoRespVO)salesmanInfoList.get(0);
        if (!UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(salesmanInfoRespVO.getScpsmanType())) {
            throw new RuntimeException("\u4ec5\u5e97\u957f\u53ef\u4ee5\u586b\u5199");
        }
        List<SurveyAnswerDO> surveyAnswerDOList = this.surveyAnswerRepo.findBySuvIdAndUserId(surveyRespVO.getId(), generalUserDetails.getUser().getId());
        if (CollectionUtils.isNotEmpty(surveyAnswerDOList)) {
            throw new RuntimeException("\u8be5\u7528\u6237\u5df2\u586b\u5199\u8fc7\u95ee\u5377");
        }
        List<ScpsmanRegionDO> regionDO = this.salesmanRegionRepo.findByMasIdIn(List.of(salesmanInfoRespVO.getId()));
        if (CollectionUtils.isEmpty(regionDO)) {
            throw new RuntimeException("\u7528\u6237\u65e0\u95e8\u5e97\u4fe1\u606f");
        }
        Optional<ScpsmanRegionDO> first = regionDO.stream().filter(t -> t.getRegionCode().equals(storeCode)).findFirst();
        if (first.isEmpty()) {
            throw new RuntimeException("\u7528\u6237\u672a\u7ed1\u5b9a" + storeCode + "\u95e8\u5e97\u4fe1\u606f");
        }
        ArrayList<SurveyAnswerDO> answerDOList = new ArrayList<SurveyAnswerDO>();
        for (SurveyAnswerSaveParam saveParam : saveParamList) {
            SurveyAnswerDO answerDO = SurveyAnswerConvert.INSTANCE.saveParamToDo(saveParam);
            answerDO.setUserId(generalUserDetails.getUser().getId());
            answerDO.setUsername(generalUserDetails.getUser().getUsername());
            answerDO.setOuCode(storeCode);
            answerDOList.add(answerDO);
        }
        this.surveyAnswerRepo.saveAll(answerDOList);
        this.surveyPublishRepo.updateFillStatusByCode(surveyRespVO.getId(), storeCode);
        this.surveyRepo.updateFillCountById(surveyRespVO.getId());
    }

    @Override
    public SurveyRespVO fillDetail(Long id) {
        Optional byId = this.surveyRepo.findById(id);
        if (byId.isEmpty()) {
            throw new RuntimeException("\u95ee\u5377\u4e0d\u5b58\u5728");
        }
        SurveyRespVO surveyRespVO = SurveyConvert.INSTANCE.doToRespVO((SurveyDO)byId.get());
        SurveyPagingParam param = new SurveyPagingParam();
        param.setSuvId(id);
        param.setSize(10);
        PagingVO<SurveyAnswerRespVO> voPagingVO = this.fillDetailList(param);
        surveyRespVO.setAnswerList(voPagingVO.getRecords());
        return surveyRespVO;
    }

    @Override
    public PagingVO<SurveyAnswerRespVO> fillDetailList(SurveyPagingParam param) {
        PagingVO<SurveyAnswerRespVO> search = this.surveyAnswerRepoProc.search(param);
        if (search.getTotal() > 0L) {
            List records = search.getRecords();
            SurveyAnswerParam answerParam = new SurveyAnswerParam();
            answerParam.setSuvId(param.getSuvId());
            answerParam.setOuCodeList(records.stream().map(SurveyAnswerRespVO::getOuCode).toList());
            Map<String, List<SurveyAnswerRespVO>> collect = this.surveyAnswerRepoProc.findAnswer(answerParam).stream().collect(Collectors.groupingBy(SurveyAnswerRespVO::getOuCodeAndSuvId));
            records.forEach(item -> {
                if (collect.containsKey(item.getOuCodeAndSuvId())) {
                    item.setAnswerList((List)collect.get(item.getOuCodeAndSuvId()));
                }
            });
        }
        return search;
    }

    @Override
    public List<SurveyAnalysisRespVO> surveyAnalysis(Long id) {
        ArrayList<SurveyAnalysisRespVO> results = new ArrayList<SurveyAnalysisRespVO>();
        SurveyAnswerParam answerParam = new SurveyAnswerParam();
        answerParam.setSuvId(id);
        List<SurveyAnswerRespVO> answerList = this.surveyAnswerRepoProc.findAnswer(answerParam);
        if (CollectionUtils.isNotEmpty(answerList)) {
            SurveyRespVO surveyRespVO = this.get(id);
            Map<Long, SurveyQuestionRespVO> questionMap = surveyRespVO.getQuestionList().stream().collect(Collectors.toMap(SurveyQuestionRespVO::getId, t -> t));
            Map<Long, List<SurveyAnswerRespVO>> collect = answerList.stream().collect(Collectors.groupingBy(SurveyAnswerRespVO::getQusId));
            int total = answerList.stream().map(SurveyAnswerRespVO::getOuCode).distinct().toList().size();
            for (Long qusId : collect.keySet()) {
                List<SurveyAnswerRespVO> surveyAnswerRespVOS = collect.get(qusId);
                SurveyAnalysisRespVO analysisRespVO = new SurveyAnalysisRespVO();
                analysisRespVO.setSuvId(id);
                analysisRespVO.setQusType(surveyAnswerRespVOS.get(0).getQusType());
                analysisRespVO.setQusTitle(surveyAnswerRespVOS.get(0).getQusTitle());
                SurveyQuestionRespVO question = questionMap.get(qusId);
                ArrayList<SurveyAnalysisDetailRespVO> details = new ArrayList<SurveyAnalysisDetailRespVO>();
                for (SurveyOptionRespVO option : question.getOptionList()) {
                    SurveyAnalysisDetailRespVO detail = new SurveyAnalysisDetailRespVO();
                    detail.setOpContent(option.getOpContent());
                    detail.setCount(surveyAnswerRespVOS.stream().filter(t -> t.getOptId().equals(option.getId())).count());
                    detail.setPercentage(new BigDecimal(detail.getCount()).divide(new BigDecimal(total), 2, RoundingMode.HALF_UP));
                    details.add(detail);
                }
                analysisRespVO.setOptionList(details);
                results.add(analysisRespVO);
            }
        }
        return results;
    }

    @Override
    public PagingVO<ScpSurveyAnalysisExportRespVO> exportSearch(SurveyPagingParam param) {
        if (param.getSuvId() == null) {
            throw new RuntimeException("\u95ee\u5377ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SurveyAnswerParam answerParam = new SurveyAnswerParam();
        answerParam.setSuvId(param.getSuvId());
        List<SurveyAnswerRespVO> answerList = this.surveyAnswerRepoProc.findAnswer(answerParam);
        if (CollectionUtils.isEmpty(answerList)) {
            return PagingVO.empty();
        }
        Optional option = this.surveyRepo.findById(param.getSuvId());
        if (option.isEmpty()) {
            throw new RuntimeException("\u95ee\u5377\u4e0d\u5b58\u5728");
        }
        SurveyDO surveyDO = (SurveyDO)option.get();
        Map<String, List<SurveyAnswerRespVO>> collect = answerList.stream().collect(Collectors.groupingBy(SurveyAnswerRespVO::getOuCode));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Set list = answerList.stream().map(SurveyAnswerRespVO::getUsername).distinct().collect(Collectors.toSet());
        UserQueryDTO queryDTO = new UserQueryDTO();
        queryDTO.setUsernames(list);
        ApiResult apiResult = this.userRpcService.queryUser(queryDTO);
        Map<Object, Object> userMap = new HashMap();
        if (apiResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)apiResult.getData()))) {
            userMap = ((List)apiResult.getData()).stream().collect(Collectors.toMap(SysUserBasicDTO::getUsername, SysUserBasicDTO::getLastName, (t1, t2) -> t2));
        }
        ArrayList<ScpSurveyAnalysisExportRespVO> results = new ArrayList<ScpSurveyAnalysisExportRespVO>();
        for (String ouCode : collect.keySet()) {
            List<SurveyAnswerRespVO> surveyAnswerRespVOS = collect.get(ouCode);
            if (!CollectionUtils.isNotEmpty(surveyAnswerRespVOS)) continue;
            Integer lineNo = 1;
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("surveyTitle", surveyDO.getSurveyTitle());
            map.put("ouCode", ouCode);
            map.put("ouName", surveyAnswerRespVOS.get(0).getOuName());
            map.put("username", surveyAnswerRespVOS.get(0).getUsername());
            map.put("lastName", userMap.get(surveyAnswerRespVOS.get(0).getUsername()));
            map.put("createTime", surveyAnswerRespVOS.get(0).getCreateTime().format(dateTimeFormatter));
            for (SurveyAnswerRespVO surveyAnswerRespVO : surveyAnswerRespVOS) {
                map.put("qusTitle" + lineNo, surveyAnswerRespVO.getQusTitle());
                map.put("optContent" + lineNo, ScpUdcEnum.SURVEY_QUESTION_TYPE_30.getValueCode().equals(surveyAnswerRespVO.getQusType()) ? surveyAnswerRespVO.getOptContent() : surveyAnswerRespVO.getOpContent());
                Integer n = lineNo;
                lineNo = lineNo + 1;
            }
            ScpSurveyAnalysisExportRespVO exportVO = (ScpSurveyAnalysisExportRespVO)BeanUtil.toBean(map, ScpSurveyAnalysisExportRespVO.class);
            results.add(exportVO);
        }
        return new PagingVO((long)results.size(), results);
    }

    public SurveyServiceImpl(SurveyRepo surveyRepo, SurveyRepoProc surveyRepoProc, SurveyQuestionRepo surveyQuestionRepo, SurveyOptionRepo surveyOptionRepo, SurveyPublishRepo surveyPublishRepo, SurveyPublishRepoProc surveyPublishRepoProc, ScpsmanInfoRepoProc scpsmanInfoRepoProc, SalesmanRegionRepo salesmanRegionRepo, SurveyAnswerRepo surveyAnswerRepo, SurveyAnswerRepoProc surveyAnswerRepoProc, ScpMessageMngService scpMessageMngService, UserRpcService userRpcService) {
        this.surveyRepo = surveyRepo;
        this.surveyRepoProc = surveyRepoProc;
        this.surveyQuestionRepo = surveyQuestionRepo;
        this.surveyOptionRepo = surveyOptionRepo;
        this.surveyPublishRepo = surveyPublishRepo;
        this.surveyPublishRepoProc = surveyPublishRepoProc;
        this.scpsmanInfoRepoProc = scpsmanInfoRepoProc;
        this.salesmanRegionRepo = salesmanRegionRepo;
        this.surveyAnswerRepo = surveyAnswerRepo;
        this.surveyAnswerRepoProc = surveyAnswerRepoProc;
        this.scpMessageMngService = scpMessageMngService;
        this.userRpcService = userRpcService;
    }
}

