/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.boot.provider.IdFactory;
import com.elitesland.scp.boh.StoreReceiveSendParam;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.infr.dto.boh.DemandOrderDtl;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveDRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.scp.mq.DemandOrderSimpleDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StoreReceiveDeliveryListener
implements MessageQueueListener<StoreReceiveSendParam> {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveDeliveryListener.class);
    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final StoreReceiveDRepo storeReceiveDRepo;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;

    @NotEmpty
    public String[] channels() {
        return new String[]{"store_order_delivery"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveSendParam storeReceiveSendParam) {
        log.info("\u95e8\u5e97\u6536\u8d27\u5355-\u751f\u6210\u5f85\u6536\u8d27\uff1a{}", (Object)JSON.toJSONString((Object)storeReceiveSendParam));
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
        if (CollUtil.isNotEmpty(receiveDOS)) {
            StoreReceiveDO thisDO = receiveDOS.get(0);
            if (!Objects.equals(thisDO.getStatus(), "CE") || !Objects.equals(thisDO.getRtType(), "T")) {
                log.info("\u95e8\u5e97\u6536\u8d27\u5355\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u5904\u7406\uff1a{}", (Object)thisDO.getStatus());
                return;
            }
            thisDO.setStatus("CF");
            thisDO.setRtnDate(LocalDateTime.now());
            List<DemandOrderDtl> orderDtl = this.storeReceiveRepoProc.findOrderDtlWithSettlePrice(thisDO.getOrderId());
            Map<Long, BigDecimal> priceMap = orderDtl.stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(DemandOrderDtl::getItemId, DemandOrderDtl::getPrice, (o, n) -> n));
            BigDecimal realAmt = storeReceiveSendParam.getItems().stream().map(i -> {
                if (i.getQty() == null || i.getQty().compareTo(BigDecimal.ZERO) <= 0) {
                    return BigDecimal.ZERO;
                }
                if (!priceMap.containsKey(i.getItemId())) {
                    return BigDecimal.ZERO;
                }
                return ((BigDecimal)priceMap.get(i.getItemId())).multiply(i.getQty());
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            thisDO.setRealAmt(realAmt);
            thisDO.setTotalRealQty(storeReceiveSendParam.getItems().stream().map(StoreReceiveSendParam.OrderItem::getQty).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.storeReceiveRepo.save(thisDO);
            Map<Long, BigDecimal> orderDidQtyMap = StoreReceiveDeliveryListener.processQty(storeReceiveSendParam.getItems());
            if (storeReceiveSendParam.getRefundType().equals("REFUND")) {
                for (Map.Entry<Long, BigDecimal> item : orderDidQtyMap.entrySet()) {
                    this.scpDemandOrderDDomainService.updateCompensationQty(item.getKey(), item.getValue());
                }
            } else if (storeReceiveSendParam.getRefundType().equals("RETURN")) {
                for (Map.Entry<Long, BigDecimal> item : orderDidQtyMap.entrySet()) {
                    this.scpDemandOrderDDomainService.updateReturnQty(item.getKey(), item.getValue());
                }
            }
        } else {
            List<DemandOrderSimpleDTO> orderSimple = this.storeReceiveRepoProc.findOrderSimple(List.of(storeReceiveSendParam.getOrderId()));
            List<DemandOrderSimpleDTO> stOrderList = orderSimple.stream().filter(i -> Objects.equals(i.getType(), "0")).toList();
            if (!stOrderList.isEmpty()) {
                List<Long> orderDidList = storeReceiveSendParam.getItems().stream().map(StoreReceiveSendParam.OrderItem::getOrderDid).distinct().collect(Collectors.toList());
                List<DemandOrderDtl> orderDtl = this.storeReceiveRepoProc.findOrderDtlWithSettlePrice(orderDidList);
                Map<Long, BigDecimal> priceMap = orderDtl.stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(DemandOrderDtl::getId, DemandOrderDtl::getPrice));
                DemandOrderSimpleDTO demandOrderSimpleDTO = stOrderList.get(0);
                StoreReceiveDO receiveDO = new StoreReceiveDO();
                receiveDO.setDocCreateDate(storeReceiveSendParam.getCreateTime());
                receiveDO.setStatus("CE");
                receiveDO.setDocId(storeReceiveSendParam.getDocId());
                receiveDO.setOrderDate(demandOrderSimpleDTO.getCreateTime());
                receiveDO.setDocNo(storeReceiveSendParam.getDocNo());
                receiveDO.setOrderId(storeReceiveSendParam.getOrderId());
                receiveDO.setOrderNo(storeReceiveSendParam.getOrderNo());
                receiveDO.setStoreId(demandOrderSimpleDTO.getStoreId());
                receiveDO.setOrderSetId(demandOrderSimpleDTO.getOrderSetId());
                receiveDO.setDocType(storeReceiveSendParam.getDocType());
                receiveDO.setTotalQty(storeReceiveSendParam.getTotalOutQty());
                receiveDO.setDeliveryDate(storeReceiveSendParam.getDeliveryDate());
                BigDecimal totalAmt = BigDecimal.ZERO;
                for (StoreReceiveSendParam.OrderItem item : storeReceiveSendParam.getItems()) {
                    BigDecimal price;
                    if (item.getQty().compareTo(BigDecimal.ZERO) <= 0 || (price = priceMap.get(item.getOrderDid())) == null) continue;
                    totalAmt = totalAmt.add(price.multiply(item.getQty()));
                }
                receiveDO.setTotalAmt(totalAmt.setScale(2, RoundingMode.HALF_UP));
                receiveDO.setRtType("R");
                StoreReceiveDO saved = (StoreReceiveDO)this.storeReceiveRepo.save(receiveDO);
                ArrayList<StoreReceiveDDO> receiveDDOS = new ArrayList<StoreReceiveDDO>();
                for (StoreReceiveSendParam.OrderItem item : storeReceiveSendParam.getItems()) {
                    StoreReceiveDDO storeReceiveDDO = new StoreReceiveDDO();
                    storeReceiveDDO.setDid(item.getDid());
                    storeReceiveDDO.setId(IdFactory.generateLong());
                    storeReceiveDDO.setItemId(item.getItemId());
                    storeReceiveDDO.setMasId(saved.getId());
                    storeReceiveDDO.setQty(item.getQty());
                    storeReceiveDDO.setPrice(priceMap.get(item.getOrderDid()));
                    receiveDDOS.add(storeReceiveDDO);
                }
                this.storeReceiveDRepo.saveAll(receiveDDOS);
            }
            if (storeReceiveSendParam.getDocType().equals("GR")) {
                return;
            }
            log.info("\u8c03\u62e8\u5355\u66f4\u65b0\u8ba2\u8d27\u5355\u53d1\u8d27\u6570\u91cf\uff1a{}", (Object)JSONUtil.toJsonStr((Object)storeReceiveSendParam.getItems()));
            Map<Long, BigDecimal> orderDidQtyMap = StoreReceiveDeliveryListener.processQty(storeReceiveSendParam.getItems());
            log.info("\u8c03\u62e8\u5355\u66f4\u65b0\u53d1\u8d27\u6570\u91cf\u5b57\u5178\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr(orderDidQtyMap));
            for (Map.Entry<Long, BigDecimal> item : orderDidQtyMap.entrySet()) {
                Long did = item.getKey();
                BigDecimal qty = item.getValue();
                this.scpDemandOrderDDomainService.updateQuantity(did, qty);
            }
            this.scpDemandOrderDomainService.updateDocStatusById(storeReceiveSendParam.getOrderId(), "DELIVERY");
        }
    }

    public static Map<Long, BigDecimal> processQty(List<StoreReceiveSendParam.OrderItem> orderItems) {
        return orderItems.stream().collect(Collectors.groupingBy(StoreReceiveSendParam.OrderItem::getOrderDid, Collectors.mapping(StoreReceiveSendParam.OrderItem::getQty, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
    }

    public StoreReceiveDeliveryListener(StoreReceiveRepo storeReceiveRepo, StoreReceiveRepoProc storeReceiveRepoProc, ScpDemandOrderDDomainService scpDemandOrderDDomainService, StoreReceiveDRepo storeReceiveDRepo, ScpDemandOrderDomainService scpDemandOrderDomainService) {
        this.storeReceiveRepo = storeReceiveRepo;
        this.storeReceiveRepoProc = storeReceiveRepoProc;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.storeReceiveDRepo = storeReceiveDRepo;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
    }
}

