/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.provider.authority;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.service.authority.InvWhAuthorityRpcService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/authority/invwh"})
public class ScpmansAuthorityRpcServiceImpl
implements InvWhAuthorityRpcService {
    private static final Logger log = LoggerFactory.getLogger(ScpmansAuthorityRpcServiceImpl.class);
    private final ScpDemandAuthorityService scpDemandAuthorityService;

    public ApiResult<List<String>> getAuthorityData() {
        log.info("\u3010getAuthorityData\u3011\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8d26\u53f7\u5bf9\u5e94\u7684\u8ba1\u5212\u5458\u6743\u9650\u6240\u5c5e\u4ed3\u5e93\uff1a{}");
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setType(1L);
        scpManAuthorityParam.setEnableStatus(true);
        scpManAuthorityParam.setSize(Integer.MAX_VALUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return null;
        }
        List records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List whCodeList = records.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getStWhCode())).map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
        log.info("\u3010getAuthorityData\u3011\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8d26\u53f7\u5bf9\u5e94\u7684\u8ba1\u5212\u5458\u6743\u9650\u6240\u5c5e\u4ed3\u5e93\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonStr((Object)records));
        return ApiResult.ok(whCodeList);
    }

    public ApiResult<List<String>> findStoreAuthorityData() {
        log.info("\u3010findStoreAuthorityData\u3011\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8d26\u53f7\u5bf9\u5e94\u7684\u8ba1\u5212\u5458\u6743\u9650\u6240\u5c5e\u95e8\u5e97\uff1a{}");
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setType(0L);
        scpManAuthorityParam.setEnableStatus(true);
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOS = this.scpDemandAuthorityService.listQuery(scpManAuthorityParam);
        if (CollectionUtil.isEmpty(scpManAuthorityPageRespVOS)) {
            return null;
        }
        List whCodeList = scpManAuthorityPageRespVOS.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getStWhCode())).map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
        log.info("\u3010findStoreAuthorityData\u3011\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8d26\u53f7\u5bf9\u5e94\u7684\u8ba1\u5212\u5458\u6743\u9650\u6240\u5c5e\u95e8\u5e97\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonStr(scpManAuthorityPageRespVOS));
        return ApiResult.ok(whCodeList);
    }

    public ApiResult<List<Long>> getAuthorityDataIds() {
        log.info("\u3010getAuthorityData\u3011\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8d26\u53f7\u5bf9\u5e94\u7684\u8ba1\u5212\u5458\u6743\u9650\u6240\u5c5e\u4ed3\u5e93\uff1a{}");
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setType(1L);
        scpManAuthorityParam.setEnableStatus(true);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return null;
        }
        List records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List collect = records.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getStWhId())).map(ScpManAuthorityPageRespVO::getStWhId).collect(Collectors.toList());
        log.info("\u3010getAuthorityData\u3011\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8d26\u53f7\u5bf9\u5e94\u7684\u8ba1\u5212\u5458\u6743\u9650\u6240\u5c5e\u4ed3\u5e93\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonStr(collect));
        return ApiResult.ok(collect);
    }

    public ScpmansAuthorityRpcServiceImpl(ScpDemandAuthorityService scpDemandAuthorityService) {
        this.scpDemandAuthorityService = scpDemandAuthorityService;
    }
}

