package com.elitesland.scp.application.facade.vo.param.authority;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * ClassName: ScpsManAuthorityParam
 * Description:
 *
 * @author wz
 * @date 2024/3/18 18:48
 */
@Data
@ApiModel(value = "计划员权限分配", description = "计划员权限分配")
public class ScpManAuthorityParam extends AbstractOrderQueryParam {
    /** 计划员id */
    @ApiModelProperty(name = "计划员id")
    private Long scpsmanId ;

    /** 计划员编码 */
    @ApiModelProperty(name = "计划员编码")
    private String scpsmanNo ;

    /** 计划员名称 */
    @ApiModelProperty(name = "计划员名称")
    private String scpsmanName ;

    /** 公司id */
    @ApiModelProperty(name = "公司id")
    private Long ouId ;

    /** 公司名称 */
    @ApiModelProperty(name = "公司名称")
    private String ouName ;

    /** 公司编码 */
    @ApiModelProperty(name = "公司编码")
    private String ouCode ;

    /** 启用状态 */
    @ApiModelProperty(name = "启用状态")
    private Boolean enableStatus ;

    /** 备注 */
    @ApiModelProperty(name = "备注")
    private String remark ;

    /** 类型 */
    @ApiModelProperty(name = "类型")
    private Long type ;

    /** 门店编码/仓库编码 */
    @ApiModelProperty(name = "门店编码/仓库编码")
    private String stWhCode ;

    /** 门店名称/仓库名称 */
    @ApiModelProperty(name = "门店名称/仓库名称")
    private String stWhName;

    /** 门店编码/仓库编码集合*/
    @ApiModelProperty(name = "门店编码/仓库编码集合")
    private List<String> stWhCodeList;

    /** 门店名称/仓库名称集合 */
    @ApiModelProperty(name = "门店名称/仓库名称集合")
    private List<String> stWhNameList;

    @ApiModelProperty("登录账号")
    private String loginAccount;

    @ApiModelProperty("登录账号")
    private List<String> loginAccounts;

    /**
     * id集合
     */
    @ApiModelProperty(name = "id集合")
    private List<Long> ids;

    /**
     * 明细id集合
     */
    @ApiModelProperty(name = "明细id集合")
    private List<Long> detailIds;

    @ApiModelProperty(name = "类型集合")
    private List<Integer> types;

    @ApiModelProperty("区域")
    private List<String> regions;

    @ApiModelProperty("手机号")
    private String mobile;
}
