package com.elitesland.scp.application.facade.vo.param.item;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
@ApiModel(value = "品类商品入参")
public class ScpCateItemParam {

    @ApiModelProperty("分类id")
    @NotNull(message = "分类不能为空")
    private Long cateId;

    @ApiModelProperty("分类CODE")
    @NotNull(message = "分类不能为空")
    private String cateCode;

    @ApiModelProperty("商品")
    @NotEmpty(message = "商品")
    @Valid
    private List<CateItem> items;



    @Data
    public static class CateItem{
        @ApiModelProperty("商品id")
        @NotNull(message = "商品不能为空")
        private Long itemId;

        @ApiModelProperty("商品code")
        @NotNull(message = "商品不能为空")
        private String itemCode;

        @ApiModelProperty("商品anme")
        @NotNull(message = "商品不能为空")
        private String itemName;
    }





}
