package com.elitesland.scp.application.facade.vo.resp.app;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("门店订货小程序商品库存")
public class AppInvStkRespVO implements Serializable {
    private static final long serialVersionUID = 5075238331588176943L;

    @ApiModelProperty(value = "基本单位")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "领用单位")
    private String receiveUom;
    private String receiveUomName;

    @ApiModelProperty(value = "商品图片")
    private String imgUrl;

    @ApiModelProperty("spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty(value = "spuCode")
    private String spuCode;

    @ApiModelProperty(value = "spuName")
    private String spuName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty(value = "总在库数量")
    private BigDecimal ohQty;

    @ApiModelProperty(value = "余数数量")
    private BigDecimal remQty;

    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "包装规格")
    private String itemAttrName;

    @ApiModelProperty(value = "仓库ID")
    private Long whId;



}
