package com.elitesland.scp.application.facade.vo.resp.collect;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("收藏夹返回")
public class ScpUserCollectRespVO implements Serializable {
    private static final long serialVersionUID = -1623254442864140424L;

    @ApiModelProperty("商品SPU-ID编码")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("商品SPU编码")
    private String spuCode;

    @ApiModelProperty("商品SPU名称")
    private String spuName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("是否组合商品")
    private Boolean combineItemFlag;

    @ApiModelProperty(value = "组合数量")
    private BigDecimal combineQty;

    @ApiModelProperty("子件商品")
    private List<ScpUserCollectRespVO> subItemList;


    @ApiModelProperty("sku商品详情")
    private List<ScpUserCollectRespVO.ItemSpecObjectVO> itemSpecObjectVOS;

    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("单位名称")
        private String uomName;

        @ApiModelProperty("商品ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty("商品规格编码(SKU编码)")
        private String itemCode;

        @ApiModelProperty("商品规格名称(SKU名称)")
        private String itemName;

        @ApiModelProperty("箱规")
        private String itemAttrName;

        @ApiModelProperty("含税单价")
        private BigDecimal itemPrice;

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("基本单位")
        private String uom2;
        @ApiModelProperty(value = "基本单位名称")
        private String uom2Name;

        @ApiModelProperty("单位转换系数")
        private BigDecimal uomRatio;

        @ApiModelProperty("有效位数")
        private Integer decimalPlaces;

        @ApiModelProperty(value = "商品分类")
        private String itemType;

        @ApiModelProperty(value = "最小起订量")
        private BigDecimal moq;

        @ApiModelProperty("scp品类编码")
        private String scpItemCateCode;

        @ApiModelProperty("scp品类名称")
        private String scpItemCateName;

        @ApiModelProperty("供应商ID")
        private Long suppId;

        @ApiModelProperty("供应商编码")
        private String suppCode;

        @ApiModelProperty("供应商名称")
        private String suppName;

        @ApiModelProperty("门店编码")
        private String storeCode;

        @ApiModelProperty("仓配结算价")
        private BigDecimal costPrice;

        @ApiModelProperty("采购价")
        private BigDecimal purPrice;

        @ApiModelProperty("货款总价格（含服务费）")
        private BigDecimal price;

        @ApiModelProperty("货款单价")
        private BigDecimal salePrice;

        @ApiModelProperty("科技费价格")
        private BigDecimal tefPrice;

        @ApiModelProperty("营销费价格")
        private BigDecimal mefPrice;

        @ApiModelProperty("运营费价格")
        private BigDecimal oefPrice;


        @ApiModelProperty("是否收取项目费用")
        private Boolean isProjFeeCharged;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuCode;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuCode;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuCode;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuName;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuName;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuName;

    }

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("图片url")
    private String url;

    private String fileCode;

    @ApiModelProperty("商品品类编码")
    private String itemCateCode;

    @ApiModelProperty("商品品类名称")
    private String itemCateName;
}
