package com.elitesland.scp.application.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.whnet.*;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.inv.ScpWhNetRelationConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.whnet.ScpWhNetRelationDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.whnet.ScpWhNetRelationDomainService;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.whnet.ScpWhNetRelationDTO;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepo;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.scp.param.ScpWhNetRelationParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemCateSimpleTreeRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathDRpcDTO;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static cn.hutool.core.date.LocalDateTimeUtil.isOverlap;
import static org.springframework.beans.BeanUtils.copyProperties;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 20日 14:02
 * @version: 1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpWhNetRelationServiceImpl implements ScpWhNetRelationService {

    private final ScpWhNetRelationDomainService scpWhNetRelationDomainService;
    private final ScpWhNetRelationRepo scpWhNetRelationRepo;

    private final ItmItemRpcService itmItemRpcService;

    private final UdcProvider udcProvider;

    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;

    private final UdcProvider systemService;

    private final InvWhProvider whProvider;

    private final OrgStoreRpcService orgStoreRpcService;

    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final RmiInvStkRpcService rmiInvStkService;
    private final SupportTransactionPathRpcService supportTransactionPathRpcService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final OrgOuRpcService orgOuRpcService;
    @Override
    public PagingVO<ScpWhNetRelationPageVO> page(ScpWhNetRelationPageParamVO queryParam) {
        if (Boolean.TRUE.equals(queryParam.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO<>();
            }
            extractedAuthorityParam(queryParam, pagingVO);
        }
        return scpWhNetRelationDomainService.page(queryParam);
    }

    @Override
    public OuInfo findOuInfo(OuInfoQueryParamVO queryParam) {
        OuInfo ouInfo = getOuInfoFromPathCode(queryParam.getSupplyWhCode(), queryParam.getDemandWhStCode(),
                queryParam.getType());
        log.info("仓网关系,查询销售公司信息:{}", JSONUtil.toJsonStr(ouInfo));
        return ouInfo;
    }

    /**
     * 保存仓网关系配置
     *
     * @param createParam 仓网关系保存参数
     * @return API结果对象，包含成功和失败的配置项
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<?> saveWhNetRelation(ScpWhNetRelationSaveVO createParam) {
        // 获取仓网关系入参
        List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelationList = createParam.getScpWhNetRelations();
        // 按组合键（需求仓库+配送类型+商品品类+商品）分组
        Map<String, List<ScpWhNetRelationSaveVO.ScpWhNetRelation>> groupMap = whNetRelationList.stream()
                .collect(Collectors.groupingBy(d ->
                        d.getDemandWhStCode()
                                + d.getDeliveryType()
                                + setEmptyStringStr(d.getItemCateCode())
                                + setEmptyStringStr(d.getItemCode())
                ));
        Set<String> strings = groupMap.keySet();
        // 查询已存在的仓网关系
        List<ScpWhNetRelationDO> existList = scpWhNetRelationDomainService.findByConcatKey(strings);

        Map<String, List<ScpWhNetRelationDO>> existMap =
                existList.stream().collect(Collectors.groupingBy(d -> d.getDemandWhStCode()
                        + d.getDeliveryType()
                        + setEmptyStringStr(d.getItemCateCode())
                        + setEmptyStringStr(d.getItemCode())));

        Set<String> modifySet = new HashSet<>();
        ScpWhNetRelationResultVO result = new ScpWhNetRelationResultVO();
        List<ScpWhNetRelationResultVO.ResultVO> failList = new ArrayList<>();
        List<ScpWhNetRelationResultVO.ResultVO> successList = new ArrayList<>();

        List<ScpWhNetRelationSaveVO.ScpWhNetRelation> saveInfo = new ArrayList<>();
        List<ScpWhNetRelationDO> updateTimeList = new ArrayList<>();
        for (var scpWhNetRelation : groupMap.entrySet()) {
            String relationKey = scpWhNetRelation.getKey();
            val whNetRelations = scpWhNetRelation.getValue();
            long count = whNetRelations.stream().filter(d -> d.getId() != null).count();
            var activateList =
                    whNetRelations.stream().filter(d -> Boolean.TRUE.equals(d.getStatus())).collect(Collectors.toList());
            // 数据重复校验
            long count1 = activateList.stream().map(d -> d.getSupplyWhCode()
                    + d.getDemandWhStCode() + d.getType()
                    + d.getItemCateCode() + d.getItemCode() + d.getStatus()).count();
            long count2 = activateList.stream().map(d -> d.getSupplyWhCode()
                    + d.getDemandWhStCode() + d.getType()
                    + d.getItemCateCode() + d.getItemCode() + d.getStatus()).distinct().count();
            if (count2 != count1) {
                String errorMsg = String.format("需求仓库-商品品类-商品【%s-%s-%s】存在相同【供应商仓-类型】组合数据，请检查",
                        whNetRelations.get(0).getDemandWhStCode(), whNetRelations.get(0).getItemCateCode(),
                        whNetRelations.get(0).getItemCode());
                throw new BusinessException(ApiCode.FAIL, errorMsg);
            }
            // 同组合配置校验
            if (CollUtil.isNotEmpty(activateList)) {
                if (count == 0 && existMap.containsKey(relationKey)) {
                    // 新增并且有重复的，则拆分有效日期
                    List<ScpWhNetRelationDO> existingRelations = existMap.get(relationKey);
                    List<ScpWhNetRelationSaveVO.ScpWhNetRelation> newRelations = new ArrayList<>();
                    if (existingRelations != null && !existingRelations.isEmpty()) {
                        for (ScpWhNetRelationDO existing : existingRelations) {
                            // 判断时间是否有交集
                            whNetRelations.forEach(newRel -> {
                                boolean b = !isOverlap(newRel.getStartTime(), newRel.getEndTime(), existing.getStartTime(), existing.getEndTime());
                                log.info("仓网有效期是否交叉判断结果{},{},{},{},{}", b, newRel.getStartTime(), newRel.getEndTime(), existing.getStartTime(), existing.getEndTime());
                                if (b) {
                                    // 没有交集
                                    newRelations.add(newRel);
                                } else {
                                    // 存在交集，特殊判断 ns = new info start time, ne = new info end time , os = old info start time, oe = old info end time
                                    // ns < os , ne > os, ne < oe ,创建一条新数据，更新旧数据
                                    if (newRel.getStartTime().isBefore(existing.getStartTime()) &&
                                            newRel.getEndTime().isAfter(existing.getStartTime()) &&
                                            newRel.getEndTime().isBefore(existing.getEndTime())) {
                                        newRelations.add(getScpWhNetRelation(newRel, newRel.getStartTime(), newRel.getEndTime()));
                                        existing.setStartTime(newRel.getEndTime());
                                        updateTimeList.add(existing);
                                    }

                                    // ns > os , ne > oe ,ns < oe ,创建一条新数据，更新旧数据
                                    else if (newRel.getStartTime().isAfter(existing.getStartTime()) &&
                                            newRel.getEndTime().isAfter(existing.getEndTime()) &&
                                            newRel.getStartTime().isBefore(existing.getEndTime())) {
                                        newRelations.add(getScpWhNetRelation(newRel, newRel.getStartTime(), newRel.getEndTime()));
                                        existing.setEndTime(newRel.getStartTime());
                                        updateTimeList.add(existing);
                                    }

                                    // 如果新数据的时间完全包含旧数据时间
                                    else if (newRel.getStartTime().isBefore(existing.getStartTime()) && newRel.getEndTime().isAfter(existing.getEndTime())) {
                                        newRelations.add(getScpWhNetRelation(newRel, newRel.getStartTime(), existing.getStartTime()));
                                        newRelations.add(getScpWhNetRelation(newRel, existing.getEndTime(), newRel.getEndTime()));

                                        existing.setStartTime(newRel.getEndTime());
                                        existing.setEndTime(newRel.getStartTime());
                                        updateTimeList.add(existing);
                                    }

                                    // 如果旧数据的时间完全包含新数据时间
                                    else if (existing.getStartTime().isBefore(newRel.getStartTime()) && existing.getEndTime().isAfter(newRel.getEndTime())) {
                                        ScpWhNetRelationSaveVO.ScpWhNetRelation splitEntry3 = new ScpWhNetRelationSaveVO.ScpWhNetRelation();
                                        copyProperties(existing, splitEntry3);
                                        // 添加旧数据到新数据开始
                                        newRelations.add(getScpWhNetRelation(splitEntry3, existing.getStartTime(), newRel.getStartTime()));

                                        // 中间部分用新数据
                                        newRelations.add(getScpWhNetRelation(newRel, newRel.getStartTime(), newRel.getEndTime()));

                                        // 更改旧数据的开始时间为新数据结束时间
                                        existing.setStartTime(newRel.getEndTime());
                                        updateTimeList.add(existing);
                                    }
                                }
                            });
                        }
                    } else {
                        newRelations.addAll(whNetRelations);
                    }
                    whNetRelations.clear();
                    whNetRelations.addAll(newRelations);
                } else if (count > 0 && existMap.containsKey(relationKey)) {
                    // 修改
                    modifySet.add(relationKey);
                }
                saveInfo.addAll(whNetRelations);
            }
        }
        if (CollUtil.isEmpty(failList)) {
            List<ScpWhNetRelationDTO> whNetRelationDOS = saveInfo.stream().map(ScpWhNetRelationConvert.INSTANCE::saveVoDto).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(modifySet)) {
                List<ScpWhNetRelationDO> modifyList = scpWhNetRelationDomainService.findByConcatKey(modifySet);
                List<Long> existIds = modifyList.stream().map(ScpWhNetRelationDO::getId).collect(Collectors.toList());
                scpWhNetRelationDomainService.deleteBatch(existIds);
            }
            // 校验结算路径
            checkTransactionPath(whNetRelationDOS, createParam.getSkipPathFlag());
            scpWhNetRelationDomainService.createBatch(whNetRelationDOS);
            if (CollUtil.isNotEmpty(updateTimeList)) {
                scpWhNetRelationRepo.saveAll(updateTimeList);
            }
            return ApiResult.builder().success(true).code(200).data(result).msg("操作成功").build();
        } else {
            return ApiResult.builder().success(false).code(0).data(result).msg("操作失败").build();
        }
    }

    /**
     * 拷贝数据
     *
     * @param newRel
     * @param startTime
     * @param endTime
     * @return
     */
    private ScpWhNetRelationSaveVO.ScpWhNetRelation getScpWhNetRelation(ScpWhNetRelationSaveVO.ScpWhNetRelation newRel, LocalDateTime startTime, LocalDateTime endTime) {
        ScpWhNetRelationSaveVO.ScpWhNetRelation splitEntry = new ScpWhNetRelationSaveVO.ScpWhNetRelation();
        copyProperties(newRel, splitEntry);
        splitEntry.setId(null);
        splitEntry.setStartTime(startTime);
        splitEntry.setEndTime(endTime);
        return splitEntry;
    }

    /**
     * 校验结算路径
     *
     * @param whNetRelationList
     */
    private void checkTransactionPath(List<ScpWhNetRelationDTO> whNetRelationList, Boolean skipPathFlag) {
        List<String> whCodes = whNetRelationList.stream().map(ScpWhNetRelationDTO::getSupplyWhCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> whMap = buildInvWhMap(whCodes);

        List<String> demandWhCodes = whNetRelationList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(row.getType())).map(ScpWhNetRelationDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> demandWhMap = buildInvWhMap(demandWhCodes);

        List<String> demandStoreCodes = whNetRelationList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).map(ScpWhNetRelationDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
        Map<String, OrgStoreBaseRpcDTO> fStoreMap = getStoreMap(demandStoreCodes);

        List<SupportTransactionPathRpcParam> rpcParams = new ArrayList<>();
        whNetRelationList.forEach(row -> {
            String demandWhStCode = row.getDemandWhStCode();
            String supplyWhCode = row.getSupplyWhCode();

            Long ouId = row.getDemandWhStOuId() != null ? row.getDemandWhStOuId() : (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? fStoreMap.get(demandWhStCode).getOuId() : demandWhMap.get(demandWhStCode).getOuId());
            Long whOuId = row.getSupplyWhOuId() != null ? row.getSupplyWhOuId() : whMap.get(supplyWhCode).getOuId();
            if (!ouId.equals(whOuId)) {
                SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
                rpcParam.setCompanyIdStart(whOuId);
                rpcParam.setCompanyIdEnd(ouId);
                rpcParams.add(rpcParam);
            }
        });
        Map<String, List<SupportTransactionPathRpcDTO>> suppTransactionPathMap = checkTransactionPathAndBuild(rpcParams);
        List<ScpWhNetRelationDTO> result = new ArrayList<>();
        whNetRelationList.forEach(row -> {
            String demandWhStCode = row.getDemandWhStCode();
            String supplyWhCode = row.getSupplyWhCode();

            Long ouId = row.getDemandWhStOuId() != null ? row.getDemandWhStOuId() : (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? fStoreMap.get(demandWhStCode).getOuId() : demandWhMap.get(demandWhStCode).getOuId());
            String ouCode = StringUtils.isNotEmpty(row.getDemandWhStOuCode()) ? row.getDemandWhStOuCode() : (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? fStoreMap.get(demandWhStCode).getOuCode() : demandWhMap.get(demandWhStCode).getOuCode());

            Long whOuId = row.getSupplyWhOuId() != null ? row.getSupplyWhOuId() : whMap.get(supplyWhCode).getOuId();
            String whOuCode = StringUtils.isNotEmpty(row.getSupplyWhOuCode()) ? row.getSupplyWhOuCode() : whMap.get(supplyWhCode).getOuCode();
            if (!ouId.equals(whOuId)) {
                List<SupportTransactionPathRpcDTO> pathList = suppTransactionPathMap.get(whOuId + "@" + ouId);
                if (CollUtil.isEmpty(pathList) || StrUtil.isBlank(pathList.get(0).getPathCode())) {
                    log.info("从公司 {}到公司 {}的结算路径不存在，请维护", whOuId, ouId);
                    if (Boolean.TRUE.equals(skipPathFlag)) {
                        throw new BusinessException("从公司【" + whOuCode + "】至公司【" + ouCode + "】的结算路径不存在，请维护");
                    }
                } else {
                    result.add(row);
                }
                var detailList = pathList.get(0).getDetailList();
                int size = detailList.size();
                SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
                row.setCustCode(dto.getCompanyCodeStart());
                row.setOuCode(dto.getCompanyCodeStart());
                row.setOuName(dto.getCompanyNameStart());
                row.setCustCode(dto.getCustCodeEnd());
            } else {
                result.add(row);
            }
        });
        whNetRelationList = result;
    }

    private Map<String, OrgStoreBaseRpcDTO> getStoreMap(List<String> demandStoreCodes) {
        List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOS = rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandStoreCodes);
        if (CollUtil.isEmpty(orgStoreBaseRpcDTOS)) {
            return new HashMap<>();
        }
        return orgStoreBaseRpcDTOS.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity(), (k1, k2) -> k1));
    }

    /**
     * 获取结算路径信息
     *
     * @param rpcParams
     * @return
     */
    private Map<String, List<SupportTransactionPathRpcDTO>> checkTransactionPathAndBuild(List<SupportTransactionPathRpcParam> rpcParams) {
        //查询结算路径
        log.info("查询启用状态的结算路径,参数:{}", JSONObject.toJSONString(rpcParams));
        List<SupportTransactionPathRpcDTO> data = supportTransactionPathRpcService.queryListByParam(rpcParams).getData();
        log.info("查询启用状态的结算路径结束,返回:{}", JSONObject.toJSONString(data));
        if (CollUtil.isEmpty(data)) {
            return new HashMap<>();
        }
        return data.stream().collect(Collectors.groupingBy(row -> row.getCompanyIdStart() + "@" + row.getCompanyIdEnd()));
    }

    private Map<String, InvWhRpcSimpleDTO> buildInvWhMap(List<String> demandWhCodes) {
        if (CollUtil.isEmpty(demandWhCodes)) {
            return new HashMap<>();
        }
        return rmiInvStkService.findInvWhBaseMapByCode(demandWhCodes);
    }

    private Map<String, OrgStoreBaseRpcDTO> getStoreInfoBy(List<String> demandStCodes) {
        log.info("批量查询门店信息入参{}", JSONUtil.toJsonStr(demandStCodes));
        List<OrgStoreBaseRpcDTO> resultList = rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandStCodes);
        log.info("批量查询门店信息结果{}", JSONUtil.toJsonStr(resultList));
        Map<String, OrgStoreBaseRpcDTO> resultMap =
                resultList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity()));
        log.info("批量查询门店信息结果字典{}", JSONUtil.toJsonStr(resultMap));
        return resultMap;
    }

    /**
     * 取得从供应仓库所在公司到需求仓库/门店所在公司之间的结算路径，取不到则销售公司为空（暂时不报错）。
     * <p>
     * 如果取到了，则取这个结算路径的最后一条明细的从公司，做为销售公司
     *
     * @param fromWhCode
     * @param toWhStCode
     * @return
     */
    private OuInfo getOuInfoFromPathCode(String fromWhCode, String toWhStCode, String type) {
        log.info("获取结算路径参数,从仓库编码:{},至仓库/门店编码:{}", fromWhCode, toWhStCode);
        InvWhRpcSimpleDTO invWhMap = rmiInvStkService.findSimpleWhByCode(fromWhCode);
        Long fromOuId = invWhMap.getOuId();
        String fromOuCode = invWhMap.getOuCode();
        Long toOuId;
        String toOuCode;
        if ("1".equals(type)) {  //仓库
            InvWhRpcSimpleDTO simpleDTO = rmiInvStkService.findSimpleWhByCode(toWhStCode);
            toOuCode = simpleDTO.getOuCode();
            toOuId = simpleDTO.getOuId();
        } else { //门店
            OrgStoreBaseRpcDTO orgStore = getOuIdByStoreCode(toWhStCode);
            toOuCode = orgStore.getOuCode();
            toOuId = orgStore.getOuId();
        }
        log.info("fromOuId的值:{},toOuId的值:{}", fromOuId, toOuId);
        if (fromOuId == null || toOuId == null) {
            return null;
        }
        SupportTransactionPathRpcDTO pathCodeResult = getPathCodeResult(fromOuId, toOuId);
        if (pathCodeResult == null) {
            throw new BusinessException("从公司【" + fromOuCode + "】至公司【" + toOuCode + "】的结算路径不存在，请维护");
        }
        log.info("获取到结算路径信息:{}", JSONUtil.toJsonStr(pathCodeResult));
        List<SupportTransactionPathDRpcDTO> detailList = pathCodeResult.getDetailList();
        int size = detailList.size();
        SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
        OuInfo ouInfo = new OuInfo();
        ouInfo.setOuCode(dto.getCompanyCodeStart());
        ouInfo.setOuName(dto.getCompanyNameStart());
        ouInfo.setOuId(dto.getCompanyIdStart());
        log.info("根据结算路径获取到销售公司信息:{}", JSONUtil.toJsonStr(ouInfo));
        return ouInfo;
    }

    private OrgStoreBaseRpcDTO getOuIdByStoreCode(String storeCode) {
        Map<String, OrgStoreBaseRpcDTO> storeInfoBy = getStoreInfoBy(Arrays.asList(storeCode));
        if (!storeInfoBy.containsKey(storeCode)) {
            throw new BusinessException("门店编码:" + storeCode + "不存在，请检查");
        }
        return storeInfoBy.get(storeCode);
    }


    private SupportTransactionPathRpcDTO getPathCodeResult(Long from, Long to) {
        log.info("查询结算路径参数,from:{},to:{}", from, to);
        SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
        rpcParam.setCompanyIdStart(from);
        rpcParam.setCompanyIdEnd(to);
        SupportTransactionPathRpcDTO result = supportTransactionPathRpcService.queryByParam(rpcParam).getData();
        log.info("查询结算路径结果:{}", JSONUtil.toJsonStr(result));
        return result;
    }

    public String setEmptyStringStr(String str) {
        return str == null ? "" : str;
    }

    private List<ScpWhNetRelationResultVO.ResultVO> getResultVOS(List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelations) {
        return whNetRelations.stream().map(w -> {
            ScpWhNetRelationResultVO.ResultVO resultVO = new ScpWhNetRelationResultVO.ResultVO();
            resultVO.setSupplyWhId(w.getId());
            resultVO.setSupplyWhCode(w.getSupplyWhCode());
            resultVO.setSupplyWhName(w.getSupplyWhName());
            resultVO.setDemandWhStCode(w.getDemandWhStCode());
            resultVO.setDemandWhStId(w.getDemandWhStId());
            resultVO.setDemandWhStName(w.getDemandWhStName());
            resultVO.setType(w.getType());
            resultVO.setItemCode(w.getItemCode());
            resultVO.setItemId(w.getItemId());
            resultVO.setItemName(w.getItemName());
            resultVO.setItemCateCode(w.getItemCateCode());
            if (StringUtils.isNotEmpty(w.getItemCateName())) {
                String itemCateName = w.getItemCateName().replace(",", ">");
                resultVO.setItemCateName(itemCateName);
            }
            resultVO.setSupplyPercentage(w.getSupplyPercentage());
            resultVO.setLineNo(w.getLineNo());
            return resultVO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ScpWhNetRelationRespVO> findWhNetList(ScpWhNetRelationBaseParamVO param) {
//        String businessKey = param.getDemandWhStCode();
//        if (StringUtils.isNotEmpty(param.getDeliveryType())) {
//            businessKey = businessKey.concat(param.getDeliveryType());
//            if (StringUtils.isNotEmpty(param.getItemCateCode())) {
//                businessKey = businessKey.concat(param.getItemCateCode());
//                if (StringUtils.isNotEmpty(param.getItemCode())) {
//                    businessKey = businessKey.concat(param.getItemCode());
//                }
//            }
//        }

        List<ScpWhNetRelationDO> relationDOS = scpWhNetRelationDomainService.findByBusinessKey(param.getDemandWhStCode(),
                param.getDeliveryType(),
                param.getItemCateCode(),
                param.getItemCode());
        List<ScpWhNetRelationRespVO> relationRespVOList = relationDOS.stream().map(ScpWhNetRelationConvert.INSTANCE::doToRespVO).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(relationRespVOList)) {
            Map<String, Map<String, String>> typeMap = udcProvider.getValueMapByUdcCode("yst-suplan", Set.of("DEMAND_SET_TYPE"));
            Map<String, String> itemType2 = udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2");
            relationRespVOList.forEach(d -> {
                d.setTypeName(typeMap.getOrDefault("DEMAND_SET_TYPE", new HashMap<>()).get(d.getType()));
                if (StringUtils.isNotEmpty(d.getItemCateCode())) {
                    List<ItmItemCateSimpleTreeRpcDTO> itemCatePath = itmItemRpcService.findItemCatePath(d.getItemCateCode());
                    d.setItemCatePath(itemCatePath);
                }

                if (StringUtils.isNotEmpty(d.getDeliveryType()) && itemType2 != null) {
                    d.setDeliveryTypeName(itemType2.get(d.getDeliveryType()));
                }
            });
        }
        return relationRespVOList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteWhNetRelation(List<Long> ids) {
        scpWhNetRelationDomainService.deleteBatch(ids);
    }


    @Override
    public List<ScpWhNetRelationRpcDTO> findWhNetRelationRpcDtoByParam(ScpWhNetRelationRpcDtoParam queryParam) {
        if (StringUtils.isNotEmpty(queryParam.getItemCode()) && StringUtils.isEmpty(queryParam.getItemCateCode())) {
            //商品品类
            ItmItemBaseRpcParam itemRpcDtoParam = new ItmItemBaseRpcParam();
            itemRpcDtoParam.setItemCodes(List.of(queryParam.getItemCode()));
            List<ItmItemBaseRpcDTO> itemRpcDtoByParam = itmItemRpcService.findItemBaseRpcDtoByParam(itemRpcDtoParam);
            queryParam.setItemCateCode(itemRpcDtoByParam.get(0).getItemCateCode());
        }
        log.info("ScpWhNetRelationRpcDtoParam:{} ", JSON.toJSONString(queryParam));
        List<ScpWhNetRelationRpcDTO> relationRpcDTOS = scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(queryParam);
        if (CollUtil.isEmpty(relationRpcDTOS)) {
            return new ArrayList<>();
        }
        return relationRpcDTOS;
    }

    @Override
    public PagingVO<ScpWhNetRelationExportRespVO> exportSearch(ScpWhNetRelationPageParamVO queryParam) {
        if (Boolean.TRUE.equals(queryParam.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO<>();
            }
            extractedAuthorityParam(queryParam, pagingVO);
        }
        return scpWhNetRelationDomainService.exportSearch(queryParam);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<String> executeImport(List<ScpWhNetRelationImportVO> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        List<String> errorList = new ArrayList<>();
        checkImportParam(dataList, errorList);
        List<String> result = validResult(errorList);
        List<Integer> successDocGroup = getSuccessDocGroup(result, dataList);
        if (successDocGroup.isEmpty()) {
            return result;
        }

        // 获取仓库信息
        List<String> whCodeList = dataList.stream()
                .map(ScpWhNetRelationImportVO::getSupplyWhCode)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        InvWhRpcDtoParam whRpcDtoParam = new InvWhRpcDtoParam();
        whRpcDtoParam.setWhCodes(whCodeList);
        ApiResult<List<InvWhRpcDTO>> whList = whProvider.findWhDTOByParam(whRpcDtoParam);
        Map<String, InvWhRpcDTO> whMap;
        if (whList.isSuccess() && whList.getData() != null) {
            whMap = whList.getData().stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, i -> i, (o, n) -> n));
        } else {
            whMap = new HashMap<>();
        }

        // 获取需求门店
        Map<String, OrgStoreBaseRpcDTO> storeMap = new HashMap<>();
        List<String> storeCodes = dataList.stream()
                .filter(d -> UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(d.getType()))
                .map(ScpWhNetRelationImportVO::getDemandWhStCode)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(storeCodes)) {
            OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
            orgStoreBaseRpcParam.setStoreCodeList(storeCodes);
            List<OrgStoreBaseRpcDTO> storeList = orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam).getData();
            if (storeList != null) {
                storeMap = storeList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, i -> i, (o, n) -> n));
            }
        }

        // 获取需求仓库
        List<String> demandWhCodes = dataList.stream()
                .filter(d -> UdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(d.getType()))
                .map(ScpWhNetRelationImportVO::getDemandWhStCode)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        Map<String, InvWhRpcDTO> demandWhMap = new HashMap<>();
        if (CollUtil.isNotEmpty(demandWhCodes)) {
            InvWhRpcDtoParam whRpcDtoParam2 = new InvWhRpcDtoParam();
            whRpcDtoParam2.setWhCodes(demandWhCodes);
            ApiResult<List<InvWhRpcDTO>> demandWhList = whProvider.findWhDTOByParam(whRpcDtoParam2);
            if (demandWhList.isSuccess() && demandWhList.getData() != null) {
                demandWhMap = demandWhList.getData().stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, i -> i, (o, n) -> n));
            }
        }

        // 获取公司信息
        List<String> ouCodes = dataList.stream()
                .flatMap(importVO -> Stream.of(importVO.getSaleOuCode(), importVO.getPurOuCode()))
                .filter(Objects::nonNull)
                .distinct()
                .collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = new HashMap<>();
        if (CollUtil.isNotEmpty(ouCodes)) {
            List<OrgOuRpcSimpleDTO> simpleOuDto1 = orgOuRpcService.findSimpleByOuCodes(ouCodes);
            if (CollUtil.isNotEmpty(simpleOuDto1)) {
                ouMap = simpleOuDto1.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, i -> i, (o, n) -> n));
            }
        }

        // 获取商品信息
        List<String> itemCodes = dataList.stream()
                .map(ScpWhNetRelationImportVO::getItemCode)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        Map<String, ItmItemRpcDTO> itemMap = new HashMap<>();
        if (CollUtil.isNotEmpty(itemCodes)) {
            ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
            itemRpcDtoParam.setItemCodes(itemCodes);
            List<ItmItemRpcDTO> itemRpcDtoByParam = itmItemRpcService.findItemRpcDtoByParam(itemRpcDtoParam);
            itemMap = itemRpcDtoByParam.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, i -> i, (o, e) -> e));
        }
        Map<Integer, List<String>> errorMap = new HashMap<>();
        List<ScpWhNetRelationDTO> scpWhNetRelationDTOS = new ArrayList<>();
        for (ScpWhNetRelationImportVO importEntity : dataList) {
            if (!successDocGroup.contains(importEntity.getLineNo())) {
                continue;
            }
            errorMap.put(importEntity.getLineNo(), new ArrayList<>());

            ScpWhNetRelationDTO scpWhNetRelationDTO = new ScpWhNetRelationDTO();
            scpWhNetRelationDTO.setType(importEntity.getType());
            scpWhNetRelationDTO.setSupplyWhCode(importEntity.getSupplyWhCode());
            InvWhRpcDTO supplyWhRpcDTO = whMap.get(importEntity.getSupplyWhCode());
            if (supplyWhRpcDTO == null) {
                errorMap.get(importEntity.getLineNo()).add("供应仓库编码" + importEntity.getSupplyWhCode() + " 不存在");
            } else {
                scpWhNetRelationDTO.setSupplyWhId(supplyWhRpcDTO.getId());
                scpWhNetRelationDTO.setSupplyWhName(supplyWhRpcDTO.getWhName());
            }
            if (UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(importEntity.getType())) {
                OrgStoreBaseRpcDTO storeDetailRpcDTO = storeMap.get(importEntity.getDemandWhStCode());
                if (storeDetailRpcDTO == null) {
                    errorMap.get(importEntity.getLineNo()).add("需求仓库编码/门店编码" + importEntity.getDemandWhStCode() + " 不存在");
                } else {
                    scpWhNetRelationDTO.setDemandWhStId(storeDetailRpcDTO.getId());
                    scpWhNetRelationDTO.setDemandWhStCode(importEntity.getDemandWhStCode());
                    scpWhNetRelationDTO.setDemandWhStName(storeDetailRpcDTO.getStoreName());
                }
                if (storeDetailRpcDTO != null && supplyWhRpcDTO != null && !Objects.equals(storeDetailRpcDTO.getOuId(), supplyWhRpcDTO.getOuId())) {
                    SupportTransactionPathRpcParam pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(supplyWhRpcDTO.getOuId());
                    pathRpcParam.setCompanyIdEnd(storeDetailRpcDTO.getOuId());
                    SupportTransactionPathRpcDTO data = supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("查询启用状态的结算路径结束,返回:{}", JSONObject.toJSONString(data));
                    if (data == null || StrUtil.isBlank(data.getPathCode())) {
                        log.info("从公司 {}到公司 {}的结算路径不存在，请维护", supplyWhRpcDTO.getOuId(), storeDetailRpcDTO.getOuId());
                        errorMap.get(importEntity.getLineNo()).add("从公司:" + supplyWhRpcDTO.getOuCode() + "到公司:" + storeDetailRpcDTO.getOuCode() + "的结算路径不存在，请维护");
                    }
                    if (data != null) {
                        var detailList = data.getDetailList();
                        int size = detailList.size();
                        SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
                        scpWhNetRelationDTO.setCustCode(dto.getCompanyCodeStart());
                        scpWhNetRelationDTO.setOuCode(dto.getCompanyCodeStart());
                        scpWhNetRelationDTO.setOuName(dto.getCompanyNameStart());
                        scpWhNetRelationDTO.setCustCode(dto.getCustCodeEnd());
                    }
                }
            } else {
                InvWhRpcDTO demandWhDto = demandWhMap.get(importEntity.getDemandWhStCode());
                if (demandWhDto == null) {
                    errorMap.get(importEntity.getLineNo()).add("需求仓库编码/门店编码" + importEntity.getDemandWhStCode() + " 不存在");
                } else {
                    scpWhNetRelationDTO.setDemandWhStId(demandWhDto.getId());
                    scpWhNetRelationDTO.setDemandWhStCode(importEntity.getDemandWhStCode());
                    scpWhNetRelationDTO.setDemandWhStName(demandWhDto.getWhName());
                }
                if (demandWhDto != null && supplyWhRpcDTO != null && !Objects.equals(demandWhDto.getOuId(), supplyWhRpcDTO.getOuId())) {
                    SupportTransactionPathRpcParam pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(supplyWhRpcDTO.getOuId());
                    pathRpcParam.setCompanyIdEnd(demandWhDto.getOuId());
                    SupportTransactionPathRpcDTO data = supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("查询启用状态的结算路径结束,返回:{}", JSONObject.toJSONString(data));
                    if (data == null || StrUtil.isBlank(data.getPathCode())) {
                        log.info("从公司 {}到公司 {}的结算路径不存在，请维护", supplyWhRpcDTO.getOuId(), demandWhDto.getOuId());
                        errorMap.get(importEntity.getLineNo()).add("从公司:" + supplyWhRpcDTO.getOuCode() + "到公司:" + demandWhDto.getOuCode() + "的结算路径不存在，请维护");
                    }
                    if (data != null) {
                        var detailList = data.getDetailList();
                        int size = detailList.size();
                        SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
                        scpWhNetRelationDTO.setCustCode(dto.getCompanyCodeStart());
                        scpWhNetRelationDTO.setOuCode(dto.getCompanyCodeStart());
                        scpWhNetRelationDTO.setOuName(dto.getCompanyNameStart());
                        scpWhNetRelationDTO.setCustCode(dto.getCustCodeEnd());
                    }
                }
            }

            // 采购公司校验
            if (StringUtils.isNotEmpty(importEntity.getPurOuCode())) {
                OrgOuRpcSimpleDTO ouDTO = ouMap.get(importEntity.getPurOuCode());
                if (ouDTO == null) {
                    errorMap.get(importEntity.getLineNo()).add("采购公司" + importEntity.getPurOuCode() + " 不存在");
                } else {
                    scpWhNetRelationDTO.setPurCompanyCode(importEntity.getPurOuCode());
                    scpWhNetRelationDTO.setPurCompanyName(ouDTO.getOuName());
                }
            } else {
                if (ScpConstant.PUR_TRN_DELIVERY_TYPES.contains(importEntity.getDeliveryType())) {
                    errorMap.get(importEntity.getLineNo()).add("采购公司不能为空");
                }
            }

            // 销售公司校验
            if (StringUtils.isNotEmpty(importEntity.getSaleOuCode())) {
                OrgOuRpcSimpleDTO ouDTO = ouMap.get(importEntity.getSaleOuCode());
                if (ouDTO == null) {
                    errorMap.get(importEntity.getLineNo()).add("销售公司" + importEntity.getSaleOuCode() + " 不存在");
                } else {
                    scpWhNetRelationDTO.setOuCode(importEntity.getSaleOuCode());
                    scpWhNetRelationDTO.setOuName(ouDTO.getOuName());
                }
            }

            // 商品校验
            if (StringUtils.isNotEmpty(importEntity.getItemCode())) {
                ItmItemRpcDTO itmItemRpcDTO = itemMap.get(importEntity.getItemCode());
                if (itmItemRpcDTO == null) {
                    errorMap.get(importEntity.getLineNo()).add("商品编码" + importEntity.getItemCode() + " 不存在");
                } else {
                    scpWhNetRelationDTO.setItemCode(importEntity.getItemCode());
                    scpWhNetRelationDTO.setItemId(itmItemRpcDTO.getId());
                    scpWhNetRelationDTO.setItemName(itmItemRpcDTO.getItemName());
                }
            }
            scpWhNetRelationDTO.setSupplyPercentage(new BigDecimal("100"));
            scpWhNetRelationDTO.setStatus(Boolean.TRUE);
//            scpWhNetRelationDTO.setEs1(importEntity.getImportBillNum());
            scpWhNetRelationDTO.setLineNo(importEntity.getLineNo());
            scpWhNetRelationDTO.setDeliveryType(importEntity.getDeliveryType());
            scpWhNetRelationDTO.setStartTime(importEntity.getStartTime());
            scpWhNetRelationDTO.setEndTime(importEntity.getEndTime());
            scpWhNetRelationDTOS.add(scpWhNetRelationDTO);
        }

        for (Integer line : errorMap.keySet()) {
            if (errorMap.get(line).isEmpty()) {
                continue;
            }
            if (Objects.equals(errorList.get(line - 1), "-")) {
                errorList.set(line - 1, String.join(",", errorMap.get(line)));
            } else {
                errorList.set(line - 1, errorList.get(line - 1) + String.join(",", errorMap.get(line)));
            }
        }
        successDocGroup = getSuccessDocGroup(errorList, dataList);
        List<ScpWhNetRelationDTO> ddos = new ArrayList<>();
        if (!successDocGroup.isEmpty()) {
            for (ScpWhNetRelationDTO scpWhNetRelationDTO : scpWhNetRelationDTOS) {
                if (successDocGroup.contains(scpWhNetRelationDTO.getLineNo())) {
                    ddos.add(scpWhNetRelationDTO);
                }
            }

            // 如果数据库里的数据deliveryType，supplyWhCode，itemCode和ddos里的数据相同，则进行数据更新，否则新建数据
            List<ScpWhNetRelationDO> oldList = scpWhNetRelationDomainService.findByConcatKey(ddos.stream().map(ScpWhNetRelationDTO::getConcatKey).collect(Collectors.toSet()));
            // oldList 转换成一个map ，key为concatKey，value为ScpWhNetRelationDO
            Map<String, ScpWhNetRelationDO> oldMap = oldList.stream()
                    .collect(Collectors.toMap(v -> setEmptyStringStr(v.getDemandWhStName())
                                    + setEmptyStringStr(v.getDeliveryType())
                                    + setEmptyStringStr(v.getItemCateCode())
                                    + setEmptyStringStr(v.getItemCode())
                            , Function.identity(), (t1, t2) -> t1));

            // 如果ddos里的元素的ConcatKey在updateMap里能取到值，则填个元素放到数据更新列表，否则放到新建列表
            List<ScpWhNetRelationDO> saveList = new ArrayList<>();
            for (ScpWhNetRelationDTO ddo : ddos) {
                ScpWhNetRelationDO old = oldMap.get(ddo.getConcatKey());
                if (old != null) {
                    // 把ddo的数据复制到 old上
                    old.setSupplyWhId(ddo.getSupplyWhId());
                    old.setSupplyWhCode(ddo.getSupplyWhCode());
                    old.setSupplyWhName(ddo.getSupplyWhName());
                    old.setType(ddo.getType());
                    old.setDemandWhStId(ddo.getDemandWhStId());
                    old.setDemandWhStCode(ddo.getDemandWhStCode());
                    old.setDemandWhStName(ddo.getDemandWhStName());
                    old.setItemId(ddo.getItemId());
                    old.setItemCode(ddo.getItemCode());
                    old.setItemName(ddo.getItemName());
                    old.setSupplyPercentage(ddo.getSupplyPercentage());
                    old.setStartTime(ddo.getStartTime());
                    old.setEndTime(ddo.getEndTime());
                    old.setStatus(ddo.getStatus());
                    old.setOuCode(ddo.getOuCode());
                    old.setOuName(ddo.getOuName());
                    old.setDeliveryType(ddo.getDeliveryType());
                    old.setPurCompanyCode(ddo.getPurCompanyCode());
                    old.setPurCompanyName(ddo.getPurCompanyName());
                } else {
                    ScpWhNetRelationDO scpWhNetRelationDO = ScpWhNetRelationConvert.INSTANCE.dtoToDo(ddo);
                    saveList.add(scpWhNetRelationDO);
                }
            }

            if (CollUtil.isNotEmpty(saveList)) {
                scpWhNetRelationRepo.saveAll(saveList);
            }
        }
        List<String> newResult = new ArrayList<>();
        for (int i = 0; i < errorList.size(); i++) {
            String error = errorList.get(i);
            Integer importDocGroup = dataList.get(i).getLineNo();
            if (!successDocGroup.contains(importDocGroup)) {
                if (Objects.equals(error, "-")) {
                    newResult.add("-");
                } else {
                    newResult.add(error);
                }
            } else {
                newResult.add(null);
            }
        }
        return newResult;
    }

    @Override
    public PagingVO<ScpWhNetRelationPageVO> scpmanAuthorityPage(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = getAuthorityPageRespVOPagingVO();
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return new PagingVO<>();
        }
        extractedAuthorityParam(queryParam, scpManAuthorityPageRespVOPagingVO);
        return page(queryParam);
    }

    @Override
    public Map<String, List<ScpWhNetRelationRpcDTO>> findWhNetByParam(String demandWhStCode, String type, List<ScpStoreCartDO> storeCartDOS) {
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap = new HashMap<>();
        // 查询仓网关系
        ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam = new ScpWhNetRelationRpcDtoParam();
        scpWhNetRelationRpcDtoParam.setType(type);
        scpWhNetRelationRpcDtoParam.setDemandWhStCode(demandWhStCode);
        scpWhNetRelationRpcDtoParam.setValidDate(LocalDateTime.now());
        List<ScpWhNetRelationRpcDTO> relationList = scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(scpWhNetRelationRpcDtoParam);
        // 匹配商品仓库关系
        for (ScpStoreCartDO cartDO : storeCartDOS) {
            List<ScpWhNetRelationRpcDTO> itemCodeResults = relationList.stream().filter(row -> Objects.equals(cartDO.getItemCode(), row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCodeResults)) {
                whNetRelationMap.put(cartDO.getItemCode(), itemCodeResults);
                continue;
            }
            List<ScpWhNetRelationRpcDTO> itemCateCodeResults = relationList.stream().filter(row -> Objects.equals(cartDO.getItemCateCode(), row.getItemCateCode()) && StrUtil.isBlank(row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCateCodeResults)) {
                whNetRelationMap.put(cartDO.getItemCode(), itemCateCodeResults);
                continue;
            }
            List<ScpWhNetRelationRpcDTO> deliveryTypeResult = relationList.stream().filter(row -> StrUtil.isBlank(row.getItemCateCode()) && StrUtil.isBlank(row.getItemCode()) && Objects.equals(cartDO.getDeliveryType(), row.getDeliveryType())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(deliveryTypeResult)) {
                whNetRelationMap.put(cartDO.getItemCode(), deliveryTypeResult);
                continue;
            }
//            List<ScpWhNetRelationRpcDTO> resultList = relationList.stream().filter(row -> StrUtil.isBlank(row.getItemCateCode()) && StringUtils.isBlank(row.getItemCode())).collect(Collectors.toList());
//            if (CollUtil.isEmpty(resultList)) {
//                continue;
//            }
//            whNetRelationMap.put(cartDO.getItemCode(), resultList);
        }
        return whNetRelationMap;
    }

    @Override
    public Map<String, List<ScpWhNetRelationRpcDTO>> findNewWhNetByParam(String demandWhStCode, String type, List<ScpStoreCartDO> storeCartDOS) {
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap = new HashMap<>();
        // 查询仓网关系
        ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam = new ScpWhNetRelationRpcDtoParam();
        scpWhNetRelationRpcDtoParam.setType(type);
        scpWhNetRelationRpcDtoParam.setDemandWhStCode(demandWhStCode);
        scpWhNetRelationRpcDtoParam.setValidDate(LocalDateTime.now());
        List<ScpWhNetRelationRpcDTO> relationList = scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(scpWhNetRelationRpcDtoParam);

        log.info("仓网关系relationList:{}", relationList);
        // 匹配商品仓库关系
        for (ScpStoreCartDO cartDO : storeCartDOS) {
            List<ScpWhNetRelationRpcDTO> itemCodeResults = relationList.stream().filter(row -> cartDO.getItemCode()
                    .equals(row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCodeResults)) {
                // 目前仓网都是100%,所以默认取第一条
                if (itemCodeResults.size() > 1) {
                    itemCodeResults = itemCodeResults.subList(0, 1);
                }
                whNetRelationMap.put(cartDO.getItemCode(), itemCodeResults);
                continue;
            }
            List<ScpWhNetRelationRpcDTO> resultList = relationList.stream()
                    .filter(row -> StringUtils.isBlank(row.getItemCode()) && Objects.equals(cartDO.getItemType2(), row.getDeliveryType()))
                    .collect(Collectors.toList());
            if (CollUtil.isNotEmpty(resultList)) {
                // 目前仓网都是100%,所以默认取第一条
                if (resultList.size() > 1) {
                    resultList = resultList.subList(0, 1);
                }
                whNetRelationMap.put(cartDO.getItemCode(), resultList);
            }
        }
        return whNetRelationMap;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchDelete(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return;
        }
        scpWhNetRelationDomainService.deleteBatch(ids);
    }

    @Override
    public List<String> findSaleOuInfo(String storeCode) {
        return scpWhNetRelationRepoProc.findSaleOuInfo(storeCode);

    }

    @Override
    public List<ScpWhNetRelationRespVO> findValidWhNetRelationByParam(List<Long>itemIds, String storeCode, LocalDateTime dateTime) {
        return scpWhNetRelationRepoProc.findValidWhNetRelationByParam(itemIds, storeCode, dateTime);
    }

    @Override
    public List<ScpWhNetRelationRespVO> findValidWhNetRelationByParam2(String itemType, String storeCode, LocalDateTime dateTime) {
        return scpWhNetRelationRepoProc.findValidWhNetRelationByParam2(itemType,storeCode,dateTime);
    }

    @Override
    public List<ScpWhNetRelationRpcDTO> outFindWhNetRelationRpcDtoByParam(ScpWhNetRelationParam whNetRelationParam) {

        log.info("outFindWhNetRelationRpcDtoByParam:{} ", JSON.toJSONString(whNetRelationParam));
        List<ScpWhNetRelationRpcDTO> relationRpcDTOS = scpWhNetRelationRepoProc.outFindWhNetRelationRpcDtoByParam(whNetRelationParam);
        if (CollUtil.isEmpty(relationRpcDTOS)) {
            return new ArrayList<>();
        }
        return relationRpcDTOS;
    }


    private void extractedAuthorityParam(ScpWhNetRelationPageParamVO queryParam, PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO) {
        List<ScpManAuthorityPageRespVO> records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List<Long> whIds = records.stream()
                .filter(v -> 1 == v.getType())
                .map(ScpManAuthorityPageRespVO::getStWhId)
                .filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> storeIds = records.stream()
                .filter(v -> 0 == v.getType())
                .map(ScpManAuthorityPageRespVO::getStWhId)
                .filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhIds(whIds);
        queryParam.setStoreIds(storeIds);
    }

    private PagingVO<ScpManAuthorityPageRespVO> getAuthorityPageRespVOPagingVO() {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUserDTO)) {
            throw new BusinessException("当前登录人查询异常");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setTypes(List.of(1, 0));
        scpManAuthorityParam.setEnableStatus(Boolean.TRUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        return scpManAuthorityPageRespVOPagingVO;
    }

    private List<String> validResult(List<String> errorList) {
        errorList.replaceAll(new UnaryOperator<String>() {
            @Override
            public String apply(String s) {
                if (StringUtils.isEmpty(s)) {
                    return "-";
                }
                return s;
            }
        });
        return errorList;
    }

    private List<Integer> getSuccessDocGroup(List<String> errorList, List<ScpWhNetRelationImportVO> dataList) {
        List<Integer> docGroupNo = dataList.stream()
                .map(ScpWhNetRelationImportVO::getLineNo)
                .distinct().collect(Collectors.toList());
        for (int i = 0; i < dataList.size(); i++) {
            ScpWhNetRelationImportVO entity = dataList.get(i);
            if (!Objects.equals("-", errorList.get(i))) {
                docGroupNo.remove(entity.getLineNo());
            }
        }
        return docGroupNo;
    }


    //校验入参
    private void checkImportParam(List<ScpWhNetRelationImportVO> dataList, List<String> errorList) {
        Map<Integer, List<String>> errorMap = new HashMap<>();
        Map<String, String> typeMap = MapUtil.reverse(systemService.getValueMapByUdcCode("yst-suplan", "DEMAND_SET_TYPE"));
        Map<String, String> deliveryTypeMap = MapUtil.reverse(systemService.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2"));
        Map<String, Integer> dumpMap = new HashMap<>();
        for (int i = 0; i < dataList.size(); i++) {
            ScpWhNetRelationImportVO importEntity = dataList.get(i);
            int line = i + 1;
            importEntity.setLineNo(line);
            errorMap.put(importEntity.getLineNo(), new ArrayList<>());
            if (StringUtils.isEmpty(importEntity.getTypeName())) {
                errorMap.get(line).add("列[类型]不能为空");
            } else {
                String lineType = typeMap.get(importEntity.getTypeName());
                if (StringUtils.isEmpty(lineType)) {
                    errorMap.get(importEntity.getLineNo()).add("列[类型名]" + importEntity.getTypeName() + " 不存在");
                } else {
                    importEntity.setType(lineType);
                }
            }

            //配送类型
            if (StringUtils.isEmpty(importEntity.getDeliveryTypeName())) {
                errorMap.get(line).add("列[配送类型]不能为空");
            } else {
                String code = deliveryTypeMap.get(importEntity.getDeliveryTypeName());
                if (StringUtils.isEmpty(code)) {
                    errorMap.get(importEntity.getLineNo()).add("列[配送类型]" + importEntity.getDeliveryTypeName() + " 不存在");
                } else {
                    importEntity.setDeliveryType(code);
                }
            }

//            if (StringUtils.isEmpty(importEntity.getDeliveryTypeName())) {
//                errorMap.get(line).add("列[配送类型]不能为空");
//            }
            if (StringUtils.isEmpty(importEntity.getDemandWhStCode())) {
                errorMap.get(line).add("列[需求仓库/门店编码]不能为空");
            }
            if (StringUtils.isEmpty(importEntity.getSupplyWhCode())) {
                errorMap.get(line).add("列[供应仓库编码]不能为空");
            }


            // 有效期
            if (StringUtils.isEmpty(importEntity.getStartTimeStr())) {
                errorMap.get(line).add("列[有效日期从]不能为空");
            }
            if (StringUtils.isEmpty(importEntity.getEndTimeStr())) {
                errorMap.get(line).add("列[有效日期至]不能为空");
            }

            if (StringUtils.isNotEmpty(importEntity.getStartTimeStr()) && StringUtils.isNotEmpty(importEntity.getEndTimeStr())) {
                LocalDateTime startTime = null;
                try {
                    LocalDate date = LocalDate.parse(importEntity.getStartTimeStr());
                    startTime = date.atStartOfDay();
                } catch (Exception e) {
                    errorMap.get(line).add("列[有效日期至]格式错误");
                }
                LocalDateTime endTime = null;
                if (importEntity.getEndTimeStr().equals("长期有效")) {
                    //endTime 设置为 9999-12-31 23:59:59
                    endTime = LocalDateTime.of(9999, 12, 31, 23, 59, 59);
                } else {
                    try {
                        LocalDate date = LocalDate.parse(importEntity.getEndTimeStr());
                        // 获取date的一天的结束时间
                        endTime = date.atTime(23, 59, 59);
                    } catch (Exception e) {
                        errorMap.get(line).add("列[有效日期至]格式错误");
                    }
                }

                if (startTime != null && endTime != null) {
                    if (startTime.isAfter(endTime)) {
                        errorMap.get(line).add("列[有效日期从]不能大于[有效日期至]");
                    } else {
                        importEntity.setStartTime(startTime);
                        importEntity.setEndTime(endTime);
                    }
                }
            }

            if (StringUtils.isNotEmpty(importEntity.getDemandWhStCode()) && StringUtils.isNotEmpty(importEntity.getDeliveryType())) {
                String key = importEntity.getDeliveryType() + importEntity.getDemandWhStCode() + setEmptyStringStr(importEntity.getItemCode());
                if (dumpMap.get(key) == null) {
                    dumpMap.put(key, line);
                } else {
                    errorMap.get(line).add("第 " + importEntity.getLineNo() + "行，数据重复，配送类型-门店编码-商品 存在相同组合数据，请检查");
                }
            }
        }
        for (Integer line : errorMap.keySet()) {
            errorList.add(String.join(",", errorMap.get(line)));
        }
    }


}
