package com.elitesland.scp.application.service.mrp;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseVO;

import java.util.List;

/**
* @description:  
* @author: wangly
* @create: 2025-03-28
* @Version 1.0
**/
public interface ScpThousandUseService {
    /**
     * 分页列表
     *
     * @param param 条件
     * @return {@link PagingVO}<{@link ScpThousandUseVO}>
     */
    PagingVO<ScpThousandUseVO> queryPaging(ScpThousandUseParam param);

    /**
     * 查询列表
     *
     * @param param 条件参数
     * @return {@link List}<{@link ScpThousandUseVO}>
     */
    List<ScpThousandUseVO> queryListDynamic(ScpThousandUseParam param);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ScpThousandUseVO}
     */
    ScpThousandUseVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param param 单据数据
     * @return {@link ScpThousandUseVO}
     */
    Long save(ScpThousandUseParam param);

    /**
     * 修改
     *
     * @param param 单据数据
     * @return {@link ScpThousandUseVO}
     */
    ScpThousandUseVO update(ScpThousandUseParam param);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param param 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ScpThousandUseParam param);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 计算
     *
     */
    void count();

    /**
     * 数据校验
     *
     */
    void checkData(ScpThousandUseParam param);
}