package com.elitesland.scp.application.service.stock;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 01月 17日 09:59
 * @version: 1.0
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ScpSafetyTargetStockExportServiceImpl implements DataExport<ScpSafetyTargetStockPageVO, ScpSafetyTargetStockPageParam> {

    private final ScpSafetyTargetStockService scpSafetyTargetStockService;
    @Override
    public String getTmplCode() {
        return "safety_target_stock";
    }

    @Override
    public PagingVO<ScpSafetyTargetStockPageVO> executeExport(ScpSafetyTargetStockPageParam queryParamVO) {
        return scpSafetyTargetStockService.searchPage(queryParamVO);
    }





}
