package com.elitesland.scp.application.web.item;

import com.alibaba.excel.EasyExcel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.item.*;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.utils.excel.ExcelEntityDataListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Slf4j
@Api(tags = "中台-报货商品操作")
@RestController
@RequestMapping(value = "/cate/item/operate", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class CateItemOperationController {

    private final ScpCateItemService scpCateItemService;

    @ApiOperation("报货商品 - 设置可售范围")
    @PostMapping("/setSaleScope")
    public ApiResult<?> setSaleScope(@RequestBody @Validated ScpCateItemOperationParam param) {
        try {
            scpCateItemService.setSaleScope(param);
            return ApiResult.ok();
        } catch (Exception e) {
            log.error("设置可售范围异常:{}", e.getMessage(), e);
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation("报货商品 - 删除可售范围")
    @PostMapping("/deleteSaleScope")
    public ApiResult<?> deleteSaleScope(@RequestBody @Validated ScpCateItemOperationAddParam param) {
        try {
            scpCateItemService.deleteSaleScope(param);
            return ApiResult.ok();
        } catch (Exception e) {
            log.error("删除可售范围异常:{}", e.getMessage(), e);
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation("报货商品 - 增加可售范围")
    @PostMapping("/addSaleScope")
    public ApiResult<?> addSaleScope(@RequestBody @Validated ScpCateItemOperationAddParam param) {
        try {
            scpCateItemService.addSaleScope(param);
            return ApiResult.ok();
        } catch (Exception e) {
            log.error("增加可售范围异常:{}", e.getMessage(), e);
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation("报货商品 - 查看可售范围门店")
    @GetMapping("/getSaleScope/{id}")
    public ApiResult<ScpCateItemOperationVO> getSaleScope(@PathVariable Long id) {
        ScpCateItemOperationVO saleScope = scpCateItemService.getSaleScope(id);
        return ApiResult.ok(saleScope);
    }

    @ApiOperation("报货商品 - 设置可见范围")
    @PostMapping("/setVisibleScope")
    public ApiResult<?> setVisibleScope(@RequestBody @Validated ScpCateItemOperationVisibleParam param) {
        try {
            scpCateItemService.setVisibleScope(param);
            return ApiResult.ok();
        } catch (Exception e) {
            log.error("设置可见范围异常:{}", e.getMessage(), e);
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation("报货商品 - 查看可见范围门店")
    @GetMapping("/getVisibleScope/{id}")
    public ApiResult<ScpCateItemOperationVO> getVisibleScope(@PathVariable Long id) {
        ScpCateItemOperationVO saleScope = scpCateItemService.getVisibleScope(id);
        return ApiResult.ok(saleScope);
    }

    @ApiOperation("报货商品 - 修改预售状态")
    @PostMapping("/setPreSaleStatus")
    public ApiResult<String> setPreSaleStatus(@RequestBody @Validated ScpCateItemPreSaleParam param) {
        return scpCateItemService.setPreSaleStatus(param);
    }

    @ApiOperation("报货商品 - 修改上下架状态")
    @PostMapping("/setUpDownStatus")
    public ApiResult<String> setUpDownStatus(@RequestBody @Validated ScpCateItemPreSaleParam param) {
        return scpCateItemService.setUpDownStatus(param);
    }

    @PostMapping("/importSaleScope")
    @ApiOperation("商品可售范围-导入明细")
    public ApiResult<Object> importDetail(ScpItemSaleScopeImportParam param){
        ExcelEntityDataListener<ScpItemSaleScopeStoreImportVO> dataListener = new ExcelEntityDataListener<>();
        try {
            EasyExcel.read(param.getFile().getInputStream(), ScpItemSaleScopeStoreImportVO.class, dataListener).doReadAll();
        }catch (Exception e){
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        List<ScpItemSaleScopeStoreImportVO> list = dataListener.getDatas();
        return scpCateItemService.importSaleScope(list,param);
    }

    @PostMapping("/importVisibleScope")
    @ApiOperation("商品可见范围-导入明细")
    public ApiResult<Object> importVisibleScope(ScpItemVisibleScopeImportParam param) {
        ExcelEntityDataListener<ScpItemSaleScopeStoreImportVO> dataListener = new ExcelEntityDataListener<>();
        try {
            EasyExcel.read(param.getFile().getInputStream(), ScpItemSaleScopeStoreImportVO.class, dataListener).doReadAll();
        } catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        List<ScpItemSaleScopeStoreImportVO> list = dataListener.getDatas();
        return scpCateItemService.importVisibleScope(list, param);
    }
}
