package com.elitesland.scp.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Data
@Component
@ConfigurationProperties(prefix = "wechat", ignoreInvalidFields = true)
public class WechatProperties {

    public static final String CONFIG_PREFIX = "wechat";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 企业id
     */
    private String corpId;

    /**
     * 重定向的回调链接地址
     */
    private String redirectUrl;

    /**
     * 小程序应用密钥
     */
    private String mgCorpsecret;

    /**
     * 企业微信获取token的url
     */
    private String providerTokenUrl;

    /**
     * 企业微信agent-id
     */
    private String agentId;

    /**
     * sso登录类型，ServiceApp：服务商登录；CorpApp：企业自建/代开发应用登录
     */
    private String loginType;

    /**
     * h5应用密钥
     */
    private String h5Corpsecret;
}
