package com.elitesland.scp.domain.entity.wqf;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;
/**
* @description: 微企付商户账户申请
* @author: jeesie.jiang
* @create: 2025-02-27
* @Version 1.0
**/
@Entity
@Table(name = "scp_wqf_ent_account_apply")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "scp_wqf_ent_account_apply", comment = "微企付商户账户申请")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "scp_wqf_ent_account_apply", description = "微企付商户账户申请")
public class ScpWqfEntAccountApplyDO extends BaseModel implements Serializable {

    @Column(name = "doc_no", columnDefinition = "varchar(40)")
    @Comment("申请单号")
    private String docNo;

    @Column(name = "ou_code", columnDefinition = "varchar(40)")
    @Comment("公司编码")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint")
    @Comment("公司ID")
    private Long ouId;

    @Column(name = "ent_id", columnDefinition = "varchar(64)")
    @Comment("公司商户号")
    private String entId;

    @Column(name = "apply_status", columnDefinition = "varchar(32)")
    @Comment("申请状态")
    private String applyStatus;


    @Column(name = "error_msg", columnDefinition = "varchar(1000)")
    @Comment("失败原因")
    private String errorMsg;


}