package com.elitesland.scp.domain.service.minOrder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingSaveVO;
import com.elitesland.scp.infr.dto.minOrder.ScpMinOrderSettingDTO;

import java.util.List;
import java.util.Optional;

public interface ScpMinOrderSettingDomainService {

    /**
     * 订货强配活动查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpMinOrderSettingPageRespVO> queryMinOrderSettingList(ScpMinOrderSettingPageParamVO paramVO);

    /**
     * 订货强配活动详情查询
     *
     * @param id
     * @return
     */
    Optional<ScpMinOrderSettingDTO> findMinOrderSettingById(Long id);

    /**
     * 订货强配活动配置保存
     *
     * @param saveVO 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    Long saveMinOrderSetting(ScpMinOrderSettingSaveVO saveVO);

    /**
     * 订货强配活动状态变更
     *
     * @param ids    单据类型配置的ID列表
     * @param enable 单据类型配置的状态，true表示启用，false表示禁用
     */
    void enableMinOrderSetting(List<Long> ids, Boolean enable);

    /**
     * 删除订货强配活动
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);
}
