package com.elitesland.scp.infr.repo.order;

import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

public interface ScpDemandOrderDRepo extends JpaRepository<ScpDemandOrderDDO, Long>,
        QuerydslPredicateExecutor<ScpDemandOrderDDO> {

    List<ScpDemandOrderDDO> findByIdIn(Collection<Long> ids);

    List<ScpDemandOrderDDO> findByMasId(Long id);

    List<ScpDemandOrderDDO> findByMasIdAndProjectFeeFlag(Long id, Boolean projectFeeFlag);

    List<ScpDemandOrderDDO> findByMasIdAndSpuItemCodeIn(Long masId, List<String> spuCodes);

    Page<ScpDemandOrderDDO> findByMasId(Long masId, Pageable pageable);

    Page<ScpDemandOrderDDO> findByMasIdAndProjectFeeFlag(Long id, Boolean projectFeeFlag, Pageable pageable);

    List<ScpDemandOrderDDO> findByMasIdAndStatusNotAndProjectFeeFlag(Long masId, String status, Boolean projectFeeFlag);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set plan_quantity = allocation_de_quantity,is_calculated = true where " +
            "mas_id in (select id from scp_demand_order where demand_id = ?1) and ou_code is not null and " +
            "is_calculated = false", nativeQuery = true)
    void updateSuppAllocPlanQty(Long demandSetId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set is_pushed = true, modify_time = CURRENT_TIMESTAMP, sync_msg = :msg  where id in (:ids) and " +
            "delete_flag != 1", nativeQuery = true)
    void updateIsPushed(@Param("ids") List<Long> ids, @Param("msg") String msg);

    @Modifying()
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set sync_msg = ?2, modify_time = CURRENT_TIMESTAMP where id in ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void updateSyncMsg(List<Long> ids, String msg);

    List<ScpDemandOrderDDO> findByMasIdIn(List<Long> ids);

    List<ScpDemandOrderDDO> findByMasIdAndIsPushed(Long masId, Boolean isPushed);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_demand_order_d where mas_id = ?1 and is_pushed = ?2", nativeQuery = true)
    void deleteByMasIdAndIsPushed(Long masId, Boolean isPushed);


    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set pay_status = ?2, modify_time = CURRENT_TIMESTAMP where id in ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void updatePayStatus(List<Long> ids, String payStatus);


    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set quantity = quantity + ?2, modify_time = CURRENT_TIMESTAMP where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void updateQtyById(Long id, BigDecimal qty);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set recv_qty = recv_qty + ?2, modify_time = CURRENT_TIMESTAMP where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void updateRecvQtyById(Long id, BigDecimal recvQty);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set return_qty =  return_qty + ?2, modify_time = CURRENT_TIMESTAMP where id = ?1 and delete_flag != 1", nativeQuery = true)
    void updateReturnQtyById(Long id, BigDecimal returnQty);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set compensate_qty = compensate_qty + ?2, modify_time = CURRENT_TIMESTAMP where id = ?1 and delete_flag != 1", nativeQuery = true)
    void updateCompensateQtyById(Long id, BigDecimal compensateQty);


    List<ScpDemandOrderDDO> findBySrcDocId(Long id);

    List<ScpDemandOrderDDO> findBySrcDocIdAndProjectFeeFlag(Long srcDocId, Boolean projectFeeFlag);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_demand_order_d where mas_id = ?1 and project_fee_flag = ?2", nativeQuery = true)
    void deleteByMasIdAndProjectFeeFlag(Long masId, Boolean projectFeeFlag);


//    @Modifying(clearAutomatically = true)
//    @Transactional(rollbackFor = Exception.class)
//    @Query(value = "update scp_demand_order_d set allocation_quantity = 0, is_pushed = false,src_doc_id = null,src_doc_cls= null,src_doc_no= null,src_doc_line_no = null,pay_status = ?2 ,modify_time = CURRENT_TIMESTAMP where id in ?1 and " +
//            "delete_flag != 1", nativeQuery = true)
//    void cancelOrderByDIds(List<Long> dIds, String payStatus);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set status = ?2 ,modify_time = CURRENT_TIMESTAMP where id in ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void cancelOrderByDIds(List<Long> dIds, String status);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set is_pushed = true,src_doc_id = ?1, src_doc_cls= 'STKTRO',src_doc_no= ?2, allocation_quantity = plan_quantity, src_doc_line_no = ?4,modify_time = CURRENT_TIMESTAMP where id = ?3 and " +
            "delete_flag != 1", nativeQuery = true)
    void updateSrcDocInfoByIds(Long srcDocId, String srcDocNo, Long dId, Integer srcDocLineNo);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set quantity =quantity - ?2,modify_time = CURRENT_TIMESTAMP where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void resetSrcDocQuantity(Long id,BigDecimal qty);


    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set compensate_qty = compensate_qty + ?1 where mas_id = ?2 and item_id = ?3 ", nativeQuery = true)
    @Modifying(clearAutomatically = true)
    void updateCompensateQtyByMasIdAndSrcDocIdAndItemId(BigDecimal compensateQty, Long masId, Long itemId);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order_d set return_qty = return_qty + ?1 where mas_id = ?2 and item_id = ?3 ", nativeQuery = true)
    @Modifying(clearAutomatically = true)
    void updateReturnQtyByMasIdAndSrcDocIdAndItemId(BigDecimal compensateQty, Long masId, Long itemId);
}
