package com.elitesland.scp.infr.repo.purLimit;

import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingStoreDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

public interface ScpPurLimitSettingStoreRepo extends JpaRepository<ScpPurLimitSettingStoreDO, Long>, QuerydslPredicateExecutor<ScpPurLimitSettingStoreDO> {

    Optional<ScpPurLimitSettingStoreDO> findById(Long id);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_pur_limit_setting_store where mas_id = ?1 ", nativeQuery = true)
    void deleteByMasId(Long masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_pur_limit_setting_store where id in ?1 ", nativeQuery = true)
    void deleteByIds(List<Long> ids);

    @Modifying()
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_pur_limit_setting_store set active_num = active_num + 1 where mas_id in ?1 and store_code = ?2", nativeQuery = true)
    void updateActiveNumByParam(List<Long> masIds, String storeCode);

    List<ScpPurLimitSettingStoreDO> findByMasId(Long masId);

    List<ScpPurLimitSettingStoreDO> findAllByStoreCodeIn(List<String> storeCodes);
}
