package com.elitesland.scp.pay.config;


import cn.hutool.json.JSONUtil;
import com.elitesland.scp.common.ScpConstant;
import com.tenpay.business.entpay.mse.sdk.config.EntpayConfig;
import com.tenpay.business.entpay.mse.sdk.enums.EnvironmentEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Slf4j
@Configuration
@ConditionalOnProperty(prefix = EntpayProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true")
@EnableConfigurationProperties(EntpayProperties.class)
public class EntpaySdkConfig implements InitializingBean {

    private final EntpayProperties properties;
    private final RedisTemplate redisTemplate;

    public EntpaySdkConfig(EntpayProperties properties, RedisTemplate redisTemplate) {
        log.info("EntpaySdkConfig：{}", JSONUtil.toJsonStr(properties));
        this.properties = properties;
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("begin init entpay config...");
        EntpayConfig.setNormalMode(properties.getPlatformId(),
                properties.getPlatformPrivateKey(),
                properties.getPlatformPrivateCertSerialNo(),
                properties.getTbepSerialNo(),
                properties.getTbepPublicKey());
        // 设置联调环境地址
        if ("PRO".equals(properties.getEnv())) {
            EntpayConfig.setEnv(EnvironmentEnum.PRO);
        } else {
            EntpayConfig.setEnv(EnvironmentEnum.SANDBOX);
        }
        //将微企付信息存入redis
        redisTemplate.opsForValue().set(ScpConstant.ENT_PAY_PROPERTIES, JSONUtil.toJsonStr(properties));
        //三个默认都是10秒
        //从连接管理器请求连接时使用的超时（以毫秒为单位）
        EntpayConfig.setConnectionRequestTimeout(3000);
        //确定连接建立之前的超时时间（以毫秒为单位）
        EntpayConfig.setConnectTimeout(5000);
        //定义套接字超时（SO_TIMEOUT），以毫秒为单位，这是等待数据的超时。
        EntpayConfig.setSocketTimeout(15000);
        log.info("init entpay config done");
    }
}
