package com.elitesland.scp.rmi;

import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Component
@Log4j2
@RequiredArgsConstructor
public class RmiSysUserRpcService {

    private final SeqNumProvider seqNumProvider;

    public String sysNumberRuleGenerateCode(String code, List<String> runtimeValues) {
        log.info("系统域发号器调用：时间：{}，参数{},{}", LocalDateTime.now(), code, runtimeValues);
        List<String> list = new ArrayList<>();
        list.addAll(runtimeValues);
        try {
            return seqNumProvider.generateCode("yst-suplan", code, list);
        } catch (Exception e) {
            log.error("sysNumberRuleGenerateCode error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "发号器发号失败");
        }
    }

    public List<String> sysNumberRuleGenerateCode(String ruleCode, List<String> runtimeValues, Integer num) {
        List<String> codes = seqNumProvider.generateCode("yst-suplan", ruleCode, runtimeValues, num);
        if (CollectionUtils.isEmpty(codes)) {
            log.error("调用发号器异常,发号器编码未生成,规则:" + ruleCode);
            throw new BusinessException(ApiCode.FAIL, "调用发号器异常,发号器编码未生成,规则:" + ruleCode);
        }
        return codes;
    }
}
