/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.item;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import com.elitesland.scp.domain.entity.item.ScpCateItemSaleScopeRegionDO;
import com.elitesland.scp.domain.entity.item.ScpCateItemSaleScopeStoreDO;
import com.elitesland.scp.domain.service.item.ScpCateItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepo;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.item.ScpCateItemSaleScopeRegionRepo;
import com.elitesland.scp.infr.repo.item.ScpCateItemSaleScopeStoreRepo;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.param.ScpCateItemSaleScopeSaveRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.service.item.CateItemRpcService;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/cate/item"})
public class ScpCateItemDomainServiceImpl
implements ScpCateItemDomainService,
CateItemRpcService {
    private static final Logger log = LoggerFactory.getLogger(ScpCateItemDomainServiceImpl.class);
    private final ScpCateItemRepo scpCateItemRepo;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final RmiItemService rmiItemService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpCateItemSaleScopeStoreRepo scpCateItemSaleScopeStoreRepo;
    private final ScpCateItemSaleScopeRegionRepo scpCateItemSaleScopeRegionRepo;

    @Override
    public void saveBatch(List<ScpCateItemDO> scpCateItemDOS) {
        this.scpCateItemRepo.saveAll(scpCateItemDOS);
    }

    @Override
    public void delete(List<Long> ids) {
        this.scpCateItemRepo.deleteAllByIdInBatch(ids);
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> query(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(this.scpCateItemRepoProc.queryDto(cateItemRpcParam));
    }

    @Override
    public List<String> existByItemCodes(List<String> itemCodes) {
        return this.scpCateItemRepoProc.queryByItemCodes(itemCodes);
    }

    public ApiResult<List<String>> findItemCodesBy(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(this.scpCateItemRepoProc.queryItemCode(cateItemRpcParam));
    }

    public ApiResult<List<ScpCateItemDTO>> listByParam(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(this.scpCateItemRepoProc.queryDto(cateItemRpcParam));
    }

    public ApiResult<String> saveSaleScope(List<ScpCateItemSaleScopeSaveRpcParam> paramList) {
        log.info("\u4fdd\u5b58\u53ef\u552e\u8303\u56f4\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(paramList));
        for (ScpCateItemSaleScopeSaveRpcParam param : paramList) {
            List<Long> collect;
            List<ScpCateItemSaleScopeRegionDO> allByRegionCode = this.scpCateItemSaleScopeRegionRepo.findAllByRegionCode(param.getRegionCode());
            if (CollUtil.isEmpty(allByRegionCode)) {
                log.info("{}\u533a\u57df\u4e0d\u9700\u8981\u8bbe\u7f6e\u53ef\u552e\u8303\u56f4", (Object)param.getRegionCode());
                continue;
            }
            List<Long> masIdList = allByRegionCode.stream().map(ScpCateItemSaleScopeRegionDO::getMasId).distinct().toList();
            ArrayList<Long> newMasIdList = new ArrayList<Long>();
            List<ScpCateItemSaleScopeStoreDO> allByMasIdInAndStoreCode = this.scpCateItemSaleScopeStoreRepo.findAllByMasIdInAndStoreCode(masIdList, param.getStoreCode());
            if (CollUtil.isNotEmpty(allByMasIdInAndStoreCode)) {
                collect = allByMasIdInAndStoreCode.stream().map(ScpCateItemSaleScopeStoreDO::getMasId).distinct().toList();
                masIdList.forEach(masId -> {
                    if (!collect.contains(masId)) {
                        newMasIdList.add((Long)masId);
                    }
                });
            } else {
                newMasIdList.addAll(masIdList);
            }
            log.info("\u53ef\u552e\u8303\u56f4\u95e8\u5e97\u6dfb\u52a0\u5546\u54c1\u7684id\uff0cmasIdList:{}", newMasIdList);
            if (!CollUtil.isNotEmpty(newMasIdList)) continue;
            collect = new ArrayList<Long>();
            for (Long masId2 : newMasIdList) {
                ScpCateItemSaleScopeStoreDO scpCateItemSaleScopeStoreDO = new ScpCateItemSaleScopeStoreDO();
                scpCateItemSaleScopeStoreDO.setMasId(masId2);
                scpCateItemSaleScopeStoreDO.setStoreCode(param.getStoreCode());
                collect.add((Long)((Object)scpCateItemSaleScopeStoreDO));
            }
            if (!CollUtil.isNotEmpty(collect)) continue;
            this.scpCateItemSaleScopeStoreRepo.saveAll(collect);
        }
        return ApiResult.ok((Object)"\u8bbe\u7f6e\u6210\u529f");
    }

    @Override
    public void changeHotFlag(ScpCateItemHotParamVO paramVO) {
        this.scpCateItemRepoProc.changeHotFlag(paramVO);
    }

    @Override
    public PagingVO<ScpCateItemRespVO> page(ScpCateItemPageParamVO paramVO) {
        long count = this.scpCateItemRepoProc.countItem(paramVO);
        if (count > 0L) {
            List<ScpCateItemRespVO> itemList = this.scpCateItemRepoProc.queryItemList(paramVO);
            List<ScpOrderSettingRespVO> settingList = this.scpOrderSettingDomainService.findEnabledSetting();
            if (CollUtil.isEmpty(settingList)) {
                return new PagingVO(count, itemList);
            }
            Map<String, List<ScpOrderSettingRespVO>> settingMap = settingList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).collect(Collectors.groupingBy(row -> (String)StrUtil.split((CharSequence)row.getItemCate(), (CharSequence)",").get(0)));
            Map<Long, List<ItmItemScpBaseRpcDTO>> itemMap = this.getItemMap(itemList);
            itemList.forEach(row -> {
                if (itemMap.containsKey(row.getItemId())) {
                    Optional<ItmItemAttachmentRpcDTO> first;
                    ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)((List)itemMap.get(row.getItemId())).get(0);
                    row.setSpec(itmItemScpBaseRpcDTO.getSpec());
                    List spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
                    if (CollUtil.isNotEmpty((Collection)spuAttchmentList) && (first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst()).isPresent()) {
                        row.setUrl(first.get().getUrl());
                    }
                    row.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
                    row.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
                    row.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
                    row.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
                    row.setItemCateCode(itmItemScpBaseRpcDTO.getItemCateCode());
                    row.setUom(itmItemScpBaseRpcDTO.getUom2());
                    row.setItemTyp2(itmItemScpBaseRpcDTO.getItemType2());
                    List settingRespVOS = (List)settingMap.get(itmItemScpBaseRpcDTO.getItemType());
                    if (CollUtil.isEmpty((Collection)settingRespVOS)) {
                        return;
                    }
                    ScpOrderSettingRespVO setting = (ScpOrderSettingRespVO)settingRespVOS.get(0);
                    row.setDocType(setting.getDocType());
                }
            });
            Map<String, List<ScpCateItemRespVO>> businessTypeMap = itemList.stream().collect(Collectors.groupingBy(ScpCateItemRespVO::getBusinessType));
            HashMap allPriceMap = new HashMap();
            businessTypeMap.forEach((k, v) -> {
                ScpOrderSettingRespVO setting = this.scpOrderSettingDomainService.findCacheByBusinessType((String)k, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                List<AppItemActivityItemPriceParamVO> priceParamVOS = v.stream().map(row -> {
                    AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                    priceParamVO.setItemCode(row.getItemCode());
                    priceParamVO.setItemId(row.getItemId());
                    priceParamVO.setItemCateCode(row.getItemCateCode());
                    priceParamVO.setUom(row.getUom());
                    priceParamVO.setItemType2(row.getItemTyp2());
                    return priceParamVO;
                }).collect(Collectors.toList());
                Map<String, AppItemPriceRespVO> priceMap = this.commonPriceService.getNewPriceAndStockDetails(priceParamVOS, paramVO.getStoreCode(), setting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                allPriceMap.putAll(priceMap);
            });
            itemList.forEach(row -> {
                if (!allPriceMap.containsKey(row.getItemCode())) {
                    return;
                }
                row.setPrice(((AppItemPriceRespVO)allPriceMap.get(row.getItemCode())).getPrice());
            });
            return new PagingVO(count, itemList);
        }
        return new PagingVO();
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO paramVO) {
        long count = this.scpCateItemRepoProc.countItem(paramVO);
        if (count > 0L) {
            List<ScpCateItemPageVO> scpCateItemPageVOS = this.scpCateItemRepoProc.skuPage(paramVO);
            return new PagingVO(count, scpCateItemPageVOS);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSorNo(Long id, Integer sorNo) {
        this.scpCateItemRepoProc.updateSortNoById(sorNo, id);
    }

    private Map<Long, List<ItmItemScpBaseRpcDTO>> getItemMap(List<ScpCateItemRespVO> cateItemList) {
        List itemIds = cateItemList.stream().map(ScpCateItemRespVO::getItemId).collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List<ItmItemScpBaseRpcDTO> baseRpcDTOList = this.rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        if (CollUtil.isNotEmpty(baseRpcDTOList)) {
            return baseRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getId));
        }
        return new HashMap<Long, List<ItmItemScpBaseRpcDTO>>();
    }

    public ScpCateItemDomainServiceImpl(ScpCateItemRepo scpCateItemRepo, ScpCateItemRepoProc scpCateItemRepoProc, RmiItemService rmiItemService, CommonPriceService commonPriceService, ScpOrderSettingDomainService scpOrderSettingDomainService, ScpCateItemSaleScopeStoreRepo scpCateItemSaleScopeStoreRepo, ScpCateItemSaleScopeRegionRepo scpCateItemSaleScopeRegionRepo) {
        this.scpCateItemRepo = scpCateItemRepo;
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.rmiItemService = rmiItemService;
        this.commonPriceService = commonPriceService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.scpCateItemSaleScopeStoreRepo = scpCateItemSaleScopeStoreRepo;
        this.scpCateItemSaleScopeRegionRepo = scpCateItemSaleScopeRegionRepo;
    }
}

