/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.setting;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.setting.ScpOrderSettingSaveVO;
import com.elitesland.scp.domain.convert.setting.ScpOrderSettingConvert;
import com.elitesland.scp.domain.entity.setting.ScpOrderSettingDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.infr.dto.setting.ScpOrderSettingDTO;
import com.elitesland.scp.infr.repo.setting.ScpOrderSettingRepo;
import com.elitesland.scp.infr.repo.setting.ScpOrderSettingRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ScpOrderSettingDomainServiceImpl
implements ScpOrderSettingDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpOrderSettingDomainServiceImpl.class);
    private final RedisTemplate<String, Object> redisTemplate;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpOrderSettingRepo scpOrderSettingRepo;
    private final ScpOrderSettingRepoProc scpOrderSettingRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpOrderSettingPageRespVO> queryOrderSettingList(ScpOrderSettingPageParamVO paramVO) {
        long count = this.scpOrderSettingRepoProc.countOrderSetting(paramVO);
        if (count > 0L) {
            Map<String, String> itemType2 = this.rmiSysUDCService.getCodeMap("yst-supp", "ITEM_TYPE2");
            List<ScpOrderSettingPageRespVO> demandSet = this.scpOrderSettingRepoProc.queryOrderSetting(paramVO);
            demandSet.forEach(scpOrderSettingRespVO -> {
                String deliveryType;
                if (StrUtil.isNotBlank((CharSequence)scpOrderSettingRespVO.getItemCate())) {
                    List<String> itemCateName = StrUtil.split((CharSequence)scpOrderSettingRespVO.getItemCate(), (char)',').stream().map(itemType2::get).collect(Collectors.toList());
                    scpOrderSettingRespVO.setItemCateNames(itemCateName);
                }
                if (StrUtil.isNotBlank((CharSequence)(deliveryType = scpOrderSettingRespVO.getDeliveryType()))) {
                    String deliveryTypeName = ScpOrderSettingDomainServiceImpl.splitAndConvertDeliveryTypeName(deliveryType, itemType2);
                    scpOrderSettingRespVO.setDeliveryTypeName(deliveryTypeName);
                }
            });
            return new PagingVO(count, demandSet);
        }
        return new PagingVO();
    }

    @NotNull
    private static String splitAndConvertDeliveryTypeName(String deliveryType, Map<String, String> itemType2) {
        List deliveryTypeList = Arrays.stream(deliveryType.split(",")).collect(Collectors.toList());
        return deliveryTypeList.stream().map(itemType2::get).collect(Collectors.joining(","));
    }

    @Override
    @SysCodeProc
    public Optional<ScpOrderSettingDTO> findOrderSettingById(Long id) {
        return this.scpOrderSettingRepo.findById(id).map(row -> {
            ScpOrderSettingDTO scpOrderSettingDTO = ScpOrderSettingConvert.INSTANCE.doToDto((ScpOrderSettingDO)row);
            scpOrderSettingDTO.setItemCates(StrUtil.split((CharSequence)row.getItemCate(), (char)','));
            return scpOrderSettingDTO;
        });
    }

    @Override
    public Long saveOrderSetting(ScpOrderSettingSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpOrderSettingDO intentDO = ScpOrderSettingConvert.INSTANCE.saveVoToDO(saveVO);
            if (CollUtil.isNotEmpty(saveVO.getItemCates())) {
                intentDO.setItemCate(String.join((CharSequence)",", saveVO.getItemCates()));
            }
            Long masId = ((ScpOrderSettingDO)this.scpOrderSettingRepo.save(intentDO)).getId();
            this.redisTemplate.opsForValue().set((Object)(intentDO.getBusinessType() + intentDO.getType()), (Object)JSONUtil.toJsonStr((Object)intentDO));
            return masId;
        }
        Optional<ScpOrderSettingDO> option = this.scpOrderSettingRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u5355\u636e\u7c7b\u578b\u914d\u7f6eID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpOrderSettingDO scpOrderSettingDO = option.get();
        ScpOrderSettingConvert.INSTANCE.copySaveParamToDo(saveVO, scpOrderSettingDO);
        if (CollUtil.isNotEmpty(saveVO.getItemCates())) {
            scpOrderSettingDO.setItemCate(String.join((CharSequence)",", saveVO.getItemCates()));
        } else {
            scpOrderSettingDO.setItemCate(null);
        }
        Long masId = ((ScpOrderSettingDO)this.scpOrderSettingRepo.save(scpOrderSettingDO)).getId();
        this.redisTemplate.opsForValue().set((Object)(scpOrderSettingDO.getBusinessType() + scpOrderSettingDO.getType()), (Object)JSONUtil.toJsonStr((Object)scpOrderSettingDO));
        return masId;
    }

    @Override
    public void enableOrderSetting(List<Long> ids, Boolean enable) {
        this.scpOrderSettingRepoProc.enableDemandSet(ids, enable);
        List<ScpOrderSettingDO> settingDOS = this.scpOrderSettingRepo.findByIdIn(ids);
        settingDOS.forEach(scpOrderSettingDO -> {
            scpOrderSettingDO.setStatus(enable);
            this.redisTemplate.opsForValue().set((Object)(scpOrderSettingDO.getBusinessType() + scpOrderSettingDO.getType()), (Object)JSONUtil.toJsonStr((Object)scpOrderSettingDO));
        });
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        List<ScpOrderSettingDO> settingDOS = this.scpOrderSettingRepo.findByIdIn(ids);
        this.scpOrderSettingRepoProc.deleteByIds(ids);
        settingDOS.forEach(scpOrderSettingDO -> this.redisTemplate.delete((Object)scpOrderSettingDO.getBusinessType()));
    }

    @Override
    public List<ScpOrderSettingRespVO> findByParam(ScpOrderSettingParamVO paramVO) {
        return this.scpOrderSettingRepoProc.findByParam(paramVO);
    }

    @Override
    public List<String> findItemCatesByBusinessType(String businessType, String type) {
        Object cacheData = this.redisTemplate.opsForValue().get((Object)(businessType + type));
        if (cacheData == null) {
            ScpOrderSettingParamVO paramVO = new ScpOrderSettingParamVO();
            paramVO.setBusinessType(businessType);
            paramVO.setType(type);
            List<ScpOrderSettingRespVO> settings = this.scpOrderSettingRepoProc.findByParam(paramVO);
            if (settings.isEmpty()) {
                return new ArrayList<String>();
            }
            cacheData = JSONUtil.toJsonStr((Object)settings.get(0));
            this.redisTemplate.opsForValue().set((Object)(businessType + type), cacheData);
        }
        ScpOrderSettingDO scpOrderSettingDO = (ScpOrderSettingDO)JSON.parseObject((String)((String)cacheData), ScpOrderSettingDO.class);
        return StrUtil.split((CharSequence)scpOrderSettingDO.getItemCate(), (CharSequence)",");
    }

    @Override
    public List<String> findDeliveryTypeByBusinessType(String businessType, String type) {
        Object cacheData = this.redisTemplate.opsForValue().get((Object)(businessType + type));
        if (cacheData == null) {
            ScpOrderSettingParamVO paramVO = new ScpOrderSettingParamVO();
            paramVO.setBusinessType(businessType);
            paramVO.setType(type);
            List<ScpOrderSettingRespVO> settings = this.scpOrderSettingRepoProc.findByParam(paramVO);
            if (settings.isEmpty()) {
                return new ArrayList<String>();
            }
            cacheData = JSONUtil.toJsonStr((Object)settings.get(0));
            this.redisTemplate.opsForValue().set((Object)(businessType + type), cacheData);
        }
        ScpOrderSettingDO scpOrderSettingDO = (ScpOrderSettingDO)JSON.parseObject((String)((String)cacheData), ScpOrderSettingDO.class);
        return StrUtil.split((CharSequence)scpOrderSettingDO.getDeliveryType(), (CharSequence)",");
    }

    @Override
    public ScpOrderSettingRespVO findCacheByBusinessType(String businessType, String type) {
        Object cacheData = this.redisTemplate.opsForValue().get((Object)(businessType + type));
        if (cacheData == null) {
            ScpOrderSettingParamVO paramVO = new ScpOrderSettingParamVO();
            paramVO.setBusinessType(businessType);
            paramVO.setType(type);
            paramVO.setStatus(Boolean.TRUE);
            List<ScpOrderSettingRespVO> settings = this.scpOrderSettingRepoProc.findByParam(paramVO);
            if (settings.isEmpty()) {
                throw new BusinessException("\u8bf7\u5148\u914d\u7f6e\u6216\u542f\u7528\u5355\u636e\u7c7b\u578b" + businessType);
            }
            cacheData = JSONUtil.toJsonStr((Object)settings.get(0));
            this.redisTemplate.opsForValue().set((Object)(businessType + type), cacheData);
        }
        return ScpOrderSettingConvert.INSTANCE.doToRespVO((ScpOrderSettingDO)JSON.parseObject((String)((String)cacheData), ScpOrderSettingDO.class));
    }

    @Override
    public List<ScpOrderSettingRespVO> findCacheByBusinessType(List<String> businessTypeList, String type) {
        ArrayList<ScpOrderSettingRespVO> result = new ArrayList<ScpOrderSettingRespVO>();
        for (String businessType : businessTypeList) {
            ScpOrderSettingRespVO cacheByBusinessType = this.findCacheByBusinessType(businessType, type);
            result.add(cacheByBusinessType);
        }
        return result;
    }

    @Override
    @SysCodeProc
    public List<ScpOrderSettingRespVO> findEnabledSetting() {
        return this.scpOrderSettingRepoProc.findEnabledSetting();
    }

    public ScpOrderSettingDomainServiceImpl(RedisTemplate<String, Object> redisTemplate, RmiSysUDCService rmiSysUDCService, ScpOrderSettingRepo scpOrderSettingRepo, ScpOrderSettingRepoProc scpOrderSettingRepoProc) {
        this.redisTemplate = redisTemplate;
        this.rmiSysUDCService = rmiSysUDCService;
        this.scpOrderSettingRepo = scpOrderSettingRepo;
        this.scpOrderSettingRepoProc = scpOrderSettingRepoProc;
    }
}

