/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayParamDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayParamDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderUpdatePayStatusMqParam;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ScpOrderUpdatePayStatusListener
implements MessageQueueListener<ScpOrderUpdatePayStatusMqParam> {
    private static final Logger log = LoggerFactory.getLogger(ScpOrderUpdatePayStatusListener.class);
    private final TransactionTemplate transactionTemplate;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;

    @NotEmpty
    public String[] channels() {
        return new String[]{"scp_order_update_pay_status"};
    }

    public void onConsume(@NotBlank String s, @NotNull ScpOrderUpdatePayStatusMqParam param) {
        log.info("\u8ba2\u5355\u652f\u4ed8\u66f4\u65b0\u5173\u8054\u5355\u636e\u72b6\u6001\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        if ("PO".equals(param.getDocCls())) {
            PurPoOnlinePayParamDTO payParamDTO = new PurPoOnlinePayParamDTO();
            payParamDTO.setDocNo(param.getDocNo());
            payParamDTO.setOnlinePayAmt(param.getAmt());
            payParamDTO.setOnlinePayOrderNo(param.getPaymentId());
            this.rmiPurRpcService.updateOnlinePay(payParamDTO);
        } else {
            InvTroOnlinePayParamDTO payParamDTO = new InvTroOnlinePayParamDTO();
            payParamDTO.setDocNo(param.getDocNo());
            payParamDTO.setOnlinePayAmt(param.getAmt());
            payParamDTO.setOnlinePayOrderNo(param.getPaymentId());
            this.rmiInvStkRpcService.updateOnlinePay(payParamDTO);
        }
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(transactionStatus -> {
            try {
                this.scpDemandOrderDRepoProc.updateOnlinePayFlagAndPayerNameBySrcDocNo(param.getDocNo(), param.getPayerName(), Boolean.TRUE);
                return "ok";
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u8ba2\u8d27\u5355\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                transactionStatus.setRollbackOnly();
                return "ok";
            }
        });
    }

    public ScpOrderUpdatePayStatusListener(TransactionTemplate transactionTemplate, RmiPurRpcService rmiPurRpcService, RmiInvStkRpcService rmiInvStkRpcService, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc) {
        this.transactionTemplate = transactionTemplate;
        this.rmiPurRpcService = rmiPurRpcService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
    }
}

